% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_if.R
\name{if-statements}
\alias{if-statements}
\alias{pd_is_if}
\alias{pd_get_if_predicate_id}
\alias{pd_get_if_branch_id}
\alias{pd_get_if_alternate_id}
\title{If Statement Nodes}
\usage{
pd_is_if(id, pd, .check = TRUE)

pd_get_if_predicate_id(id, pd, .check = TRUE)

pd_get_if_branch_id(id, pd, .check = TRUE)

pd_get_if_alternate_id(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\value{
an id integer.

an id integer.
}
\description{
These function navigate logic statements.

Returns the id of the predicate of the if statement,
i.e. the conditional statement.

Returns the id of the body of the branch executed if the predicate
evaluates to true.

Gets the id of the alternate branch, i.e. the else branch.
}
\details{
If statements have the form of the following.\preformatted{    if (predicate) branch else alternate
}

The \code{predicate} refers to the logical test being performed.
The \code{branch} is the statement or block that is executed if \code{predicate} evaluates true.
The \code{alternate} is the statement of block that is executed if \code{predicate} returns false.
}
\section{Functions}{
\itemize{
\item \code{pd_is_if}: Is node an if expression.

\item \code{pd_get_if_predicate_id}: Get the predicate node.

\item \code{pd_get_if_branch_id}: Get the \code{branch} statement or block node.

\item \code{pd_get_if_alternate_id}: Get the \code{alternate} statement or block node.
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

# Find the if statement
is.if <- pd_is_if(pd$id, pd=pd)
sum(is.if)
if.id <- pd$id[is.if]

# The predicate
pd_reconstitute(pd_get_if_predicate_id(if.id, pd), pd)

# The branch for if predicate evaluates TRUE
pd_reconstitute(pd_get_if_branch_id(if.id, pd), pd)

# The alternate for if predicate evaluates FALSE
pd_reconstitute(pd_get_if_alternate_id(if.id, pd), pd)


}
