% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest.R
\name{rand_forest}
\alias{rand_forest}
\alias{update.rand_forest}
\title{General Interface for Random Forest Models}
\usage{
rand_forest(mode = "unknown", mtry = NULL, trees = NULL, min_n = NULL)

\method{update}{rand_forest}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{mtry}{An integer for the number of predictors that will
be randomly sampled at each split when creating the tree models.}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{object}{A random forest model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{rand_forest()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{mtry}: The number of predictors that will be
randomly sampled at each split when creating the tree models.
\item \code{trees}: The number of trees contained in the ensemble.
\item \code{min_n}: The minimum number of data points in a node
that are required for the node to be split further.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"ranger"} (the default) or \code{"randomForest"}
\item \pkg{Spark}: \code{"spark"}
}
}
\note{
For models created using the spark engine, there are
several differences to consider. First, only the formula
interface to via \code{fit()} is available; using \code{fit_xy()} will
generate an error. Second, the predictions will always be in a
spark table format. The names will be the same as documented but
without the dots. Third, there is no equivalent to factor
columns in spark tables so class predictions are returned as
character columns. Fourth, to retain the model object for a new
R session (via \code{save}), the \code{model$fit} element of the \code{parsnip}
object should be serialized via \code{ml_save(object$fit)} and
separately saved to disk. In a new session, the object can be
reloaded and reattached to the \code{parsnip} object.
}
\section{Engine Details}{


The standardized parameter names in parsnip can be mapped to their original
names in each engine:\tabular{llll}{
   \strong{parsnip} \tab \strong{ranger} \tab \strong{randomForest} \tab \strong{spark} \cr
   mtry \tab mtry \tab mtry \tab feature_subset_strategy \cr
   trees \tab num.trees \tab ntree \tab num_trees \cr
   min_n \tab min.node.size \tab nodesize \tab min_instances_per_node \cr
}


Engines may have pre-set default arguments when executing the
model fit call. For this type of
model, the template of the fit calls are::

\pkg{ranger} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "classification"), "ranger")}

\pkg{ranger} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "regression"), "ranger")}

\pkg{randomForests} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "classification"), "randomForest")}

\pkg{randomForests} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "regression"), "randomForest")}

\pkg{spark} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "classification"), "spark")}

\pkg{spark} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::rand_forest(mode = "regression"), "spark")}

For \pkg{ranger} confidence intervals, the intervals are
constructed using the form \verb{estimate +/- z * std_error}. For
classification probabilities, these values can fall outside of
\verb{[0, 1]} and will be coerced to be in this range.
}

\examples{
rand_forest(mode = "classification", trees = 2000)
# Parameters can be represented by a placeholder:
rand_forest(mode = "regression", mtry = varying())
model <- rand_forest(mtry = 10, min_n = 3)
model
update(model, mtry = 1)
update(model, mtry = 1, fresh = TRUE)
}
\seealso{
\code{\link[=fit]{fit()}}
}
