% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_glmnet.R
\name{details_linear_reg_glmnet}
\alias{details_linear_reg_glmnet}
\title{Linear regression via glmnet}
\description{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}} uses regularized least squares to fit models with numeric outcomes.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: see below)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 1.0)
}

A value of \code{mixture = 1} corresponds to a pure lasso model, while
\code{mixture = 0} indicates ridge regression.

The \code{penalty} parameter has no default and requires a single numeric
value. For more details about this, and the \code{glmnet} model in general,
see \link{glmnet-details}.
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{linear_reg(penalty = double(1), mixture = double(1)) |> 
  set_engine("glmnet") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = 0
##   mixture = double(1)
## 
## Computational engine: glmnet 
## 
## Model fit template:
## glmnet::glmnet(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     alpha = double(1), family = "gaussian")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one. By default, \code{\link[glmnet:glmnet]{glmnet::glmnet()}} uses
the argument \code{standardize = TRUE} to center and scale the data.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Sparse Data}{

This model can utilize sparse data during model fitting and prediction.
Both sparse matrices such as dgCMatrix from the \code{Matrix} package and
sparse tibbles from the \code{sparsevctrs} package are supported. See
\link{sparse_data} for more information.
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#linear-reg-glmnet}{examples}
for \code{linear_reg()} with the \code{"glmnet"} engine.
}

\subsection{References}{
\itemize{
\item Hastie, T, R Tibshirani, and M Wainwright. 2015. \emph{Statistical Learning
with Sparsity}. CRC Press.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
