% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RA_output}
\alias{RA_output}
\title{Example Output for the pathfindR Enrichment Workflow - Rheumatoid Arthritis}
\format{
A data frame with 113 rows and 9 columns:
\describe{
\item{ID}{ID of the enriched term}
\item{Term_Description}{Description of the enriched term}
\item{Fold_Enrichment}{Fold enrichment value for the enriched term}
\item{occurrence}{the number of iterations that the given term was found to enriched over all iterations}
\item{support}{the median support (proportion of active subnetworks leading to enrichment within an iteration) over all iterations}
\item{lowest_p}{the lowest adjusted-p value of the given term over all iterations}
\item{highest_p}{the highest adjusted-p value of the given term over all iterations}
\item{Up_regulated}{the up-regulated genes in the input involved in the given term, comma-separated}
\item{Down_regulated}{the down-regulated genes in the input involved in the given term, comma-separated}
}
}
\usage{
RA_output
}
\description{
The data frame containing the results of pathfindR's active-subnetwork-oriented
enrichment workflow performed on the rheumatoid arthritis
differential-expression data frame \code{\link{RA_input}}. Analysis via
\code{run_pathfindR} was performed using the default settings.
\emph{Generated on Aug 20, 2021.}
}
\seealso{
\code{\link{RA_input}}  for the RA differentially-expressed genes data frame
\code{\link{RA_clustered}} for the RA example pathfindR clustering outputs
\code{\link{RA_exp_mat}} for the RA differentially-expressed genes expression matrix
\code{\link[pathfindR]{run_pathfindR}} for details on the pathfindR enrichment analysis
}
\keyword{datasets}
