% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{visualize_hsa_KEGG}
\alias{visualize_hsa_KEGG}
\title{Visualize Human KEGG Pathways}
\usage{
visualize_hsa_KEGG(pw_table, gene_data)
}
\arguments{
\item{pw_table}{Data frame of enrichment results. Must-have columns are: "ID" and
"Pathway".}

\item{gene_data}{Single column data frame containing change values (e.g.
log(fold change) values) for significant genes. Row names are gene symbols.}
}
\value{
Creates visualizations of the pathways with the package \code{pathview}
 and saves them in the folder "pathway_visualizations" under the current working directory.
}
\description{
Visualize Human KEGG Pathways
}
\examples{
\dontrun{
visualize_hsa_KEGG(pathway_table, gene_data)
}
}
\seealso{
\code{\link[pathview]{pathview}} for KEGG pathway-based data integration
  and visualization. See \code{\link{visualize_pws}} for the wrapper function
  for creating pathway diagrams. See \code{\link{run_pathfindR}} for the
  wrapper function of the pathfindR workflow.
}
