% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{standardize_path}
\alias{standardise_path}
\alias{standardize_path}
\title{Standardize paths}
\usage{
standardize_path(x = dir(), sep = c("/", "\\\\"), include_names = TRUE)

standardise_path(x = dir(), sep = c("/", "\\\\"), include_names = TRUE)
}
\arguments{
\item{x}{A character vector of file paths. Defaults to files in the 
current directory.}

\item{sep}{String separator between directory levels in the output.}

\item{include_names}{A logical value indicating whether the output should be 
named with the input file paths.}
}
\value{
A character vector of paths, pointing to the same locations as the
input, but in a standardized form.
}
\description{
Standardi[sz]e path names so that they can be more easily compared.
}
\examples{
standardize_path(c(".", "..", "~", R.home(), NA))
standardize_path(c(".", "..", "~", R.home(), NA), "\\\\")
}
\seealso{
\code{\link[base]{normalizePath}}, \code{\link[base]{path.expand}},
\code{\link[R.utils]{getAbsolutePath}}
}

