% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{insert_treatments}
\alias{insert_treatments}
\title{Inserts treatment and experiment information}
\usage{
insert_treatments(
  obj_name,
  tunnel_config = "box",
  perch_2_vertex = NULL,
  vertex_angle = NULL,
  tunnel_width = NULL,
  tunnel_length = NULL,
  stim_param_lat_pos = NULL,
  stim_param_lat_neg = NULL,
  stim_param_end_pos = NULL,
  stim_param_end_neg = NULL,
  treatment = NULL
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{tunnel_config}{The configuration of the experimental tunnel.
Currently, pathviewr supports rectangular "box" and V-shaped tunnel
configurations.}

\item{perch_2_vertex}{If using a V-shaped tunnel, this is the vertical
distance between the vertex and the height of the perches. If the tunnel does
not have perches, insert the vertical distance between the vertex and the
height of the origin (0,0,0).}

\item{vertex_angle}{If using a V-shaped tunnel, the angle of the vertex (in
degrees) \code{vertex_angle} defaults to 90.}

\item{tunnel_width}{If using a box-shaped tunnel, the width of the tunnel.}

\item{tunnel_length}{The length of the tunnel.}

\item{stim_param_lat_pos}{The size of the stimulus on the lateral positive
wall of the tunnel. Eg. for 10cm wide gratings,
\code{stim_param_lat_pos} = 0.1.}

\item{stim_param_lat_neg}{The size of the stimulus on the lateral negative
wall of the tunnel..}

\item{stim_param_end_pos}{The size of the stimulus on the end positive
wall of the tunnel.}

\item{stim_param_end_neg}{The size of the stimulus on the end negative
wall of the tunnel.}

\item{treatment}{The name of the treatment assigned to all rows of the viewr
object. Currently only able to accept a single treatment per viewr data
object.}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"treatments added"}). Depending
on the argument \code{tunnel_config}, the viewr object also includes
columns storing the values of the supplied arguments. This experimental
information is also stored in the viewr object's metadata
}
\description{
Adds information about treatment and experimental set up to viewr objects for
analysis in other pathviewr functions
}
\details{
All length measurements reported in meters.
}
\examples{
 ## Import sample data from package
 motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))
 flydra_data <-
 read_flydra_mat(system.file("extdata", "pathviewr_flydra_example_data.mat",
                              package = 'pathviewr'),
                              subject_name = "birdie_sanders")

  ## Clean data up to and including get_full_trajectories()
motive_data_full <-
 motive_data \%>\%
 relabel_viewr_axes() \%>\%
 gather_tunnel_data() \%>\%
 trim_tunnel_outliers() \%>\%
 rotate_tunnel() \%>\%
 select_x_percent(desired_percent = 50) \%>\%
 separate_trajectories(max_frame_gap = "autodetect") \%>\%
 get_full_trajectories(span = 0.95)

 flydra_data_full <-
  flydra_data \%>\%
  redefine_tunnel_center(length_method = "middle",
                        height_method = "user-defined",
                        height_zero = 1.44) \%>\%
  select_x_percent(desired_percent = 50) \%>\%
  separate_trajectories(max_frame_gap = "autodetect") \%>\%
  get_full_trajectories(span = 0.95)


## Now add information about the experimental configuration. In this example,
## a V-shaped tunnel in which the vertex is 90deg and lies 0.40m below the
## origin. The visual stimuli on the lateral and end walls have a cycle
## length of 0.1m and 0.3m respectively, and the treatment is labeled
## "lat10_end30"

motive_v <-
motive_data_full \%>\%
 insert_treatments(tunnel_config = "v",
                   perch_2_vertex = 0.4,
                   vertex_angle = 90,
                   tunnel_length = 2,
                   stim_param_lat_pos = 0.1,
                   stim_param_lat_neg = 0.1,
                   stim_param_end_pos = 0.3,
                   stim_param_end_neg = 0.3,
                   treatment = "lat10_end_30")

# For an experiment using the box-shaped configuration where the tunnel is 1m
# wide and 3m long and the visual stimuli on the lateral and end walls have a
# cycle length of 0.2 and 0.3m, respectively, and the treatment is labeled
# "lat20_end30".

flydra_box <-
 flydra_data_full \%>\%
 insert_treatments(tunnel_config = "box",
                   tunnel_width = 1,
                   tunnel_length = 3,
                   stim_param_lat_pos = 0.2,
                   stim_param_lat_neg = 0.2,
                   stim_param_end_pos = 0.3,
                   stim_param_end_neg = 0.3,
                   treatment = "lat20_end30")

## Check out the new columns in the resulting objects
names(motive_v)
names(flydra_box)
}
\author{
Eric R. Press
}
\concept{utility functions}
