% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertSignatureToValueOutOfSample.R
\name{convertSignatureToValueOutOfSample}
\alias{convertSignatureToValueOutOfSample}
\title{Convert Out-of-Sample Signature to Predicted Values}
\usage{
convertSignatureToValueOutOfSample(
  E,
  tau,
  Y_pred_last,
  i,
  h,
  predictedSignatureY
)
}
\arguments{
\item{E}{Integer, the number of future values to predict.}

\item{tau}{Integer, the time delay used in the system dynamics; while not used directly in this function, it is relevant in the broader context of the methodology for embedding time series data.}

\item{Y_pred_last}{Numeric, the last predicted value from which future values will be extrapolated.}

\item{i}{Integer, the starting index for the prediction; not used in this function but generally important in the broader algorithm.}

\item{h}{Integer, the horizon step from the last known actual value to the first prediction point; not used directly in this function but part of the overall predictive framework.}

\item{predictedSignatureY}{Numeric vector, the predicted incremental changes (signature) at each step used for extrapolation of the series.}
}
\value{
Numeric vector containing the extrapolated future values of the series, starting from Y_pred_last and extending for E steps, adjusted by the predicted signature changes.
}
\description{
This function predicts future values for a time series starting from the last known predicted value. It uses a series of predicted signature changes to extrapolate future values, assuming that changes continue in a similar manner to the signatures provided. This is particularly useful in scenarios where short-term predictions are made in complex systems based on embedded dynamic structures as described in the associated literature.
}
\examples{
# Suppose Y_pred_last is the last known predicted value of a financial time series
Y_pred_last <- 120
# Assume predicted signature changes based on a model's output
predictedSignatureY <- c(2, 3, 4, 5, 6)
# Number of future points to predict
E <- 5
# Example values for tau and i, h not used in this function directly
tau <- 1
i <- 1
h <- 1

# Generate future predictions
futureValues <- convertSignatureToValueOutOfSample(E, tau, Y_pred_last, i, h, predictedSignatureY)
print(futureValues)
}
