% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coldist2mat.R
\name{coldist2mat}
\alias{coldist2mat}
\title{Convert coldist to distance matrix}
\usage{
coldist2mat(coldistres)
}
\arguments{
\item{coldistres}{(required) the output from a \code{coldist} call.}
}
\value{
A list containing one or two matrices, for dS and dL, depending
if the original object had dS and dL columns
}
\description{
Converts a \code{coldist} output into a distance matrix where samples 
are rows and columns.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, achro=TRUE)
cd.flowers <- coldist(vis.flowers)
coldist2mat(cd.flowers)[['dS']]
coldist2mat(cd.flowers)[['dL']]
}

}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
\keyword{internal}
