% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcsplot.R, R/tcspoints.R, R/tcsvol.R
\name{tcsplot}
\alias{tcsplot}
\alias{tcspoints}
\alias{tcsvol}
\title{Interactive plot of a tetrahedral colourspace}
\usage{
tcsplot(
  tcsdata,
  size = 0.02,
  alpha = 1,
  col = "black",
  vertexsize = 0.02,
  achro = TRUE,
  achrosize = 0.01,
  achrocol = "grey",
  lwd = 1,
  lcol = "lightgrey",
  new = FALSE,
  hspin = FALSE,
  vspin = FALSE,
  floor = TRUE,
  gamut = FALSE
)

tcspoints(tcsdata, size = 0.02, col = "black", alpha = 1)

tcsvol(
  tcsdata,
  type = c("convex", "alpha"),
  avalue = "auto",
  col = "black",
  alpha = 0.2,
  grid.alpha = 1,
  grid = TRUE,
  fill = TRUE,
  lwd = 1
)
}
\arguments{
\item{tcsdata}{(required) a data frame, possibly a result from the
\code{\link[=colspace]{colspace()}} or \code{\link[=tcspace]{tcspace()}} function, containing values for the 'x', 'y'
and 'z' coordinates as columns (labeled as such).}

\item{size}{size of the points in the plot (defaults to 0.02)}

\item{alpha}{transparency of points (or volume fill in \code{\link[=tcsvol]{tcsvol()}})}

\item{col}{colour of the points in the plot (defaults to black)}

\item{vertexsize}{size of the points at the vertices}

\item{achro}{should a point be plotted at the origin (defaults to \code{TRUE})?}

\item{achrosize}{size of the point at the origin when \code{achro = TRUE}
(defaults to \code{0.8}).}

\item{achrocol}{color of the point at the origin \code{achro = TRUE} (defaults to
\code{'grey'}).}

\item{lwd, lcol}{graphical parameters for the edges of the tetrahedron.}

\item{new}{should a new 3D plot be called (defaults to \code{FALSE})?}

\item{hspin}{if \code{TRUE}, the graphic will spin horizontally (around the 'z' axis)(defaults to \code{FALSE})}

\item{vspin}{if \code{TRUE}, the graphic will spin vertically (around the 'x' axis)(defaults to \code{FALSE})}

\item{floor}{if \code{TRUE}, a reference xy plane is plotted under the tetrahedron (defaults to \code{TRUE})}

\item{gamut}{logical. Should the polygon showing the possible colours given
visual system and illuminant used in the analysis (defaults to \code{FALSE}).
This option currently only works when \code{qcatch = Qi}.}

\item{type}{accepts a vector of length 1 or 2 with 'p' for points and/or 'l'
for lines from the point to the base of the tetrahedron.}

\item{avalue}{if \code{type = "alpha"}, which alpha parameter value should be used
to compute the alphashape. \code{avalue = "auto"} (default) finds and use the
\ifelse{html}{\out{&alpha;*}}{\eqn{$\alpha^*$}{alpha*}} value as defined in
Gruson (2020).}

\item{grid.alpha}{transparency of the volume polygon grid lines}

\item{grid}{if \code{TRUE}, connects the polygon outlining the volume occupied by points (defaults to \code{TRUE})}

\item{fill}{if \code{TRUE}, fills the volume occupied by points (WARNING: transparency
is not saved properly if exported using \code{rgl.postscript})(defaults to \code{TRUE}).}
}
\value{
\code{\link[=tcsplot]{tcsplot()}} creates a 3D plot using functions of the package \pkg{rgl},
based on openGL capabilities. Plot is interactive and can be manipulated with the mouse
(left button: rotate along 'z' axis; right button: rotate along 'x' axis;
third button: zoom).

\code{\link[=tcspoints]{tcspoints()}} adds points to the plot. Points are currently plotted
only as spheres to maintain export capabilities.

\code{\link[=tcsvol]{tcsvol()}} creates a 3D colour volume within a \code{tcsplot} object.
}
\description{
Produces an interactive 3D plot of a tetrahedral colourspace using OpenGL
capabilities.

Plots points in a tetrahedral colour space
}
\examples{
if (interactive()) {
# For plotting
data(sicalis)
vis.sicalis <- vismodel(sicalis, visual = "avg.uv")
tcs.sicalis <- colspace(vis.sicalis, space = "tcs")
tcsplot(tcs.sicalis, size = 0.005)
rgl::rgl.postscript("testplot.pdf", fmt = "pdf")
rgl::rgl.snapshot("testplot.png")

# For adding points
patch <- rep(c("C", "T", "B"), 7)
tcs.crown <- subset(tcs.sicalis, "C")
tcs.breast <- subset(tcs.sicalis, "B")
tcsplot(tcs.crown, col = "blue")
tcspoints(tcs.breast, col = "red")

# For plotting convex hull
tcsplot(tcs.sicalis, col = "blue", size = 0.005)
tcsvol(tcs.sicalis)
}

}
\references{
Stoddard, M. C., & Prum, R. O. (2008). Evolution of avian plumage
color in a tetrahedral color space: A phylogenetic analysis of new world buntings.
The American Naturalist, 171(6), 755-776.

Endler, J. A., & Mielke, P. (2005). Comparing entire colour patterns
as birds see them. Biological Journal Of The Linnean Society, 86(4), 405-431.
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
