% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_theme}
\alias{quicksight_update_theme}
\title{Updates a theme}
\usage{
quicksight_update_theme(AwsAccountId, ThemeId, Name, BaseThemeId,
  VersionDescription, Configuration)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the theme that you're updating.}

\item{ThemeId}{[required] The ID for the theme.}

\item{Name}{The name for the theme.}

\item{BaseThemeId}{[required] The theme ID, defined by Amazon QuickSight, that a custom theme inherits
from. All themes initially inherit from a default QuickSight theme.}

\item{VersionDescription}{A description of the theme version that you're updating Every time that
you call \code{UpdateTheme}, you create a new version of the theme. Each
version of the theme maintains a description of the version in
\code{VersionDescription}.}

\item{Configuration}{The theme configuration, which contains the theme display properties.}
}
\description{
Updates a theme.
}
\section{Request syntax}{
\preformatted{svc$update_theme(
  AwsAccountId = "string",
  ThemeId = "string",
  Name = "string",
  BaseThemeId = "string",
  VersionDescription = "string",
  Configuration = list(
    DataColorPalette = list(
      Colors = list(
        "string"
      ),
      MinMaxGradient = list(
        "string"
      ),
      EmptyFillColor = "string"
    ),
    UIColorPalette = list(
      PrimaryForeground = "string",
      PrimaryBackground = "string",
      SecondaryForeground = "string",
      SecondaryBackground = "string",
      Accent = "string",
      AccentForeground = "string",
      Danger = "string",
      DangerForeground = "string",
      Warning = "string",
      WarningForeground = "string",
      Success = "string",
      SuccessForeground = "string",
      Dimension = "string",
      DimensionForeground = "string",
      Measure = "string",
      MeasureForeground = "string"
    ),
    Sheet = list(
      Tile = list(
        Border = list(
          Show = TRUE|FALSE
        )
      ),
      TileLayout = list(
        Gutter = list(
          Show = TRUE|FALSE
        ),
        Margin = list(
          Show = TRUE|FALSE
        )
      )
    )
  )
)
}
}

\keyword{internal}
