% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_studio_session_mappings}
\alias{emr_list_studio_session_mappings}
\title{The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change}
\usage{
emr_list_studio_session_mappings(StudioId, IdentityType, Marker)
}
\arguments{
\item{StudioId}{The ID of the Amazon EMR Studio.}

\item{IdentityType}{Specifies whether to return session mappings for users or groups. If not
specified, the results include session mapping details for both users
and groups.}

\item{Marker}{The pagination token that indicates the set of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  SessionMappings = list(
    list(
      StudioId = "string",
      IdentityId = "string",
      IdentityName = "string",
      IdentityType = "USER"|"GROUP",
      SessionPolicyArn = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change.

Returns a list of all user or group session mappings for the EMR Studio
specified by \code{StudioId}.
}
\section{Request syntax}{
\preformatted{svc$list_studio_session_mappings(
  StudioId = "string",
  IdentityType = "USER"|"GROUP",
  Marker = "string"
)
}
}

\keyword{internal}
