% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_workflow}
\alias{glue_create_workflow}
\title{Creates a new workflow}
\usage{
glue_create_workflow(Name, Description, DefaultRunProperties, Tags,
  MaxConcurrentRuns)
}
\arguments{
\item{Name}{[required] The name to be assigned to the workflow. It should be unique within your
account.}

\item{Description}{A description of the workflow.}

\item{DefaultRunProperties}{A collection of properties to be used as part of each execution of the
workflow.}

\item{Tags}{The tags to be used with this workflow.}

\item{MaxConcurrentRuns}{You can use this parameter to prevent unwanted multiple updates to data,
to control costs, or in some cases, to prevent exceeding the maximum
number of concurrent runs of any of the component jobs. If you leave
this parameter blank, there is no limit to the number of concurrent
workflow runs.}
}
\value{
A list with the following syntax:\preformatted{list(
  Name = "string"
)
}
}
\description{
Creates a new workflow.
}
\section{Request syntax}{
\preformatted{svc$create_workflow(
  Name = "string",
  Description = "string",
  DefaultRunProperties = list(
    "string"
  ),
  Tags = list(
    "string"
  ),
  MaxConcurrentRuns = 123
)
}
}

\keyword{internal}
