% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_database}
\alias{glue_get_database}
\title{Retrieves the definition of a specified database}
\usage{
glue_get_database(CatalogId, Name)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which the database resides. If none is
provided, the AWS account ID is used by default.}

\item{Name}{[required] The name of the database to retrieve. For Hive compatibility, this
should be all lowercase.}
}
\value{
A list with the following syntax:\preformatted{list(
  Database = list(
    Name = "string",
    Description = "string",
    LocationUri = "string",
    Parameters = list(
      "string"
    ),
    CreateTime = as.POSIXct(
      "2015-01-01"
    ),
    CreateTableDefaultPermissions = list(
      list(
        Principal = list(
          DataLakePrincipalIdentifier = "string"
        ),
        Permissions = list(
          "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
        )
      )
    ),
    TargetDatabase = list(
      CatalogId = "string",
      DatabaseName = "string"
    ),
    CatalogId = "string"
  )
)
}
}
\description{
Retrieves the definition of a specified database.
}
\section{Request syntax}{
\preformatted{svc$get_database(
  CatalogId = "string",
  Name = "string"
)
}
}

\keyword{internal}
