% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_register_stream_consumer}
\alias{kinesis_register_stream_consumer}
\title{Registers a consumer with a Kinesis data stream}
\usage{
kinesis_register_stream_consumer(StreamARN, ConsumerName)
}
\arguments{
\item{StreamARN}{[required] The ARN of the Kinesis data stream that you want to register the
consumer with. For more info, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}.}

\item{ConsumerName}{[required] For a given Kinesis data stream, each consumer must have a unique name.
However, consumer names don't have to be unique across data streams.}
}
\description{
Registers a consumer with a Kinesis data stream. When you use this operation, the consumer you register can then call SubscribeToShard to receive data from the stream using enhanced fan-out, at a rate of up to 2 MiB per second for every shard you subscribe to. This rate is unaffected by the total number of consumers that read from the same stream.

See \url{https://paws-r.github.io/docs/kinesis/register_stream_consumer.html} for full documentation.
}
\keyword{internal}
