% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_theme}
\alias{quicksight_update_theme}
\title{Updates a theme}
\usage{
quicksight_update_theme(
  AwsAccountId,
  ThemeId,
  Name = NULL,
  BaseThemeId,
  VersionDescription = NULL,
  Configuration = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that contains the theme that
you're updating.}

\item{ThemeId}{[required] The ID for the theme.}

\item{Name}{The name for the theme.}

\item{BaseThemeId}{[required] The theme ID, defined by Amazon QuickSight, that a custom theme inherits
from. All themes initially inherit from a default Amazon QuickSight
theme.}

\item{VersionDescription}{A description of the theme version that you're updating Every time that
you call \code{\link[=quicksight_update_theme]{update_theme}}, you create a new
version of the theme. Each version of the theme maintains a description
of the version in \code{VersionDescription}.}

\item{Configuration}{The theme configuration, which contains the theme display properties.}
}
\description{
Updates a theme.

See \url{https://www.paws-r-sdk.com/docs/quicksight_update_theme/} for full documentation.
}
\keyword{internal}
