% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_transit_gateway_route_table_propagations}
\alias{ec2_get_transit_gateway_route_table_propagations}
\title{Gets information about the route table propagations for the specified
transit gateway route table}
\usage{
ec2_get_transit_gateway_route_table_propagations(
  TransitGatewayRouteTableId, Filters, MaxResults, NextToken, DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The resource type (\code{vpc} \| \code{vpn}).
\item \code{transit-gateway-attachment-id} - The ID of the attachment.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Gets information about the route table propagations for the specified
transit gateway route table.
}
\section{Request syntax}{
\preformatted{svc$get_transit_gateway_route_table_propagations(
  TransitGatewayRouteTableId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
