% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_cancel_spot_instance_requests}
\alias{ec2_cancel_spot_instance_requests}
\title{Cancels one or more Spot Instance requests}
\usage{
ec2_cancel_spot_instance_requests(DryRun, SpotInstanceRequestIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SpotInstanceRequestIds}{[required] One or more Spot Instance request IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  CancelledSpotInstanceRequests = list(
    list(
      SpotInstanceRequestId = "string",
      State = "active"|"open"|"closed"|"cancelled"|"completed"
    )
  )
)
}
}
\description{
Cancels one or more Spot Instance requests.

Canceling a Spot Instance request does not terminate running Spot
Instances associated with the request.
}
\section{Request syntax}{
\preformatted{svc$cancel_spot_instance_requests(
  DryRun = TRUE|FALSE,
  SpotInstanceRequestIds = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example cancels a Spot Instance request.
svc$cancel_spot_instance_requests(
  SpotInstanceRequestIds = list(
    "sir-08b93456"
  )
)
}

}
\keyword{internal}
