% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint}
\alias{ec2_create_vpc_endpoint}
\title{Creates a VPC endpoint for a specified service}
\usage{
ec2_create_vpc_endpoint(DryRun, VpcEndpointType, VpcId, ServiceName,
  PolicyDocument, RouteTableIds, SubnetIds, SecurityGroupIds, ClientToken,
  PrivateDnsEnabled)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointType}{The type of endpoint.

Default: Gateway}

\item{VpcId}{[required] The ID of the VPC in which the endpoint will be used.}

\item{ServiceName}{[required] The service name. To get a list of available services, use the
DescribeVpcEndpointServices request, or get the name from the service
provider.}

\item{PolicyDocument}{A policy to attach to the endpoint that controls access to the service.
The policy must be in valid JSON format. If this parameter is not
specified, we attach a default policy that allows full access to the
service.}

\item{RouteTableIds}{(Gateway endpoint) One or more route table IDs.}

\item{SubnetIds}{(Interface endpoint) The ID of one or more subnets in which to create an
endpoint network interface.}

\item{SecurityGroupIds}{(Interface endpoint) The ID of one or more security groups to associate
with the endpoint network interface.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicate whether to associate a private hosted zone
with the specified VPC. The private hosted zone contains a record set
for the default public DNS name for the service for the Region (for
example, \code{kinesis.us-east-1.amazonaws.com}) which resolves to the
private IP addresses of the endpoint network interfaces in the VPC. This
enables you to make requests to the default public DNS name for the
service instead of the public DNS names that are automatically generated
by the VPC endpoint service.

To use a private hosted zone, you must set the following VPC attributes
to \code{true}: \code{enableDnsHostnames} and \code{enableDnsSupport}. Use
ModifyVpcAttribute to set the VPC attributes.

Default: \code{true}}
}
\description{
Creates a VPC endpoint for a specified service. An endpoint enables you
to create a private connection between your VPC and the service. The
service may be provided by AWS, an AWS Marketplace partner, or another
AWS account. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html}{VPC Endpoints}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\details{
A \code{gateway} endpoint serves as a target for a route in your route table
for traffic destined for the AWS service. You can specify an endpoint
policy to attach to the endpoint that will control access to the service
from your VPC. You can also specify the VPC route tables that use the
endpoint.

An \code{interface} endpoint is a network interface in your subnet that
serves as an endpoint for communicating with the specified service. You
can specify the subnets in which to create an endpoint, and the security
groups to associate with the endpoint network interface.

Use DescribeVpcEndpointServices to get a list of supported services.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_endpoint(
  DryRun = TRUE|FALSE,
  VpcEndpointType = "Interface"|"Gateway",
  VpcId = "string",
  ServiceName = "string",
  PolicyDocument = "string",
  RouteTableIds = list(
    "string"
  ),
  SubnetIds = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  ClientToken = "string",
  PrivateDnsEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
