% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpc}
\alias{ec2_delete_vpc}
\title{Deletes the specified VPC}
\usage{
ec2_delete_vpc(VpcId, DryRun)
}
\arguments{
\item{VpcId}{[required] The ID of the VPC.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes the specified VPC. You must detach or delete all gateways and
resources that are associated with the VPC before you can delete it. For
example, you must terminate all instances running in the VPC, delete all
security groups associated with the VPC (except the default one), delete
all route tables associated with the VPC (except the default one), and
so on.
}
\section{Request syntax}{
\preformatted{svc$delete_vpc(
  VpcId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example deletes the specified VPC.
\donttest{svc$delete_vpc(
  VpcId = "vpc-a01106c2"
)}

}
\keyword{internal}
