% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_ebs_encryption_by_default}
\alias{ec2_enable_ebs_encryption_by_default}
\title{Enables EBS encryption by default for your account in the current Region}
\usage{
ec2_enable_ebs_encryption_by_default(DryRun)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables EBS encryption by default for your account in the current
Region.
}
\details{
After you enable encryption by default, the EBS volumes that you create
are are always encrypted, either using the default CMK or the CMK that
you specified when you created each volume. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

You can specify the default CMK for encryption by default using
ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId.

Enabling encryption by default has no effect on the encryption status of
your existing volumes.

After you enable encryption by default, you can no longer launch
instances using instance types that do not support encryption. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances}{Supported Instance Types}.
}
\section{Request syntax}{
\preformatted{svc$enable_ebs_encryption_by_default(
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
