% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_start_task}
\alias{ecs_start_task}
\title{Starts a new task from the specified task definition on the specified
container instance or instances}
\usage{
ecs_start_task(cluster, taskDefinition, overrides, containerInstances,
  startedBy, group, networkConfiguration, tags, enableECSManagedTags,
  propagateTags)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster on
which to start your task. If you do not specify a cluster, the default
cluster is assumed.}

\item{taskDefinition}{[required] The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task
definition to start. If a \code{revision} is not specified, the latest
\code{ACTIVE} revision is used.}

\item{overrides}{A list of container overrides in JSON format that specify the name of a
container in the specified task definition and the overrides it should
receive. You can override the default command for a container (that is
specified in the task definition or Docker image) with a \code{command}
override. You can also override existing environment variables (that are
specified in the task definition or Docker image) on a container or add
new environment variables to it with an \code{environment} override.

A total of 8192 characters are allowed for overrides. This limit
includes the JSON formatting characters of the override structure.}

\item{containerInstances}{[required] The container instance IDs or full ARN entries for the container
instances on which you would like to place your task. You can specify up
to 10 container instances.}

\item{startedBy}{An optional tag specified when a task is started. For example, if you
automatically trigger a task to run a batch process job, you could apply
a unique identifier for that job to your task with the \code{startedBy}
parameter. You can then identify which tasks belong to that job by
filtering the results of a ListTasks call with the \code{startedBy} value. Up
to 36 letters (uppercase and lowercase), numbers, hyphens, and
underscores are allowed.

If a task is started by an Amazon ECS service, then the \code{startedBy}
parameter contains the deployment ID of the service that starts it.}

\item{group}{The name of the task group to associate with the task. The default value
is the family name of the task definition (for example,
family:my-family-name).}

\item{networkConfiguration}{The VPC subnet and security group configuration for tasks that receive
their own elastic network interface by using the \code{awsvpc} networking
mode.}

\item{tags}{The metadata that you apply to the task to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define. Tag keys can have a maximum character length of 128
characters, and tag values can have a maximum length of 256 characters.}

\item{enableECSManagedTags}{Specifies whether to enable Amazon ECS managed tags for the task. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging Your Amazon ECS Resources}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{propagateTags}{Specifies whether to propagate the tags from the task definition or the
service to the task. If no value is specified, the tags are not
propagated.}
}
\description{
Starts a new task from the specified task definition on the specified
container instance or instances.
}
\details{
Alternatively, you can use RunTask to place tasks for you. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html}{Scheduling Tasks}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_task(
  cluster = "string",
  taskDefinition = "string",
  overrides = list(
    containerOverrides = list(
      list(
        name = "string",
        command = list(
          "string"
        ),
        environment = list(
          list(
            name = "string",
            value = "string"
          )
        ),
        cpu = 123,
        memory = 123,
        memoryReservation = 123,
        resourceRequirements = list(
          list(
            value = "string",
            type = "GPU"
          )
        )
      )
    ),
    taskRoleArn = "string",
    executionRoleArn = "string"
  ),
  containerInstances = list(
    "string"
  ),
  startedBy = "string",
  group = "string",
  networkConfiguration = list(
    awsvpcConfiguration = list(
      subnets = list(
        "string"
      ),
      securityGroups = list(
        "string"
      ),
      assignPublicIp = "ENABLED"|"DISABLED"
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  enableECSManagedTags = TRUE|FALSE,
  propagateTags = "TASK_DEFINITION"|"SERVICE"
)
}
}

\keyword{internal}
