% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_traffic_mirror_filter_rule}
\alias{ec2_modify_traffic_mirror_filter_rule}
\title{Modifies the specified Traffic Mirror rule}
\usage{
ec2_modify_traffic_mirror_filter_rule(TrafficMirrorFilterRuleId,
  TrafficDirection, RuleNumber, RuleAction, DestinationPortRange,
  SourcePortRange, Protocol, DestinationCidrBlock, SourceCidrBlock,
  Description, RemoveFields, DryRun)
}
\arguments{
\item{TrafficMirrorFilterRuleId}{[required] The ID of the Traffic Mirror rule.}

\item{TrafficDirection}{The type of traffic (\code{ingress} \| \code{egress}) to assign to the rule.}

\item{RuleNumber}{The number of the Traffic Mirror rule. This number must be unique for
each Traffic Mirror rule in a given direction. The rules are processed
in ascending order by rule number.}

\item{RuleAction}{The action to assign to the rule.}

\item{DestinationPortRange}{The destination ports that are associated with the Traffic Mirror rule.}

\item{SourcePortRange}{The port range to assign to the Traffic Mirror rule.}

\item{Protocol}{The protocol, for example TCP, to assign to the Traffic Mirror rule.}

\item{DestinationCidrBlock}{The destination CIDR block to assign to the Traffic Mirror rule.}

\item{SourceCidrBlock}{The source CIDR block to assign to the Traffic Mirror rule.}

\item{Description}{The description to assign to the Traffic Mirror rule.}

\item{RemoveFields}{The properties that you want to remove from the Traffic Mirror filter
rule.

When you remove a property from a Traffic Mirror filter rule, the
property is set to the default.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the specified Traffic Mirror rule.
}
\details{
\code{DestinationCidrBlock} and \code{SourceCidrBlock} must both be an IPv4 range
or an IPv6 range.
}
\section{Request syntax}{
\preformatted{svc$modify_traffic_mirror_filter_rule(
  TrafficMirrorFilterRuleId = "string",
  TrafficDirection = "ingress"|"egress",
  RuleNumber = 123,
  RuleAction = "accept"|"reject",
  DestinationPortRange = list(
    FromPort = 123,
    ToPort = 123
  ),
  SourcePortRange = list(
    FromPort = 123,
    ToPort = 123
  ),
  Protocol = 123,
  DestinationCidrBlock = "string",
  SourceCidrBlock = "string",
  Description = "string",
  RemoveFields = list(
    "destination-port-range"|"source-port-range"|"protocol"|"description"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
