% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_reboot_instances}
\alias{ec2_reboot_instances}
\title{Requests a reboot of the specified instances}
\usage{
ec2_reboot_instances(InstanceIds, DryRun)
}
\arguments{
\item{InstanceIds}{[required] The instance IDs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Requests a reboot of the specified instances. This operation is
asynchronous; it only queues a request to reboot the specified
instances. The operation succeeds if the instances are valid and belong
to you. Requests to reboot terminated instances are ignored.
}
\details{
If an instance does not cleanly shut down within four minutes, Amazon
EC2 performs a hard reboot.

For more information about troubleshooting, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html}{Getting Console Output and Rebooting Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$reboot_instances(
  InstanceIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example reboots the specified EC2 instance.
svc$reboot_instances(
  InstanceIds = list(
    "i-1234567890abcdef5"
  )
)
}

}
\keyword{internal}
