% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_services}
\alias{ecs_list_services}
\title{Lists the services that are running in a specified cluster}
\usage{
ecs_list_services(cluster, nextToken, maxResults, launchType,
  schedulingStrategy)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the services to list. If you do not specify a cluster, the default
cluster is assumed.}

\item{nextToken}{The \code{nextToken} value returned from a \code{ListServices} request indicating
that more results are available to fulfill the request and further calls
will be needed. If \code{maxResults} was provided, it is possible the number
of results to be fewer than \code{maxResults}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of service results returned by \code{ListServices} in
paginated output. When this parameter is used, \code{ListServices} only
returns \code{maxResults} results in a single page along with a \code{nextToken}
response element. The remaining results of the initial request can be
seen by sending another \code{ListServices} request with the returned
\code{nextToken} value. This value can be between 1 and 100. If this
parameter is not used, then \code{ListServices} returns up to 10 results and
a \code{nextToken} value if applicable.}

\item{launchType}{The launch type for the services to list.}

\item{schedulingStrategy}{The scheduling strategy for services to list.}
}
\description{
Lists the services that are running in a specified cluster.
}
\section{Request syntax}{
\preformatted{svc$list_services(
  cluster = "string",
  nextToken = "string",
  maxResults = 123,
  launchType = "EC2"|"FARGATE",
  schedulingStrategy = "REPLICA"|"DAEMON"
)
}
}

\examples{
\dontrun{
# This example lists the services running in the default cluster for an
# account.
svc$list_services()
}

}
\keyword{internal}
