% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_service}
\alias{ecs_create_service}
\title{Runs and maintains your desired number of tasks from a specified task
definition}
\usage{
ecs_create_service(
  cluster = NULL,
  serviceName,
  taskDefinition = NULL,
  loadBalancers = NULL,
  serviceRegistries = NULL,
  desiredCount = NULL,
  clientToken = NULL,
  launchType = NULL,
  capacityProviderStrategy = NULL,
  platformVersion = NULL,
  role = NULL,
  deploymentConfiguration = NULL,
  placementConstraints = NULL,
  placementStrategy = NULL,
  networkConfiguration = NULL,
  healthCheckGracePeriodSeconds = NULL,
  schedulingStrategy = NULL,
  deploymentController = NULL,
  tags = NULL,
  enableECSManagedTags = NULL,
  propagateTags = NULL,
  enableExecuteCommand = NULL
)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
you run your service on. If you do not specify a cluster, the default
cluster is assumed.}

\item{serviceName}{[required] The name of your service. Up to 255 letters (uppercase and lowercase),
numbers, underscores, and hyphens are allowed. Service names must be
unique within a cluster, but you can have similarly named services in
multiple clusters within a Region or across multiple Regions.}

\item{taskDefinition}{The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task
definition to run in your service. If a \code{revision} isn't specified, the
latest \code{ACTIVE} revision is used.

A task definition must be specified if the service uses either the \code{ECS}
or \code{CODE_DEPLOY} deployment controllers.}

\item{loadBalancers}{A load balancer object representing the load balancers to use with your
service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html}{Service load balancing}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If the service uses the rolling update (\code{ECS}) deployment controller and
using either an Application Load Balancer or Network Load Balancer, you
must specify one or more target group ARNs to attach to the service. The
service-linked role is required for services that use multiple target
groups. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html}{Using service-linked roles for Amazon ECS}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If the service uses the \code{CODE_DEPLOY} deployment controller, the service
is required to use either an Application Load Balancer or Network Load
Balancer. When creating an CodeDeploy deployment group, you specify two
target groups (referred to as a \code{targetGroupPair}). During a deployment,
CodeDeploy determines which task set in your service has the status
\code{PRIMARY}, and it associates one target group with it. Then, it also
associates the other target group with the replacement task set. The
load balancer can also have up to two listeners: a required listener for
production traffic and an optional listener that you can use to perform
validation tests with Lambda functions before routing production traffic
to it.

If you use the \code{CODE_DEPLOY} deployment controller, these values can be
changed when updating the service.

For Application Load Balancers and Network Load Balancers, this object
must contain the load balancer target group ARN, the container name, and
the container port to access from the load balancer. The container name
must be as it appears in a container definition. The load balancer name
parameter must be omitted. When a task from this service is placed on a
container instance, the container instance and port combination is
registered as a target in the target group that's specified here.

For Classic Load Balancers, this object must contain the load balancer
name, the container name , and the container port to access from the
load balancer. The container name must be as it appears in a container
definition. The target group ARN parameter must be omitted. When a task
from this service is placed on a container instance, the container
instance is registered with the load balancer that's specified here.

Services with tasks that use the \code{awsvpc} network mode (for example,
those with the Fargate launch type) only support Application Load
Balancers and Network Load Balancers. Classic Load Balancers aren't
supported. Also, when you create any target groups for these services,
you must choose \code{ip} as the target type, not \code{instance}. This is because
tasks that use the \code{awsvpc} network mode are associated with an elastic
network interface, not an Amazon EC2 instance.}

\item{serviceRegistries}{The details of the service discovery registry to associate with this
service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html}{Service discovery}.

Each service may be associated with one service registry. Multiple
service registries for each service isn't supported.}

\item{desiredCount}{The number of instantiations of the specified task definition to place
and keep running on your cluster.

This is required if \code{schedulingStrategy} is \code{REPLICA} or isn't
specified. If \code{schedulingStrategy} is \code{DAEMON} then this isn't required.}

\item{clientToken}{An identifier that you provide to ensure the idempotency of the request.
It must be unique and is case sensitive. Up to 32 ASCII characters are
allowed.}

\item{launchType}{The infrastructure that you run your service on. For more information,
see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html}{Amazon ECS launch types}
in the \emph{Amazon Elastic Container Service Developer Guide}.

The \code{FARGATE} launch type runs your tasks on Fargate On-Demand
infrastructure.

Fargate Spot infrastructure is available for use but a capacity provider
strategy must be used. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html}{Fargate capacity providers}
in the \emph{Amazon ECS User Guide for Fargate}.

The \code{EC2} launch type runs your tasks on Amazon EC2 instances registered
to your cluster.

The \code{EXTERNAL} launch type runs your tasks on your on-premises server or
virtual machine (VM) capacity registered to your cluster.

A service can use either a launch type or a capacity provider strategy.
If a \code{launchType} is specified, the \code{capacityProviderStrategy} parameter
must be omitted.}

\item{capacityProviderStrategy}{The capacity provider strategy to use for the service.

If a \code{capacityProviderStrategy} is specified, the \code{launchType} parameter
must be omitted. If no \code{capacityProviderStrategy} or \code{launchType} is
specified, the \code{defaultCapacityProviderStrategy} for the cluster is
used.

A capacity provider strategy may contain a maximum of 6 capacity
providers.}

\item{platformVersion}{The platform version that your tasks in the service are running on. A
platform version is specified only for tasks using the Fargate launch
type. If one isn't specified, the \code{LATEST} platform version is used. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html}{Fargate platform versions}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{role}{The name or full Amazon Resource Name (ARN) of the IAM role that allows
Amazon ECS to make calls to your load balancer on your behalf. This
parameter is only permitted if you are using a load balancer with your
service and your task definition doesn't use the \code{awsvpc} network mode.
If you specify the \code{role} parameter, you must also specify a load
balancer object with the \code{loadBalancers} parameter.

If your account has already created the Amazon ECS service-linked role,
that role is used for your service unless you specify a role here. The
service-linked role is required if your task definition uses the
\code{awsvpc} network mode or if the service is configured to use service
discovery, an external deployment controller, multiple target groups, or
Elastic Inference accelerators in which case you don't specify a role
here. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html}{Using service-linked roles for Amazon ECS}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If your specified role has a path other than \code{/}, then you must either
specify the full role ARN (this is recommended) or prefix the role name
with the path. For example, if a role with the name \code{bar} has a path of
\verb{/foo/} then you would specify \verb{/foo/bar} as the role name. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names}{Friendly names and paths}
in the \emph{IAM User Guide}.}

\item{deploymentConfiguration}{Optional deployment parameters that control how many tasks run during
the deployment and the ordering of stopping and starting tasks.}

\item{placementConstraints}{An array of placement constraint objects to use for tasks in your
service. You can specify a maximum of 10 constraints for each task. This
limit includes constraints in the task definition and those specified at
runtime.}

\item{placementStrategy}{The placement strategy objects to use for tasks in your service. You can
specify a maximum of 5 strategy rules for each service.}

\item{networkConfiguration}{The network configuration for the service. This parameter is required
for task definitions that use the \code{awsvpc} network mode to receive their
own elastic network interface, and it isn't supported for other network
modes. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html}{Task networking}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{healthCheckGracePeriodSeconds}{The period of time, in seconds, that the Amazon ECS service scheduler
ignores unhealthy Elastic Load Balancing target health checks after a
task has first started. This is only used when your service is
configured to use a load balancer. If your service has a load balancer
defined and you don't specify a health check grace period value, the
default value of \code{0} is used.

If you do not use an Elastic Load Balancing, we recomend that you use
the \code{startPeriod} in the task definition healtch check parameters. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html}{Health check}.

If your service's tasks take a while to start and respond to Elastic
Load Balancing health checks, you can specify a health check grace
period of up to 2,147,483,647 seconds (about 69 years). During that
time, the Amazon ECS service scheduler ignores health check status. This
grace period can prevent the service scheduler from marking tasks as
unhealthy and stopping them before they have time to come up.}

\item{schedulingStrategy}{The scheduling strategy to use for the service. For more information,
see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html}{Services}.

There are two service scheduler strategies available:
\itemize{
\item \code{REPLICA}-The replica scheduling strategy places and maintains the
desired number of tasks across your cluster. By default, the service
scheduler spreads tasks across Availability Zones. You can use task
placement strategies and constraints to customize task placement
decisions. This scheduler strategy is required if the service uses
the \code{CODE_DEPLOY} or \code{EXTERNAL} deployment controller types.
\item \code{DAEMON}-The daemon scheduling strategy deploys exactly one task on
each active container instance that meets all of the task placement
constraints that you specify in your cluster. The service scheduler
also evaluates the task placement constraints for running tasks and
will stop tasks that don't meet the placement constraints. When
you're using this strategy, you don't need to specify a desired
number of tasks, a task placement strategy, or use Service Auto
Scaling policies.

Tasks using the Fargate launch type or the \code{CODE_DEPLOY} or
\code{EXTERNAL} deployment controller types don't support the \code{DAEMON}
scheduling strategy.
}}

\item{deploymentController}{The deployment controller to use for the service. If no deployment
controller is specified, the default value of \code{ECS} is used.}

\item{tags}{The metadata that you apply to the service to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define. When a service is deleted, the tags are deleted as
well.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}

\item{enableECSManagedTags}{Specifies whether to turn on Amazon ECS managed tags for the tasks
within the service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging your Amazon ECS resources}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{propagateTags}{Specifies whether to propagate the tags from the task definition to the
task. If no value is specified, the tags aren't propagated. Tags can
only be propagated to the task during task creation. To add tags to a
task after task creation, use the \code{\link[=ecs_tag_resource]{tag_resource}} API
action.}

\item{enableExecuteCommand}{Determines whether the execute command functionality is enabled for the
service. If \code{true}, this enables execute command functionality on all
containers in the service tasks.}
}
\description{
Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running in a service drops below the \code{desiredCount}, Amazon ECS runs another copy of the task in the specified cluster. To update an existing service, see the \code{\link[=ecs_update_service]{update_service}} action.

See \url{https://paws-r.github.io/docs/ecs/create_service.html} for full documentation.
}
\keyword{internal}
