% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_function}
\alias{lambda_create_function}
\title{Creates a Lambda function}
\usage{
lambda_create_function(
  FunctionName,
  Runtime = NULL,
  Role,
  Handler = NULL,
  Code,
  Description = NULL,
  Timeout = NULL,
  MemorySize = NULL,
  Publish = NULL,
  VpcConfig = NULL,
  PackageType = NULL,
  DeadLetterConfig = NULL,
  Environment = NULL,
  KMSKeyArn = NULL,
  TracingConfig = NULL,
  Tags = NULL,
  Layers = NULL,
  FileSystemConfigs = NULL,
  ImageConfig = NULL,
  CodeSigningConfigArn = NULL,
  Architectures = NULL,
  EphemeralStorage = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Runtime}{The identifier of the function's
\href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{runtime}.
Runtime is required if the deployment package is a .zip file archive.}

\item{Role}{[required] The Amazon Resource Name (ARN) of the function's execution role.}

\item{Handler}{The name of the method within your code that Lambda calls to execute
your function. Handler is required if the deployment package is a .zip
file archive. The format includes the file name. It can also include
namespaces and other qualifiers, depending on the runtime. For more
information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html}{Programming Model}.}

\item{Code}{[required] The code for the function.}

\item{Description}{A description of the function.}

\item{Timeout}{The amount of time (in seconds) that Lambda allows a function to run
before stopping it. The default is 3 seconds. The maximum allowed value
is 900 seconds. For additional information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtime-environment.html}{Lambda execution environment}.}

\item{MemorySize}{The amount of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html}{memory available to the function}
at runtime. Increasing the function memory also increases its CPU
allocation. The default value is 128 MB. The value can be any multiple
of 1 MB.}

\item{Publish}{Set to true to publish the first version of the function during
creation.}

\item{VpcConfig}{For network connectivity to Amazon Web Services resources in a VPC,
specify a list of security groups and subnets in the VPC. When you
connect a function to a VPC, it can only access resources and the
internet through that VPC. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html}{VPC Settings}.}

\item{PackageType}{The type of deployment package. Set to \code{Image} for container image and
set \code{Zip} for ZIP archive.}

\item{DeadLetterConfig}{A dead letter queue configuration that specifies the queue or topic
where Lambda sends asynchronous events when they fail processing. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq}{Dead Letter Queues}.}

\item{Environment}{Environment variables that are accessible from function code during
execution.}

\item{KMSKeyArn}{The ARN of the Amazon Web Services Key Management Service (KMS) key
that's used to encrypt your function's environment variables. If it's
not provided, Lambda uses a default service key.}

\item{TracingConfig}{Set \code{Mode} to \code{Active} to sample and trace a subset of incoming requests
with
\href{https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html}{X-Ray}.}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html}{tags}
to apply to the function.}

\item{Layers}{A list of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{function layers}
to add to the function's execution environment. Specify each layer by
its ARN, including the version.}

\item{FileSystemConfigs}{Connection settings for an Amazon EFS file system.}

\item{ImageConfig}{Container image \href{https://docs.aws.amazon.com/lambda/latest/dg/#configuration-images-settings}{configuration values}
that override the values in the container image Dockerfile.}

\item{CodeSigningConfigArn}{To enable code signing for this function, specify the ARN of a
code-signing configuration. A code-signing configuration includes a set
of signing profiles, which define the trusted publishers for this
function.}

\item{Architectures}{The instruction set architecture that the function supports. Enter a
string array with one of the valid values (arm64 or x86_64). The default
value is \code{x86_64}.}

\item{EphemeralStorage}{The size of the function’s /tmp directory in MB. The default value is
512, but can be any whole number between 512 and 10240 MB.}
}
\description{
Creates a Lambda function. To create a function, you need a \href{https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html}{deployment package} and an \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-permissions.html#lambda-intro-execution-role}{execution role}. The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.

See \url{https://paws-r.github.io/docs/lambda/create_function.html} for full documentation.
}
\keyword{internal}
