% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_environment_account_connection}
\alias{proton_create_environment_account_connection}
\title{Create an environment account connection in an environment account so
that environment infrastructure resources can be provisioned in the
environment account from a management account}
\usage{
proton_create_environment_account_connection(
  clientToken = NULL,
  componentRoleArn = NULL,
  environmentName,
  managementAccountId,
  roleArn,
  tags = NULL
)
}
\arguments{
\item{clientToken}{When included, if two identical requests are made with the same client
token, Proton returns the environment account connection that the first
request created.}

\item{componentRoleArn}{The Amazon Resource Name (ARN) of the IAM service role that Proton uses
when provisioning directly defined components in the associated
environment account. It determines the scope of infrastructure that a
component can provision in the account.

You must specify \code{componentRoleArn} to allow directly defined components
to be associated with any environments running in this account.

For more information about components, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html}{Proton components}
in the \emph{Proton Administrator Guide}.}

\item{environmentName}{[required] The name of the Proton environment that's created in the associated
management account.}

\item{managementAccountId}{[required] The ID of the management account that accepts or rejects the environment
account connection. You create and manage the Proton environment in this
account. If the management account accepts the environment account
connection, Proton can use the associated IAM role to provision
environment infrastructure resources in the associated environment
account.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM service role that's created in
the environment account. Proton uses this role to provision
infrastructure resources in the associated environment account.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton environment account connection. A tag is a key-value pair.

For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton resources and tagging}
in the \emph{Proton Administrator Guide}.}
}
\description{
Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.

See \url{https://paws-r.github.io/docs/proton/create_environment_account_connection.html} for full documentation.
}
\keyword{internal}
