# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include emrcontainers_service.R
NULL

#' Cancels a job run
#'
#' @description
#' Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_cancel_job_run/](https://www.paws-r-sdk.com/docs/emrcontainers_cancel_job_run/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the job run to cancel.
#' @param virtualClusterId &#91;required&#93; The ID of the virtual cluster for which the job run will be canceled.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_cancel_job_run
emrcontainers_cancel_job_run <- function(id, virtualClusterId) {
  op <- new_operation(
    name = "CancelJobRun",
    http_method = "DELETE",
    http_path = "/virtualclusters/{virtualClusterId}/jobruns/{jobRunId}",
    paginator = list()
  )
  input <- .emrcontainers$cancel_job_run_input(id = id, virtualClusterId = virtualClusterId)
  output <- .emrcontainers$cancel_job_run_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$cancel_job_run <- emrcontainers_cancel_job_run

#' Creates a job template
#'
#' @description
#' Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_create_job_template/](https://www.paws-r-sdk.com/docs/emrcontainers_create_job_template/) for full documentation.
#'
#' @param name &#91;required&#93; The specified name of the job template.
#' @param clientToken &#91;required&#93; The client token of the job template.
#' @param jobTemplateData &#91;required&#93; The job template data which holds values of StartJobRun API request.
#' @param tags The tags that are associated with the job template.
#' @param kmsKeyArn The KMS key ARN used to encrypt the job template.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_create_job_template
emrcontainers_create_job_template <- function(name, clientToken, jobTemplateData, tags = NULL, kmsKeyArn = NULL) {
  op <- new_operation(
    name = "CreateJobTemplate",
    http_method = "POST",
    http_path = "/jobtemplates",
    paginator = list()
  )
  input <- .emrcontainers$create_job_template_input(name = name, clientToken = clientToken, jobTemplateData = jobTemplateData, tags = tags, kmsKeyArn = kmsKeyArn)
  output <- .emrcontainers$create_job_template_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$create_job_template <- emrcontainers_create_job_template

#' Creates a managed endpoint
#'
#' @description
#' Creates a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_create_managed_endpoint/](https://www.paws-r-sdk.com/docs/emrcontainers_create_managed_endpoint/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the managed endpoint.
#' @param virtualClusterId &#91;required&#93; The ID of the virtual cluster for which a managed endpoint is created.
#' @param type &#91;required&#93; The type of the managed endpoint.
#' @param releaseLabel &#91;required&#93; The Amazon EMR release version.
#' @param executionRoleArn &#91;required&#93; The ARN of the execution role.
#' @param certificateArn The certificate ARN provided by users for the managed endpoint. This
#' field is under deprecation and will be removed in future releases.
#' @param configurationOverrides The configuration settings that will be used to override existing
#' configurations.
#' @param clientToken &#91;required&#93; The client idempotency token for this create call.
#' @param tags The tags of the managed endpoint.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_create_managed_endpoint
emrcontainers_create_managed_endpoint <- function(name, virtualClusterId, type, releaseLabel, executionRoleArn, certificateArn = NULL, configurationOverrides = NULL, clientToken, tags = NULL) {
  op <- new_operation(
    name = "CreateManagedEndpoint",
    http_method = "POST",
    http_path = "/virtualclusters/{virtualClusterId}/endpoints",
    paginator = list()
  )
  input <- .emrcontainers$create_managed_endpoint_input(name = name, virtualClusterId = virtualClusterId, type = type, releaseLabel = releaseLabel, executionRoleArn = executionRoleArn, certificateArn = certificateArn, configurationOverrides = configurationOverrides, clientToken = clientToken, tags = tags)
  output <- .emrcontainers$create_managed_endpoint_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$create_managed_endpoint <- emrcontainers_create_managed_endpoint

#' Creates a virtual cluster
#'
#' @description
#' Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_create_virtual_cluster/](https://www.paws-r-sdk.com/docs/emrcontainers_create_virtual_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; The specified name of the virtual cluster.
#' @param containerProvider &#91;required&#93; The container provider of the virtual cluster.
#' @param clientToken &#91;required&#93; The client token of the virtual cluster.
#' @param tags The tags assigned to the virtual cluster.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_create_virtual_cluster
emrcontainers_create_virtual_cluster <- function(name, containerProvider, clientToken, tags = NULL) {
  op <- new_operation(
    name = "CreateVirtualCluster",
    http_method = "POST",
    http_path = "/virtualclusters",
    paginator = list()
  )
  input <- .emrcontainers$create_virtual_cluster_input(name = name, containerProvider = containerProvider, clientToken = clientToken, tags = tags)
  output <- .emrcontainers$create_virtual_cluster_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$create_virtual_cluster <- emrcontainers_create_virtual_cluster

#' Deletes a job template
#'
#' @description
#' Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_delete_job_template/](https://www.paws-r-sdk.com/docs/emrcontainers_delete_job_template/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the job template that will be deleted.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_delete_job_template
emrcontainers_delete_job_template <- function(id) {
  op <- new_operation(
    name = "DeleteJobTemplate",
    http_method = "DELETE",
    http_path = "/jobtemplates/{templateId}",
    paginator = list()
  )
  input <- .emrcontainers$delete_job_template_input(id = id)
  output <- .emrcontainers$delete_job_template_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$delete_job_template <- emrcontainers_delete_job_template

#' Deletes a managed endpoint
#'
#' @description
#' Deletes a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_delete_managed_endpoint/](https://www.paws-r-sdk.com/docs/emrcontainers_delete_managed_endpoint/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the managed endpoint.
#' @param virtualClusterId &#91;required&#93; The ID of the endpoint's virtual cluster.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_delete_managed_endpoint
emrcontainers_delete_managed_endpoint <- function(id, virtualClusterId) {
  op <- new_operation(
    name = "DeleteManagedEndpoint",
    http_method = "DELETE",
    http_path = "/virtualclusters/{virtualClusterId}/endpoints/{endpointId}",
    paginator = list()
  )
  input <- .emrcontainers$delete_managed_endpoint_input(id = id, virtualClusterId = virtualClusterId)
  output <- .emrcontainers$delete_managed_endpoint_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$delete_managed_endpoint <- emrcontainers_delete_managed_endpoint

#' Deletes a virtual cluster
#'
#' @description
#' Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_delete_virtual_cluster/](https://www.paws-r-sdk.com/docs/emrcontainers_delete_virtual_cluster/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the virtual cluster that will be deleted.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_delete_virtual_cluster
emrcontainers_delete_virtual_cluster <- function(id) {
  op <- new_operation(
    name = "DeleteVirtualCluster",
    http_method = "DELETE",
    http_path = "/virtualclusters/{virtualClusterId}",
    paginator = list()
  )
  input <- .emrcontainers$delete_virtual_cluster_input(id = id)
  output <- .emrcontainers$delete_virtual_cluster_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$delete_virtual_cluster <- emrcontainers_delete_virtual_cluster

#' Displays detailed information about a job run
#'
#' @description
#' Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_describe_job_run/](https://www.paws-r-sdk.com/docs/emrcontainers_describe_job_run/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the job run request.
#' @param virtualClusterId &#91;required&#93; The ID of the virtual cluster for which the job run is submitted.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_describe_job_run
emrcontainers_describe_job_run <- function(id, virtualClusterId) {
  op <- new_operation(
    name = "DescribeJobRun",
    http_method = "GET",
    http_path = "/virtualclusters/{virtualClusterId}/jobruns/{jobRunId}",
    paginator = list()
  )
  input <- .emrcontainers$describe_job_run_input(id = id, virtualClusterId = virtualClusterId)
  output <- .emrcontainers$describe_job_run_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$describe_job_run <- emrcontainers_describe_job_run

#' Displays detailed information about a specified job template
#'
#' @description
#' Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_describe_job_template/](https://www.paws-r-sdk.com/docs/emrcontainers_describe_job_template/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the job template that will be described.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_describe_job_template
emrcontainers_describe_job_template <- function(id) {
  op <- new_operation(
    name = "DescribeJobTemplate",
    http_method = "GET",
    http_path = "/jobtemplates/{templateId}",
    paginator = list()
  )
  input <- .emrcontainers$describe_job_template_input(id = id)
  output <- .emrcontainers$describe_job_template_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$describe_job_template <- emrcontainers_describe_job_template

#' Displays detailed information about a managed endpoint
#'
#' @description
#' Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_describe_managed_endpoint/](https://www.paws-r-sdk.com/docs/emrcontainers_describe_managed_endpoint/) for full documentation.
#'
#' @param id &#91;required&#93; This output displays ID of the managed endpoint.
#' @param virtualClusterId &#91;required&#93; The ID of the endpoint's virtual cluster.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_describe_managed_endpoint
emrcontainers_describe_managed_endpoint <- function(id, virtualClusterId) {
  op <- new_operation(
    name = "DescribeManagedEndpoint",
    http_method = "GET",
    http_path = "/virtualclusters/{virtualClusterId}/endpoints/{endpointId}",
    paginator = list()
  )
  input <- .emrcontainers$describe_managed_endpoint_input(id = id, virtualClusterId = virtualClusterId)
  output <- .emrcontainers$describe_managed_endpoint_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$describe_managed_endpoint <- emrcontainers_describe_managed_endpoint

#' Displays detailed information about a specified virtual cluster
#'
#' @description
#' Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_describe_virtual_cluster/](https://www.paws-r-sdk.com/docs/emrcontainers_describe_virtual_cluster/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the virtual cluster that will be described.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_describe_virtual_cluster
emrcontainers_describe_virtual_cluster <- function(id) {
  op <- new_operation(
    name = "DescribeVirtualCluster",
    http_method = "GET",
    http_path = "/virtualclusters/{virtualClusterId}",
    paginator = list()
  )
  input <- .emrcontainers$describe_virtual_cluster_input(id = id)
  output <- .emrcontainers$describe_virtual_cluster_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$describe_virtual_cluster <- emrcontainers_describe_virtual_cluster

#' Generate a session token to connect to a managed endpoint
#'
#' @description
#' Generate a session token to connect to a managed endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_get_managed_endpoint_session_credentials/](https://www.paws-r-sdk.com/docs/emrcontainers_get_managed_endpoint_session_credentials/) for full documentation.
#'
#' @param endpointIdentifier &#91;required&#93; The ARN of the managed endpoint for which the request is submitted.
#' @param virtualClusterIdentifier &#91;required&#93; The ARN of the Virtual Cluster which the Managed Endpoint belongs to.
#' @param executionRoleArn &#91;required&#93; The IAM Execution Role ARN that will be used by the job run.
#' @param credentialType &#91;required&#93; Type of the token requested. Currently supported and default value of
#' this field is “TOKEN.”
#' @param durationInSeconds Duration in seconds for which the session token is valid. The default
#' duration is 15 minutes and the maximum is 12 hours.
#' @param logContext String identifier used to separate sections of the execution logs
#' uploaded to S3.
#' @param clientToken The client idempotency token of the job run request.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_get_managed_endpoint_session_credentials
emrcontainers_get_managed_endpoint_session_credentials <- function(endpointIdentifier, virtualClusterIdentifier, executionRoleArn, credentialType, durationInSeconds = NULL, logContext = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "GetManagedEndpointSessionCredentials",
    http_method = "POST",
    http_path = "/virtualclusters/{virtualClusterId}/endpoints/{endpointId}/credentials",
    paginator = list()
  )
  input <- .emrcontainers$get_managed_endpoint_session_credentials_input(endpointIdentifier = endpointIdentifier, virtualClusterIdentifier = virtualClusterIdentifier, executionRoleArn = executionRoleArn, credentialType = credentialType, durationInSeconds = durationInSeconds, logContext = logContext, clientToken = clientToken)
  output <- .emrcontainers$get_managed_endpoint_session_credentials_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$get_managed_endpoint_session_credentials <- emrcontainers_get_managed_endpoint_session_credentials

#' Lists job runs based on a set of parameters
#'
#' @description
#' Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_list_job_runs/](https://www.paws-r-sdk.com/docs/emrcontainers_list_job_runs/) for full documentation.
#'
#' @param virtualClusterId &#91;required&#93; The ID of the virtual cluster for which to list the job run.
#' @param createdBefore The date and time before which the job runs were submitted.
#' @param createdAfter The date and time after which the job runs were submitted.
#' @param name The name of the job run.
#' @param states The states of the job run.
#' @param maxResults The maximum number of job runs that can be listed.
#' @param nextToken The token for the next set of job runs to return.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_list_job_runs
emrcontainers_list_job_runs <- function(virtualClusterId, createdBefore = NULL, createdAfter = NULL, name = NULL, states = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListJobRuns",
    http_method = "GET",
    http_path = "/virtualclusters/{virtualClusterId}/jobruns",
    paginator = list()
  )
  input <- .emrcontainers$list_job_runs_input(virtualClusterId = virtualClusterId, createdBefore = createdBefore, createdAfter = createdAfter, name = name, states = states, maxResults = maxResults, nextToken = nextToken)
  output <- .emrcontainers$list_job_runs_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$list_job_runs <- emrcontainers_list_job_runs

#' Lists job templates based on a set of parameters
#'
#' @description
#' Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_list_job_templates/](https://www.paws-r-sdk.com/docs/emrcontainers_list_job_templates/) for full documentation.
#'
#' @param createdAfter The date and time after which the job templates were created.
#' @param createdBefore The date and time before which the job templates were created.
#' @param maxResults The maximum number of job templates that can be listed.
#' @param nextToken The token for the next set of job templates to return.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_list_job_templates
emrcontainers_list_job_templates <- function(createdAfter = NULL, createdBefore = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListJobTemplates",
    http_method = "GET",
    http_path = "/jobtemplates",
    paginator = list()
  )
  input <- .emrcontainers$list_job_templates_input(createdAfter = createdAfter, createdBefore = createdBefore, maxResults = maxResults, nextToken = nextToken)
  output <- .emrcontainers$list_job_templates_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$list_job_templates <- emrcontainers_list_job_templates

#' Lists managed endpoints based on a set of parameters
#'
#' @description
#' Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_list_managed_endpoints/](https://www.paws-r-sdk.com/docs/emrcontainers_list_managed_endpoints/) for full documentation.
#'
#' @param virtualClusterId &#91;required&#93; The ID of the virtual cluster.
#' @param createdBefore The date and time before which the endpoints are created.
#' @param createdAfter The date and time after which the endpoints are created.
#' @param types The types of the managed endpoints.
#' @param states The states of the managed endpoints.
#' @param maxResults The maximum number of managed endpoints that can be listed.
#' @param nextToken The token for the next set of managed endpoints to return.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_list_managed_endpoints
emrcontainers_list_managed_endpoints <- function(virtualClusterId, createdBefore = NULL, createdAfter = NULL, types = NULL, states = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListManagedEndpoints",
    http_method = "GET",
    http_path = "/virtualclusters/{virtualClusterId}/endpoints",
    paginator = list()
  )
  input <- .emrcontainers$list_managed_endpoints_input(virtualClusterId = virtualClusterId, createdBefore = createdBefore, createdAfter = createdAfter, types = types, states = states, maxResults = maxResults, nextToken = nextToken)
  output <- .emrcontainers$list_managed_endpoints_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$list_managed_endpoints <- emrcontainers_list_managed_endpoints

#' Lists the tags assigned to the resources
#'
#' @description
#' Lists the tags assigned to the resources.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/emrcontainers_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of tagged resources.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_list_tags_for_resource
emrcontainers_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrcontainers$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .emrcontainers$list_tags_for_resource_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$list_tags_for_resource <- emrcontainers_list_tags_for_resource

#' Lists information about the specified virtual cluster
#'
#' @description
#' Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_list_virtual_clusters/](https://www.paws-r-sdk.com/docs/emrcontainers_list_virtual_clusters/) for full documentation.
#'
#' @param containerProviderId The container provider ID of the virtual cluster.
#' @param containerProviderType The container provider type of the virtual cluster. Amazon EKS is the
#' only supported type as of now.
#' @param createdAfter The date and time after which the virtual clusters are created.
#' @param createdBefore The date and time before which the virtual clusters are created.
#' @param states The states of the requested virtual clusters.
#' @param maxResults The maximum number of virtual clusters that can be listed.
#' @param nextToken The token for the next set of virtual clusters to return.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_list_virtual_clusters
emrcontainers_list_virtual_clusters <- function(containerProviderId = NULL, containerProviderType = NULL, createdAfter = NULL, createdBefore = NULL, states = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualClusters",
    http_method = "GET",
    http_path = "/virtualclusters",
    paginator = list()
  )
  input <- .emrcontainers$list_virtual_clusters_input(containerProviderId = containerProviderId, containerProviderType = containerProviderType, createdAfter = createdAfter, createdBefore = createdBefore, states = states, maxResults = maxResults, nextToken = nextToken)
  output <- .emrcontainers$list_virtual_clusters_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$list_virtual_clusters <- emrcontainers_list_virtual_clusters

#' Starts a job run
#'
#' @description
#' Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_start_job_run/](https://www.paws-r-sdk.com/docs/emrcontainers_start_job_run/) for full documentation.
#'
#' @param name The name of the job run.
#' @param virtualClusterId &#91;required&#93; The virtual cluster ID for which the job run request is submitted.
#' @param clientToken &#91;required&#93; The client idempotency token of the job run request.
#' @param executionRoleArn The execution role ARN for the job run.
#' @param releaseLabel The Amazon EMR release version to use for the job run.
#' @param jobDriver The job driver for the job run.
#' @param configurationOverrides The configuration overrides for the job run.
#' @param tags The tags assigned to job runs.
#' @param jobTemplateId The job template ID to be used to start the job run.
#' @param jobTemplateParameters The values of job template parameters to start a job run.
#' @param retryPolicyConfiguration The retry policy configuration for the job run.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_start_job_run
emrcontainers_start_job_run <- function(name = NULL, virtualClusterId, clientToken, executionRoleArn = NULL, releaseLabel = NULL, jobDriver = NULL, configurationOverrides = NULL, tags = NULL, jobTemplateId = NULL, jobTemplateParameters = NULL, retryPolicyConfiguration = NULL) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/virtualclusters/{virtualClusterId}/jobruns",
    paginator = list()
  )
  input <- .emrcontainers$start_job_run_input(name = name, virtualClusterId = virtualClusterId, clientToken = clientToken, executionRoleArn = executionRoleArn, releaseLabel = releaseLabel, jobDriver = jobDriver, configurationOverrides = configurationOverrides, tags = tags, jobTemplateId = jobTemplateId, jobTemplateParameters = jobTemplateParameters, retryPolicyConfiguration = retryPolicyConfiguration)
  output <- .emrcontainers$start_job_run_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$start_job_run <- emrcontainers_start_job_run

#' Assigns tags to resources
#'
#' @description
#' Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_tag_resource/](https://www.paws-r-sdk.com/docs/emrcontainers_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of resources.
#' @param tags &#91;required&#93; The tags assigned to resources.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_tag_resource
emrcontainers_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrcontainers$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .emrcontainers$tag_resource_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$tag_resource <- emrcontainers_tag_resource

#' Removes tags from resources
#'
#' @description
#' Removes tags from resources.
#'
#' See [https://www.paws-r-sdk.com/docs/emrcontainers_untag_resource/](https://www.paws-r-sdk.com/docs/emrcontainers_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of resources.
#' @param tagKeys &#91;required&#93; The tag keys of the resources.
#'
#' @keywords internal
#'
#' @rdname emrcontainers_untag_resource
emrcontainers_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrcontainers$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .emrcontainers$untag_resource_output()
  config <- get_config()
  svc <- .emrcontainers$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrcontainers$operations$untag_resource <- emrcontainers_untag_resource
