% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_security_group}
\alias{ec2_create_security_group}
\title{Creates a security group}
\usage{
ec2_create_security_group(
  Description,
  GroupName,
  VpcId = NULL,
  TagSpecifications = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Description}{[required] A description for the security group.

Constraints: Up to 255 characters in length

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()#,@[]+=&;\{\}!$*}

\item{GroupName}{[required] The name of the security group.

Constraints: Up to 255 characters in length. Cannot start with \verb{sg-}.

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()#,@[]+=&;\{\}!$*}

\item{VpcId}{[EC2-VPC] The ID of the VPC. Required for EC2-VPC.}

\item{TagSpecifications}{The tags to assign to the security group.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a security group.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_security_group/} for full documentation.
}
\keyword{internal}
