% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_security_groups}
\alias{ec2_describe_security_groups}
\title{Describes the specified security groups or all of your security groups}
\usage{
ec2_describe_security_groups(
  Filters = NULL,
  GroupIds = NULL,
  GroupNames = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{The filters. If using multiple filters for rules, the results include
security groups for which any combination of rules - not necessarily a
single rule - match all filters.
\itemize{
\item \code{description} - The description of the security group.
\item \code{egress.ip-permission.cidr} - An IPv4 CIDR block for an outbound
security group rule.
\item \code{egress.ip-permission.from-port} - For an outbound rule, the start
of port range for the TCP and UDP protocols, or an ICMP type number.
\item \code{egress.ip-permission.group-id} - The ID of a security group that
has been referenced in an outbound security group rule.
\item \code{egress.ip-permission.group-name} - The name of a security group
that is referenced in an outbound security group rule.
\item \code{egress.ip-permission.ipv6-cidr} - An IPv6 CIDR block for an
outbound security group rule.
\item \code{egress.ip-permission.prefix-list-id} - The ID of a prefix list to
which a security group rule allows outbound access.
\item \code{egress.ip-permission.protocol} - The IP protocol for an outbound
security group rule (\code{tcp} | \code{udp} | \code{icmp}, a protocol number, or
-1 for all protocols).
\item \code{egress.ip-permission.to-port} - For an outbound rule, the end of
port range for the TCP and UDP protocols, or an ICMP code.
\item \code{egress.ip-permission.user-id} - The ID of an Amazon Web Services
account that has been referenced in an outbound security group rule.
\item \code{group-id} - The ID of the security group.
\item \code{group-name} - The name of the security group.
\item \code{ip-permission.cidr} - An IPv4 CIDR block for an inbound security
group rule.
\item \code{ip-permission.from-port} - For an inbound rule, the start of port
range for the TCP and UDP protocols, or an ICMP type number.
\item \code{ip-permission.group-id} - The ID of a security group that has been
referenced in an inbound security group rule.
\item \code{ip-permission.group-name} - The name of a security group that is
referenced in an inbound security group rule.
\item \code{ip-permission.ipv6-cidr} - An IPv6 CIDR block for an inbound
security group rule.
\item \code{ip-permission.prefix-list-id} - The ID of a prefix list from which
a security group rule allows inbound access.
\item \code{ip-permission.protocol} - The IP protocol for an inbound security
group rule (\code{tcp} | \code{udp} | \code{icmp}, a protocol number, or -1 for all
protocols).
\item \code{ip-permission.to-port} - For an inbound rule, the end of port range
for the TCP and UDP protocols, or an ICMP code.
\item \code{ip-permission.user-id} - The ID of an Amazon Web Services account
that has been referenced in an inbound security group rule.
\item \code{owner-id} - The Amazon Web Services account ID of the owner of the
security group.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC specified when the security group was
created.
}}

\item{GroupIds}{The IDs of the security groups. Required for security groups in a
nondefault VPC.

Default: Describes all of your security groups.}

\item{GroupNames}{[EC2-Classic and default VPC only] The names of the security groups.
You can specify either the security group name or the security group ID.
For security groups in a nondefault VPC, use the \code{group-name} filter to
describe security groups by name.

Default: Describes all of your security groups.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. This value can be between 5 and 1000. If this parameter is not
specified, then all items are returned. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes the specified security groups or all of your security groups.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_security_groups/} for full documentation.
}
\keyword{internal}
