% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_ipam_resource_discovery}
\alias{ec2_modify_ipam_resource_discovery}
\title{Modifies a resource discovery}
\usage{
ec2_modify_ipam_resource_discovery(
  DryRun = NULL,
  IpamResourceDiscoveryId,
  Description = NULL,
  AddOperatingRegions = NULL,
  RemoveOperatingRegions = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamResourceDiscoveryId}{[required] A resource discovery ID.}

\item{Description}{A resource discovery description.}

\item{AddOperatingRegions}{Add operating Regions to the resource discovery. Operating Regions are
Amazon Web Services Regions where the IPAM is allowed to manage IP
address CIDRs. IPAM only discovers and monitors resources in the Amazon
Web Services Regions you select as operating Regions.}

\item{RemoveOperatingRegions}{Remove operating Regions.}
}
\description{
Modifies a resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_ipam_resource_discovery/} for full documentation.
}
\keyword{internal}
