% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_load_balancer}
\alias{lightsail_create_load_balancer}
\title{Creates a Lightsail load balancer}
\usage{
lightsail_create_load_balancer(
  loadBalancerName,
  instancePort,
  healthCheckPath = NULL,
  certificateName = NULL,
  certificateDomainName = NULL,
  certificateAlternativeNames = NULL,
  tags = NULL,
  ipAddressType = NULL,
  tlsPolicyName = NULL
)
}
\arguments{
\item{loadBalancerName}{[required] The name of your load balancer.}

\item{instancePort}{[required] The instance port where you're creating your load balancer.}

\item{healthCheckPath}{The path you provided to perform the load balancer health check. If you
didn't specify a health check path, Lightsail uses the root path of your
website (\code{"/"}).

You may want to specify a custom health check path other than the root
of your application if your home page loads slowly or has a lot of media
or scripting on it.}

\item{certificateName}{The name of the SSL/TLS certificate.

If you specify \code{certificateName}, then \code{certificateDomainName} is
required (and vice-versa).}

\item{certificateDomainName}{The domain name with which your certificate is associated
(\code{example.com}).

If you specify \code{certificateDomainName}, then \code{certificateName} is
required (and vice-versa).}

\item{certificateAlternativeNames}{The optional alternative domains and subdomains to use with your SSL/TLS
certificate (\code{www.example.com}, \code{example.com}, \code{m.example.com},
\code{blog.example.com}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}

\item{ipAddressType}{The IP address type for the load balancer.

The possible values are \code{ipv4} for IPv4 only, and \code{dualstack} for IPv4
and IPv6.

The default value is \code{dualstack}.}

\item{tlsPolicyName}{The name of the TLS policy to apply to the load balancer.

Use the
\code{\link[=lightsail_get_load_balancer_tls_policies]{get_load_balancer_tls_policies}}
action to get a list of TLS policy names that you can specify.

For more information about load balancer TLS policies, see \href{https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configure-load-balancer-tls-security-policy.html}{Configuring TLS security policies on your Amazon Lightsail load balancers}
in the \emph{Amazon Lightsail Developer Guide}.}
}
\description{
Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see \href{https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/configure-lightsail-instances-for-load-balancing.html}{Configure your Lightsail instances for load balancing}. You can create up to 5 load balancers per AWS Region in your account.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_load_balancer/} for full documentation.
}
\keyword{internal}
