% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_relational_database_snapshot}
\alias{lightsail_create_relational_database_snapshot}
\title{Creates a snapshot of your database in Amazon Lightsail}
\usage{
lightsail_create_relational_database_snapshot(
  relationalDatabaseName,
  relationalDatabaseSnapshotName,
  tags = NULL
)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of the database on which to base your new snapshot.}

\item{relationalDatabaseSnapshotName}{[required] The name for your new database snapshot.

Constraints:
\itemize{
\item Must contain from 2 to 255 alphanumeric characters, or hyphens.
\item The first and last character must be a letter or number.
}}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\description{
Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_relational_database_snapshot/} for full documentation.
}
\keyword{internal}
