# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include batch_service.R
NULL

#' Cancels a job in an Batch job queue
#'
#' @description
#' Cancels a job in an Batch job queue. Jobs that are in a `SUBMITTED`, `PENDING`, or `RUNNABLE` state are cancelled and the job status is updated to `FAILED`.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_cancel_job/](https://www.paws-r-sdk.com/docs/batch_cancel_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The Batch job ID of the job to cancel.
#' @param reason &#91;required&#93; A message to attach to the job that explains the reason for canceling
#' it. This message is returned by future
#' [`describe_jobs`][batch_describe_jobs] operations on the job. This
#' message is also recorded in the Batch activity logs.
#'
#' @keywords internal
#'
#' @rdname batch_cancel_job
batch_cancel_job <- function(jobId, reason) {
  op <- new_operation(
    name = "CancelJob",
    http_method = "POST",
    http_path = "/v1/canceljob",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$cancel_job_input(jobId = jobId, reason = reason)
  output <- .batch$cancel_job_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$cancel_job <- batch_cancel_job

#' Creates an Batch compute environment
#'
#' @description
#' Creates an Batch compute environment. You can create `MANAGED` or `UNMANAGED` compute environments. `MANAGED` compute environments can use Amazon EC2 or Fargate resources. `UNMANAGED` compute environments can only use EC2 resources.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_create_compute_environment/](https://www.paws-r-sdk.com/docs/batch_create_compute_environment/) for full documentation.
#'
#' @param computeEnvironmentName &#91;required&#93; The name for your compute environment. It can be up to 128 characters
#' long. It can contain uppercase and lowercase letters, numbers, hyphens
#' (-), and underscores (_).
#' @param type &#91;required&#93; The type of the compute environment: `MANAGED` or `UNMANAGED`. For more
#' information, see [Compute
#' Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
#' in the *Batch User Guide*.
#' @param state The state of the compute environment. If the state is `ENABLED`, then
#' the compute environment accepts jobs from a queue and can scale out
#' automatically based on queues.
#' 
#' If the state is `ENABLED`, then the Batch scheduler can attempt to place
#' jobs from an associated job queue on the compute resources within the
#' environment. If the compute environment is managed, then it can scale
#' its instances out or in automatically, based on the job queue demand.
#' 
#' If the state is `DISABLED`, then the Batch scheduler doesn't attempt to
#' place jobs within the environment. Jobs in a `STARTING` or `RUNNING`
#' state continue to progress normally. Managed compute environments in the
#' `DISABLED` state don't scale out.
#' 
#' Compute environments in a `DISABLED` state may continue to incur billing
#' charges. To prevent additional charges, turn off and then delete the
#' compute environment. For more information, see
#' [State](https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state)
#' in the *Batch User Guide*.
#' 
#' When an instance is idle, the instance scales down to the `minvCpus`
#' value. However, the instance size doesn't change. For example, consider
#' a `c5.8xlarge` instance with a `minvCpus` value of `4` and a
#' `desiredvCpus` value of `36`. This instance doesn't scale down to a
#' `c5.large` instance.
#' @param unmanagedvCpus The maximum number of vCPUs for an unmanaged compute environment. This
#' parameter is only used for fair share scheduling to reserve vCPU
#' capacity for new share identifiers. If this parameter isn't provided for
#' a fair share job queue, no vCPU capacity is reserved.
#' 
#' This parameter is only supported when the `type` parameter is set to
#' `UNMANAGED`.
#' @param computeResources Details about the compute resources managed by the compute environment.
#' This parameter is required for managed compute environments. For more
#' information, see [Compute
#' Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
#' in the *Batch User Guide*.
#' @param serviceRole The full Amazon Resource Name (ARN) of the IAM role that allows Batch to
#' make calls to other Amazon Web Services services on your behalf. For
#' more information, see [Batch service IAM
#' role](https://docs.aws.amazon.com/batch/latest/userguide/using-service-linked-roles.html)
#' in the *Batch User Guide*.
#' 
#' If your account already created the Batch service-linked role, that role
#' is used by default for your compute environment unless you specify a
#' different role here. If the Batch service-linked role doesn't exist in
#' your account, and no role is specified here, the service attempts to
#' create the Batch service-linked role in your account.
#' 
#' If your specified role has a path other than `/`, then you must specify
#' either the full role ARN (recommended) or prefix the role name with the
#' path. For example, if a role with the name `bar` has a path of `/foo/`,
#' specify `/foo/bar` as the role name. For more information, see [Friendly
#' names and
#' paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names)
#' in the *IAM User Guide*.
#' 
#' Depending on how you created your Batch service role, its ARN might
#' contain the `service-role` path prefix. When you only specify the name
#' of the service role, Batch assumes that your ARN doesn't use the
#' `service-role` path prefix. Because of this, we recommend that you
#' specify the full ARN of your service role when you create compute
#' environments.
#' @param tags The tags that you apply to the compute environment to help you
#' categorize and organize your resources. Each tag consists of a key and
#' an optional value. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in *Amazon Web Services General Reference*.
#' 
#' These tags can be updated or removed using the
#' [`tag_resource`][batch_tag_resource] and
#' [`untag_resource`][batch_untag_resource] API operations. These tags
#' don't propagate to the underlying compute resources.
#' @param eksConfiguration The details for the Amazon EKS cluster that supports the compute
#' environment.
#' @param context Reserved.
#'
#' @keywords internal
#'
#' @rdname batch_create_compute_environment
batch_create_compute_environment <- function(computeEnvironmentName, type, state = NULL, unmanagedvCpus = NULL, computeResources = NULL, serviceRole = NULL, tags = NULL, eksConfiguration = NULL, context = NULL) {
  op <- new_operation(
    name = "CreateComputeEnvironment",
    http_method = "POST",
    http_path = "/v1/createcomputeenvironment",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$create_compute_environment_input(computeEnvironmentName = computeEnvironmentName, type = type, state = state, unmanagedvCpus = unmanagedvCpus, computeResources = computeResources, serviceRole = serviceRole, tags = tags, eksConfiguration = eksConfiguration, context = context)
  output <- .batch$create_compute_environment_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$create_compute_environment <- batch_create_compute_environment

#' Creates an Batch job queue
#'
#' @description
#' Creates an Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_create_job_queue/](https://www.paws-r-sdk.com/docs/batch_create_job_queue/) for full documentation.
#'
#' @param jobQueueName &#91;required&#93; The name of the job queue. It can be up to 128 letters long. It can
#' contain uppercase and lowercase letters, numbers, hyphens (-), and
#' underscores (_).
#' @param state The state of the job queue. If the job queue state is `ENABLED`, it is
#' able to accept jobs. If the job queue state is `DISABLED`, new jobs
#' can't be added to the queue, but jobs already in the queue can finish.
#' @param schedulingPolicyArn The Amazon Resource Name (ARN) of the fair share scheduling policy. If
#' this parameter is specified, the job queue uses a fair share scheduling
#' policy. If this parameter isn't specified, the job queue uses a first
#' in, first out (FIFO) scheduling policy. After a job queue is created,
#' you can replace but can't remove the fair share scheduling policy. The
#' format is `aws:Partition:batch:Region:Account:scheduling-policy/Name `.
#' An example is
#' `aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy`.
#' @param priority &#91;required&#93; The priority of the job queue. Job queues with a higher priority (or a
#' higher integer value for the `priority` parameter) are evaluated first
#' when associated with the same compute environment. Priority is
#' determined in descending order. For example, a job queue with a priority
#' value of `10` is given scheduling preference over a job queue with a
#' priority value of `1`. All of the compute environments must be either
#' EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and
#' Fargate compute environments can't be mixed.
#' @param computeEnvironmentOrder &#91;required&#93; The set of compute environments mapped to a job queue and their order
#' relative to each other. The job scheduler uses this parameter to
#' determine which compute environment runs a specific job. Compute
#' environments must be in the `VALID` state before you can associate them
#' with a job queue. You can associate up to three compute environments
#' with a job queue. All of the compute environments must be either EC2
#' (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and
#' Fargate compute environments can't be mixed.
#' 
#' All compute environments that are associated with a job queue must share
#' the same architecture. Batch doesn't support mixing compute environment
#' architecture types in a single job queue.
#' @param tags The tags that you apply to the job queue to help you categorize and
#' organize your resources. Each tag consists of a key and an optional
#' value. For more information, see [Tagging your Batch
#' resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
#' in *Batch User Guide*.
#' @param jobStateTimeLimitActions The set of actions that Batch performs on jobs that remain at the head
#' of the job queue in the specified state longer than specified times.
#' Batch will perform each action after `maxTimeSeconds` has passed.
#'
#' @keywords internal
#'
#' @rdname batch_create_job_queue
batch_create_job_queue <- function(jobQueueName, state = NULL, schedulingPolicyArn = NULL, priority, computeEnvironmentOrder, tags = NULL, jobStateTimeLimitActions = NULL) {
  op <- new_operation(
    name = "CreateJobQueue",
    http_method = "POST",
    http_path = "/v1/createjobqueue",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$create_job_queue_input(jobQueueName = jobQueueName, state = state, schedulingPolicyArn = schedulingPolicyArn, priority = priority, computeEnvironmentOrder = computeEnvironmentOrder, tags = tags, jobStateTimeLimitActions = jobStateTimeLimitActions)
  output <- .batch$create_job_queue_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$create_job_queue <- batch_create_job_queue

#' Creates an Batch scheduling policy
#'
#' @description
#' Creates an Batch scheduling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_create_scheduling_policy/](https://www.paws-r-sdk.com/docs/batch_create_scheduling_policy/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the scheduling policy. It can be up to 128 letters long. It
#' can contain uppercase and lowercase letters, numbers, hyphens (-), and
#' underscores (_).
#' @param fairsharePolicy The fair share policy of the scheduling policy.
#' @param tags The tags that you apply to the scheduling policy to help you categorize
#' and organize your resources. Each tag consists of a key and an optional
#' value. For more information, see [Tagging Amazon Web Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in *Amazon Web Services General Reference*.
#' 
#' These tags can be updated or removed using the
#' [`tag_resource`][batch_tag_resource] and
#' [`untag_resource`][batch_untag_resource] API operations.
#'
#' @keywords internal
#'
#' @rdname batch_create_scheduling_policy
batch_create_scheduling_policy <- function(name, fairsharePolicy = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateSchedulingPolicy",
    http_method = "POST",
    http_path = "/v1/createschedulingpolicy",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$create_scheduling_policy_input(name = name, fairsharePolicy = fairsharePolicy, tags = tags)
  output <- .batch$create_scheduling_policy_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$create_scheduling_policy <- batch_create_scheduling_policy

#' Deletes an Batch compute environment
#'
#' @description
#' Deletes an Batch compute environment.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_delete_compute_environment/](https://www.paws-r-sdk.com/docs/batch_delete_compute_environment/) for full documentation.
#'
#' @param computeEnvironment &#91;required&#93; The name or Amazon Resource Name (ARN) of the compute environment to
#' delete.
#'
#' @keywords internal
#'
#' @rdname batch_delete_compute_environment
batch_delete_compute_environment <- function(computeEnvironment) {
  op <- new_operation(
    name = "DeleteComputeEnvironment",
    http_method = "POST",
    http_path = "/v1/deletecomputeenvironment",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$delete_compute_environment_input(computeEnvironment = computeEnvironment)
  output <- .batch$delete_compute_environment_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$delete_compute_environment <- batch_delete_compute_environment

#' Deletes the specified job queue
#'
#' @description
#' Deletes the specified job queue. You must first disable submissions for a queue with the [`update_job_queue`][batch_update_job_queue] operation. All jobs in the queue are eventually terminated when you delete a job queue. The jobs are terminated at a rate of about 16 jobs each second.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_delete_job_queue/](https://www.paws-r-sdk.com/docs/batch_delete_job_queue/) for full documentation.
#'
#' @param jobQueue &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the queue to
#' delete.
#'
#' @keywords internal
#'
#' @rdname batch_delete_job_queue
batch_delete_job_queue <- function(jobQueue) {
  op <- new_operation(
    name = "DeleteJobQueue",
    http_method = "POST",
    http_path = "/v1/deletejobqueue",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$delete_job_queue_input(jobQueue = jobQueue)
  output <- .batch$delete_job_queue_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$delete_job_queue <- batch_delete_job_queue

#' Deletes the specified scheduling policy
#'
#' @description
#' Deletes the specified scheduling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_delete_scheduling_policy/](https://www.paws-r-sdk.com/docs/batch_delete_scheduling_policy/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the scheduling policy to delete.
#'
#' @keywords internal
#'
#' @rdname batch_delete_scheduling_policy
batch_delete_scheduling_policy <- function(arn) {
  op <- new_operation(
    name = "DeleteSchedulingPolicy",
    http_method = "POST",
    http_path = "/v1/deleteschedulingpolicy",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$delete_scheduling_policy_input(arn = arn)
  output <- .batch$delete_scheduling_policy_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$delete_scheduling_policy <- batch_delete_scheduling_policy

#' Deregisters an Batch job definition
#'
#' @description
#' Deregisters an Batch job definition. Job definitions are permanently deleted after 180 days.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_deregister_job_definition/](https://www.paws-r-sdk.com/docs/batch_deregister_job_definition/) for full documentation.
#'
#' @param jobDefinition &#91;required&#93; The name and revision (`name:revision`) or full Amazon Resource Name
#' (ARN) of the job definition to deregister.
#'
#' @keywords internal
#'
#' @rdname batch_deregister_job_definition
batch_deregister_job_definition <- function(jobDefinition) {
  op <- new_operation(
    name = "DeregisterJobDefinition",
    http_method = "POST",
    http_path = "/v1/deregisterjobdefinition",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$deregister_job_definition_input(jobDefinition = jobDefinition)
  output <- .batch$deregister_job_definition_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$deregister_job_definition <- batch_deregister_job_definition

#' Describes one or more of your compute environments
#'
#' @description
#' Describes one or more of your compute environments.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_describe_compute_environments/](https://www.paws-r-sdk.com/docs/batch_describe_compute_environments/) for full documentation.
#'
#' @param computeEnvironments A list of up to 100 compute environment names or full Amazon Resource
#' Name (ARN) entries.
#' @param maxResults The maximum number of cluster results returned by
#' [`describe_compute_environments`][batch_describe_compute_environments]
#' in paginated output. When this parameter is used,
#' [`describe_compute_environments`][batch_describe_compute_environments]
#' only returns `maxResults` results in a single page along with a
#' `nextToken` response element. The remaining results of the initial
#' request can be seen by sending another
#' [`describe_compute_environments`][batch_describe_compute_environments]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If this parameter isn't used, then
#' [`describe_compute_environments`][batch_describe_compute_environments]
#' returns up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_compute_environments`][batch_describe_compute_environments]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value. This value is `null` when
#' there are no more results to return.
#' 
#' Treat this token as an opaque identifier that's only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#'
#' @keywords internal
#'
#' @rdname batch_describe_compute_environments
batch_describe_compute_environments <- function(computeEnvironments = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeComputeEnvironments",
    http_method = "POST",
    http_path = "/v1/describecomputeenvironments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "computeEnvironments")
  )
  input <- .batch$describe_compute_environments_input(computeEnvironments = computeEnvironments, maxResults = maxResults, nextToken = nextToken)
  output <- .batch$describe_compute_environments_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$describe_compute_environments <- batch_describe_compute_environments

#' Describes a list of job definitions
#'
#' @description
#' Describes a list of job definitions. You can specify a `status` (such as `ACTIVE`) to only return job definitions that match that status.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_describe_job_definitions/](https://www.paws-r-sdk.com/docs/batch_describe_job_definitions/) for full documentation.
#'
#' @param jobDefinitions A list of up to 100 job definitions. Each entry in the list can either
#' be an ARN in the format
#' `arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}`
#' or a short version using the form `${JobDefinitionName}:${Revision}`.
#' This parameter can't be used with other parameters.
#' @param maxResults The maximum number of results returned by
#' [`describe_job_definitions`][batch_describe_job_definitions] in
#' paginated output. When this parameter is used,
#' [`describe_job_definitions`][batch_describe_job_definitions] only
#' returns `maxResults` results in a single page and a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another
#' [`describe_job_definitions`][batch_describe_job_definitions] request
#' with the returned `nextToken` value. This value can be between 1 and
#' 100. If this parameter isn't used, then
#' [`describe_job_definitions`][batch_describe_job_definitions] returns up
#' to 100 results and a `nextToken` value if applicable.
#' @param jobDefinitionName The name of the job definition to describe.
#' @param status The status used to filter job definitions.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_job_definitions`][batch_describe_job_definitions] request
#' where `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return.
#' 
#' Treat this token as an opaque identifier that's only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#'
#' @keywords internal
#'
#' @rdname batch_describe_job_definitions
batch_describe_job_definitions <- function(jobDefinitions = NULL, maxResults = NULL, jobDefinitionName = NULL, status = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeJobDefinitions",
    http_method = "POST",
    http_path = "/v1/describejobdefinitions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobDefinitions")
  )
  input <- .batch$describe_job_definitions_input(jobDefinitions = jobDefinitions, maxResults = maxResults, jobDefinitionName = jobDefinitionName, status = status, nextToken = nextToken)
  output <- .batch$describe_job_definitions_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$describe_job_definitions <- batch_describe_job_definitions

#' Describes one or more of your job queues
#'
#' @description
#' Describes one or more of your job queues.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_describe_job_queues/](https://www.paws-r-sdk.com/docs/batch_describe_job_queues/) for full documentation.
#'
#' @param jobQueues A list of up to 100 queue names or full queue Amazon Resource Name (ARN)
#' entries.
#' @param maxResults The maximum number of results returned by
#' [`describe_job_queues`][batch_describe_job_queues] in paginated output.
#' When this parameter is used,
#' [`describe_job_queues`][batch_describe_job_queues] only returns
#' `maxResults` results in a single page and a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_job_queues`][batch_describe_job_queues]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If this parameter isn't used, then
#' [`describe_job_queues`][batch_describe_job_queues] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_job_queues`][batch_describe_job_queues] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return.
#' 
#' Treat this token as an opaque identifier that's only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#'
#' @keywords internal
#'
#' @rdname batch_describe_job_queues
batch_describe_job_queues <- function(jobQueues = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeJobQueues",
    http_method = "POST",
    http_path = "/v1/describejobqueues",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobQueues")
  )
  input <- .batch$describe_job_queues_input(jobQueues = jobQueues, maxResults = maxResults, nextToken = nextToken)
  output <- .batch$describe_job_queues_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$describe_job_queues <- batch_describe_job_queues

#' Describes a list of Batch jobs
#'
#' @description
#' Describes a list of Batch jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_describe_jobs/](https://www.paws-r-sdk.com/docs/batch_describe_jobs/) for full documentation.
#'
#' @param jobs &#91;required&#93; A list of up to 100 job IDs.
#'
#' @keywords internal
#'
#' @rdname batch_describe_jobs
batch_describe_jobs <- function(jobs) {
  op <- new_operation(
    name = "DescribeJobs",
    http_method = "POST",
    http_path = "/v1/describejobs",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$describe_jobs_input(jobs = jobs)
  output <- .batch$describe_jobs_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$describe_jobs <- batch_describe_jobs

#' Describes one or more of your scheduling policies
#'
#' @description
#' Describes one or more of your scheduling policies.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_describe_scheduling_policies/](https://www.paws-r-sdk.com/docs/batch_describe_scheduling_policies/) for full documentation.
#'
#' @param arns &#91;required&#93; A list of up to 100 scheduling policy Amazon Resource Name (ARN)
#' entries.
#'
#' @keywords internal
#'
#' @rdname batch_describe_scheduling_policies
batch_describe_scheduling_policies <- function(arns) {
  op <- new_operation(
    name = "DescribeSchedulingPolicies",
    http_method = "POST",
    http_path = "/v1/describeschedulingpolicies",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$describe_scheduling_policies_input(arns = arns)
  output <- .batch$describe_scheduling_policies_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$describe_scheduling_policies <- batch_describe_scheduling_policies

#' Provides a list of the first 100 RUNNABLE jobs associated to a single
#' job queue
#'
#' @description
#' Provides a list of the first 100 `RUNNABLE` jobs associated to a single job queue.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_get_job_queue_snapshot/](https://www.paws-r-sdk.com/docs/batch_get_job_queue_snapshot/) for full documentation.
#'
#' @param jobQueue &#91;required&#93; The job queue’s name or full queue Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname batch_get_job_queue_snapshot
batch_get_job_queue_snapshot <- function(jobQueue) {
  op <- new_operation(
    name = "GetJobQueueSnapshot",
    http_method = "POST",
    http_path = "/v1/getjobqueuesnapshot",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$get_job_queue_snapshot_input(jobQueue = jobQueue)
  output <- .batch$get_job_queue_snapshot_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$get_job_queue_snapshot <- batch_get_job_queue_snapshot

#' Returns a list of Batch jobs
#'
#' @description
#' Returns a list of Batch jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_list_jobs/](https://www.paws-r-sdk.com/docs/batch_list_jobs/) for full documentation.
#'
#' @param jobQueue The name or full Amazon Resource Name (ARN) of the job queue used to
#' list jobs.
#' @param arrayJobId The job ID for an array job. Specifying an array job ID with this
#' parameter lists all child jobs from within the specified array.
#' @param multiNodeJobId The job ID for a multi-node parallel job. Specifying a multi-node
#' parallel job ID with this parameter lists all nodes that are associated
#' with the specified job.
#' @param jobStatus The job status used to filter jobs in the specified queue. If the
#' `filters` parameter is specified, the `jobStatus` parameter is ignored
#' and jobs with any status are returned. If you don't specify a status,
#' only `RUNNING` jobs are returned.
#' @param maxResults The maximum number of results returned by [`list_jobs`][batch_list_jobs]
#' in a paginated output. When this parameter is used,
#' [`list_jobs`][batch_list_jobs] returns up to `maxResults` results in a
#' single page and a `nextToken` response element, if applicable. The
#' remaining results of the initial request can be seen by sending another
#' [`list_jobs`][batch_list_jobs] request with the returned `nextToken`
#' value.
#' 
#' The following outlines key parameters and limitations:
#' 
#' -   The minimum value is 1.
#' 
#' -   When `--job-status` is used, Batch returns up to 1000 values.
#' 
#' -   When `--filters` is used, Batch returns up to 100 values.
#' 
#' -   If neither parameter is used, then [`list_jobs`][batch_list_jobs]
#'     returns up to 1000 results (jobs that are in the `RUNNING` status)
#'     and a `nextToken` value, if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_jobs`][batch_list_jobs] request where `maxResults` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value. This value is `null` when there are no more results to return.
#' 
#' Treat this token as an opaque identifier that's only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#' @param filters The filter to apply to the query. Only one filter can be used at a time.
#' When the filter is used, `jobStatus` is ignored. The filter doesn't
#' apply to child jobs in an array or multi-node parallel (MNP) jobs. The
#' results are sorted by the `createdAt` field, with the most recent jobs
#' being first.
#' 
#' **JOB_NAME**
#' 
#' The value of the filter is a case-insensitive match for the job name. If
#' the value ends with an asterisk (*), the filter matches any job name
#' that begins with the string before the '*'. This corresponds to the
#' `jobName` value. For example, `test1` matches both `Test1` and `test1`,
#' and `test1*` matches both `test1` and `Test10`. When the `JOB_NAME`
#' filter is used, the results are grouped by the job name and version.
#' 
#' **JOB_DEFINITION**
#' 
#' The value for the filter is the name or Amazon Resource Name (ARN) of
#' the job definition. This corresponds to the `jobDefinition` value. The
#' value is case sensitive. When the value for the filter is the job
#' definition name, the results include all the jobs that used any revision
#' of that job definition name. If the value ends with an asterisk (*),
#' the filter matches any job definition name that begins with the string
#' before the '*'. For example, `jd1` matches only `jd1`, and `jd1*`
#' matches both `jd1` and `jd1A`. The version of the job definition that's
#' used doesn't affect the sort order. When the `JOB_DEFINITION` filter is
#' used and the ARN is used (which is in the form
#' `arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}`),
#' the results include jobs that used the specified revision of the job
#' definition. Asterisk (*) isn't supported when the ARN is used.
#' 
#' **BEFORE_CREATED_AT**
#' 
#' The value for the filter is the time that's before the job was created.
#' This corresponds to the `createdAt` value. The value is a string
#' representation of the number of milliseconds since 00:00:00 UTC
#' (midnight) on January 1, 1970.
#' 
#' **AFTER_CREATED_AT**
#' 
#' The value for the filter is the time that's after the job was created.
#' This corresponds to the `createdAt` value. The value is a string
#' representation of the number of milliseconds since 00:00:00 UTC
#' (midnight) on January 1, 1970.
#'
#' @keywords internal
#'
#' @rdname batch_list_jobs
batch_list_jobs <- function(jobQueue = NULL, arrayJobId = NULL, multiNodeJobId = NULL, jobStatus = NULL, maxResults = NULL, nextToken = NULL, filters = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "POST",
    http_path = "/v1/listjobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobSummaryList")
  )
  input <- .batch$list_jobs_input(jobQueue = jobQueue, arrayJobId = arrayJobId, multiNodeJobId = multiNodeJobId, jobStatus = jobStatus, maxResults = maxResults, nextToken = nextToken, filters = filters)
  output <- .batch$list_jobs_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$list_jobs <- batch_list_jobs

#' Returns a list of Batch scheduling policies
#'
#' @description
#' Returns a list of Batch scheduling policies.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_list_scheduling_policies/](https://www.paws-r-sdk.com/docs/batch_list_scheduling_policies/) for full documentation.
#'
#' @param maxResults The maximum number of results that's returned by
#' [`list_scheduling_policies`][batch_list_scheduling_policies] in
#' paginated output. When this parameter is used,
#' [`list_scheduling_policies`][batch_list_scheduling_policies] only
#' returns `maxResults` results in a single page and a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another
#' [`list_scheduling_policies`][batch_list_scheduling_policies] request
#' with the returned `nextToken` value. This value can be between 1 and
#' 100. If this parameter isn't used,
#' [`list_scheduling_policies`][batch_list_scheduling_policies] returns up
#' to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value that's returned from a previous paginated
#' [`list_scheduling_policies`][batch_list_scheduling_policies] request
#' where `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return.
#' 
#' Treat this token as an opaque identifier that's only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#'
#' @keywords internal
#'
#' @rdname batch_list_scheduling_policies
batch_list_scheduling_policies <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSchedulingPolicies",
    http_method = "POST",
    http_path = "/v1/listschedulingpolicies",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "schedulingPolicies")
  )
  input <- .batch$list_scheduling_policies_input(maxResults = maxResults, nextToken = nextToken)
  output <- .batch$list_scheduling_policies_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$list_scheduling_policies <- batch_list_scheduling_policies

#' Lists the tags for an Batch resource
#'
#' @description
#' Lists the tags for an Batch resource. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs aren't supported.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/batch_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource that tags
#' are listed for. Batch resources that support tags are compute
#' environments, jobs, job definitions, job queues, and scheduling
#' policies. ARNs for child jobs of array and multi-node parallel (MNP)
#' jobs aren't supported.
#'
#' @keywords internal
#'
#' @rdname batch_list_tags_for_resource
batch_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .batch$list_tags_for_resource_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$list_tags_for_resource <- batch_list_tags_for_resource

#' Registers an Batch job definition
#'
#' @description
#' Registers an Batch job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_register_job_definition/](https://www.paws-r-sdk.com/docs/batch_register_job_definition/) for full documentation.
#'
#' @param jobDefinitionName &#91;required&#93; The name of the job definition to register. It can be up to 128 letters
#' long. It can contain uppercase and lowercase letters, numbers, hyphens
#' (-), and underscores (_).
#' @param type &#91;required&#93; The type of job definition. For more information about multi-node
#' parallel jobs, see [Creating a multi-node parallel job
#' definition](https://docs.aws.amazon.com/batch/latest/userguide/) in the
#' *Batch User Guide*.
#' 
#' -   If the value is `container`, then one of the following is required:
#'     `containerProperties`, `ecsProperties`, or `eksProperties`.
#' 
#' -   If the value is `multinode`, then `nodeProperties` is required.
#' 
#' If the job is run on Fargate resources, then `multinode` isn't
#' supported.
#' @param parameters Default parameter substitution placeholders to set in the job
#' definition. Parameters are specified as a key-value pair mapping.
#' Parameters in a [`submit_job`][batch_submit_job] request override any
#' corresponding parameter defaults from the job definition.
#' @param schedulingPriority The scheduling priority for jobs that are submitted with this job
#' definition. This only affects jobs in job queues with a fair share
#' policy. Jobs with a higher scheduling priority are scheduled before jobs
#' with a lower scheduling priority.
#' 
#' The minimum supported value is 0 and the maximum supported value is
#' 9999.
#' @param containerProperties An object with properties specific to Amazon ECS-based single-node
#' container-based jobs. If the job definition's `type` parameter is
#' `container`, then you must specify either `containerProperties` or
#' `nodeProperties`. This must not be specified for Amazon EKS-based job
#' definitions.
#' 
#' If the job runs on Fargate resources, then you must not specify
#' `nodeProperties`; use only `containerProperties`.
#' @param nodeProperties An object with properties specific to multi-node parallel jobs. If you
#' specify node properties for a job, it becomes a multi-node parallel job.
#' For more information, see [Multi-node Parallel
#' Jobs](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html)
#' in the *Batch User Guide*.
#' 
#' If the job runs on Fargate resources, then you must not specify
#' `nodeProperties`; use `containerProperties` instead.
#' 
#' If the job runs on Amazon EKS resources, then you must not specify
#' `nodeProperties`.
#' @param retryStrategy The retry strategy to use for failed jobs that are submitted with this
#' job definition. Any retry strategy that's specified during a
#' [`submit_job`][batch_submit_job] operation overrides the retry strategy
#' defined here. If a job is terminated due to a timeout, it isn't retried.
#' @param propagateTags Specifies whether to propagate the tags from the job or job definition
#' to the corresponding Amazon ECS task. If no value is specified, the tags
#' are not propagated. Tags can only be propagated to the tasks during task
#' creation. For tags with the same name, job tags are given priority over
#' job definitions tags. If the total number of combined tags from the job
#' and job definition is over 50, the job is moved to the `FAILED` state.
#' 
#' If the job runs on Amazon EKS resources, then you must not specify
#' `propagateTags`.
#' @param timeout The timeout configuration for jobs that are submitted with this job
#' definition, after which Batch terminates your jobs if they have not
#' finished. If a job is terminated due to a timeout, it isn't retried. The
#' minimum value for the timeout is 60 seconds. Any timeout configuration
#' that's specified during a [`submit_job`][batch_submit_job] operation
#' overrides the timeout configuration defined here. For more information,
#' see [Job
#' Timeouts](https://docs.aws.amazon.com/batch/latest/userguide/job_timeouts.html)
#' in the *Batch User Guide*.
#' @param tags The tags that you apply to the job definition to help you categorize and
#' organize your resources. Each tag consists of a key and an optional
#' value. For more information, see [Tagging Amazon Web Services
#' Resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
#' in *Batch User Guide*.
#' @param platformCapabilities The platform capabilities required by the job definition. If no value is
#' specified, it defaults to `EC2`. To run the job on Fargate resources,
#' specify `FARGATE`.
#' 
#' If the job runs on Amazon EKS resources, then you must not specify
#' `platformCapabilities`.
#' @param eksProperties An object with properties that are specific to Amazon EKS-based jobs.
#' This must not be specified for Amazon ECS based job definitions.
#' @param ecsProperties An object with properties that are specific to Amazon ECS-based jobs.
#' This must not be specified for Amazon EKS-based job definitions.
#'
#' @keywords internal
#'
#' @rdname batch_register_job_definition
batch_register_job_definition <- function(jobDefinitionName, type, parameters = NULL, schedulingPriority = NULL, containerProperties = NULL, nodeProperties = NULL, retryStrategy = NULL, propagateTags = NULL, timeout = NULL, tags = NULL, platformCapabilities = NULL, eksProperties = NULL, ecsProperties = NULL) {
  op <- new_operation(
    name = "RegisterJobDefinition",
    http_method = "POST",
    http_path = "/v1/registerjobdefinition",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$register_job_definition_input(jobDefinitionName = jobDefinitionName, type = type, parameters = parameters, schedulingPriority = schedulingPriority, containerProperties = containerProperties, nodeProperties = nodeProperties, retryStrategy = retryStrategy, propagateTags = propagateTags, timeout = timeout, tags = tags, platformCapabilities = platformCapabilities, eksProperties = eksProperties, ecsProperties = ecsProperties)
  output <- .batch$register_job_definition_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$register_job_definition <- batch_register_job_definition

#' Submits an Batch job from a job definition
#'
#' @description
#' Submits an Batch job from a job definition. Parameters that are specified during [`submit_job`][batch_submit_job] override parameters defined in the job definition. vCPU and memory requirements that are specified in the `resourceRequirements` objects in the job definition are the exception. They can't be overridden this way using the `memory` and `vcpus` parameters. Rather, you must specify updates to job definition parameters in a `resourceRequirements` object that's included in the `containerOverrides` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_submit_job/](https://www.paws-r-sdk.com/docs/batch_submit_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name of the job. It can be up to 128 letters long. The first
#' character must be alphanumeric, can contain uppercase and lowercase
#' letters, numbers, hyphens (-), and underscores (_).
#' @param jobQueue &#91;required&#93; The job queue where the job is submitted. You can specify either the
#' name or the Amazon Resource Name (ARN) of the queue.
#' @param shareIdentifier The share identifier for the job. Don't specify this parameter if the
#' job queue doesn't have a scheduling policy. If the job queue has a
#' scheduling policy, then this parameter must be specified.
#' 
#' This string is limited to 255 alphanumeric characters, and can be
#' followed by an asterisk (*).
#' @param schedulingPriorityOverride The scheduling priority for the job. This only affects jobs in job
#' queues with a fair share policy. Jobs with a higher scheduling priority
#' are scheduled before jobs with a lower scheduling priority. This
#' overrides any scheduling priority in the job definition and works only
#' within a single share identifier.
#' 
#' The minimum supported value is 0 and the maximum supported value is
#' 9999.
#' @param arrayProperties The array properties for the submitted job, such as the size of the
#' array. The array size can be between 2 and 10,000. If you specify array
#' properties for a job, it becomes an array job. For more information, see
#' [Array
#' Jobs](https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html)
#' in the *Batch User Guide*.
#' @param dependsOn A list of dependencies for the job. A job can depend upon a maximum of
#' 20 jobs. You can specify a `SEQUENTIAL` type dependency without
#' specifying a job ID for array jobs so that each child array job
#' completes sequentially, starting at index 0. You can also specify an
#' `N_TO_N` type dependency with a job ID for array jobs. In that case,
#' each index child of this job must wait for the corresponding index child
#' of each dependency to complete before it can begin.
#' @param jobDefinition &#91;required&#93; The job definition used by this job. This value can be one of
#' `definition-name`, `definition-name:revision`, or the Amazon Resource
#' Name (ARN) for the job definition, with or without the revision
#' (`arn:aws:batch:region:account:job-definition/definition-name:revision `,
#' or `arn:aws:batch:region:account:job-definition/definition-name `).
#' 
#' If the revision is not specified, then the latest active revision is
#' used.
#' @param parameters Additional parameters passed to the job that replace parameter
#' substitution placeholders that are set in the job definition. Parameters
#' are specified as a key and value pair mapping. Parameters in a
#' [`submit_job`][batch_submit_job] request override any corresponding
#' parameter defaults from the job definition.
#' @param containerOverrides An object with properties that override the defaults for the job
#' definition that specify the name of a container in the specified job
#' definition and the overrides it should receive. You can override the
#' default command for a container, which is specified in the job
#' definition or the Docker image, with a `command` override. You can also
#' override existing environment variables on a container or add new
#' environment variables to it with an `environment` override.
#' @param nodeOverrides A list of node overrides in JSON format that specify the node range to
#' target and the container overrides for that node range.
#' 
#' This parameter isn't applicable to jobs that are running on Fargate
#' resources; use `containerOverrides` instead.
#' @param retryStrategy The retry strategy to use for failed jobs from this
#' [`submit_job`][batch_submit_job] operation. When a retry strategy is
#' specified here, it overrides the retry strategy defined in the job
#' definition.
#' @param propagateTags Specifies whether to propagate the tags from the job or job definition
#' to the corresponding Amazon ECS task. If no value is specified, the tags
#' aren't propagated. Tags can only be propagated to the tasks during task
#' creation. For tags with the same name, job tags are given priority over
#' job definitions tags. If the total number of combined tags from the job
#' and job definition is over 50, the job is moved to the `FAILED` state.
#' When specified, this overrides the tag propagation setting in the job
#' definition.
#' @param timeout The timeout configuration for this [`submit_job`][batch_submit_job]
#' operation. You can specify a timeout duration after which Batch
#' terminates your jobs if they haven't finished. If a job is terminated
#' due to a timeout, it isn't retried. The minimum value for the timeout is
#' 60 seconds. This configuration overrides any timeout configuration
#' specified in the job definition. For array jobs, child jobs have the
#' same timeout configuration as the parent job. For more information, see
#' [Job
#' Timeouts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param tags The tags that you apply to the job request to help you categorize and
#' organize your resources. Each tag consists of a key and an optional
#' value. For more information, see [Tagging Amazon Web Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in *Amazon Web Services General Reference*.
#' @param eksPropertiesOverride An object, with properties that override defaults for the job
#' definition, can only be specified for jobs that are run on Amazon EKS
#' resources.
#' @param ecsPropertiesOverride An object, with properties that override defaults for the job
#' definition, can only be specified for jobs that are run on Amazon ECS
#' resources.
#'
#' @keywords internal
#'
#' @rdname batch_submit_job
batch_submit_job <- function(jobName, jobQueue, shareIdentifier = NULL, schedulingPriorityOverride = NULL, arrayProperties = NULL, dependsOn = NULL, jobDefinition, parameters = NULL, containerOverrides = NULL, nodeOverrides = NULL, retryStrategy = NULL, propagateTags = NULL, timeout = NULL, tags = NULL, eksPropertiesOverride = NULL, ecsPropertiesOverride = NULL) {
  op <- new_operation(
    name = "SubmitJob",
    http_method = "POST",
    http_path = "/v1/submitjob",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$submit_job_input(jobName = jobName, jobQueue = jobQueue, shareIdentifier = shareIdentifier, schedulingPriorityOverride = schedulingPriorityOverride, arrayProperties = arrayProperties, dependsOn = dependsOn, jobDefinition = jobDefinition, parameters = parameters, containerOverrides = containerOverrides, nodeOverrides = nodeOverrides, retryStrategy = retryStrategy, propagateTags = propagateTags, timeout = timeout, tags = tags, eksPropertiesOverride = eksPropertiesOverride, ecsPropertiesOverride = ecsPropertiesOverride)
  output <- .batch$submit_job_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$submit_job <- batch_submit_job

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs aren't supported.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_tag_resource/](https://www.paws-r-sdk.com/docs/batch_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that tags are added to.
#' Batch resources that support tags are compute environments, jobs, job
#' definitions, job queues, and scheduling policies. ARNs for child jobs of
#' array and multi-node parallel (MNP) jobs aren't supported.
#' @param tags &#91;required&#93; The tags that you apply to the resource to help you categorize and
#' organize your resources. Each tag consists of a key and an optional
#' value. For more information, see [Tagging Amazon Web Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname batch_tag_resource
batch_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .batch$tag_resource_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$tag_resource <- batch_tag_resource

#' Terminates a job in a job queue
#'
#' @description
#' Terminates a job in a job queue. Jobs that are in the `STARTING` or `RUNNING` state are terminated, which causes them to transition to `FAILED`. Jobs that have not progressed to the `STARTING` state are cancelled.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_terminate_job/](https://www.paws-r-sdk.com/docs/batch_terminate_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The Batch job ID of the job to terminate.
#' @param reason &#91;required&#93; A message to attach to the job that explains the reason for canceling
#' it. This message is returned by future
#' [`describe_jobs`][batch_describe_jobs] operations on the job. This
#' message is also recorded in the Batch activity logs.
#'
#' @keywords internal
#'
#' @rdname batch_terminate_job
batch_terminate_job <- function(jobId, reason) {
  op <- new_operation(
    name = "TerminateJob",
    http_method = "POST",
    http_path = "/v1/terminatejob",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$terminate_job_input(jobId = jobId, reason = reason)
  output <- .batch$terminate_job_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$terminate_job <- batch_terminate_job

#' Deletes specified tags from an Batch resource
#'
#' @description
#' Deletes specified tags from an Batch resource.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_untag_resource/](https://www.paws-r-sdk.com/docs/batch_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to delete
#' tags. Batch resources that support tags are compute environments, jobs,
#' job definitions, job queues, and scheduling policies. ARNs for child
#' jobs of array and multi-node parallel (MNP) jobs aren't supported.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname batch_untag_resource
batch_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .batch$untag_resource_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$untag_resource <- batch_untag_resource

#' Updates an Batch compute environment
#'
#' @description
#' Updates an Batch compute environment.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_update_compute_environment/](https://www.paws-r-sdk.com/docs/batch_update_compute_environment/) for full documentation.
#'
#' @param computeEnvironment &#91;required&#93; The name or full Amazon Resource Name (ARN) of the compute environment
#' to update.
#' @param state The state of the compute environment. Compute environments in the
#' `ENABLED` state can accept jobs from a queue and scale in or out
#' automatically based on the workload demand of its associated queues.
#' 
#' If the state is `ENABLED`, then the Batch scheduler can attempt to place
#' jobs from an associated job queue on the compute resources within the
#' environment. If the compute environment is managed, then it can scale
#' its instances out or in automatically, based on the job queue demand.
#' 
#' If the state is `DISABLED`, then the Batch scheduler doesn't attempt to
#' place jobs within the environment. Jobs in a `STARTING` or `RUNNING`
#' state continue to progress normally. Managed compute environments in the
#' `DISABLED` state don't scale out.
#' 
#' Compute environments in a `DISABLED` state may continue to incur billing
#' charges. To prevent additional charges, turn off and then delete the
#' compute environment. For more information, see
#' [State](https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state)
#' in the *Batch User Guide*.
#' 
#' When an instance is idle, the instance scales down to the `minvCpus`
#' value. However, the instance size doesn't change. For example, consider
#' a `c5.8xlarge` instance with a `minvCpus` value of `4` and a
#' `desiredvCpus` value of `36`. This instance doesn't scale down to a
#' `c5.large` instance.
#' @param unmanagedvCpus The maximum number of vCPUs expected to be used for an unmanaged compute
#' environment. Don't specify this parameter for a managed compute
#' environment. This parameter is only used for fair share scheduling to
#' reserve vCPU capacity for new share identifiers. If this parameter isn't
#' provided for a fair share job queue, no vCPU capacity is reserved.
#' @param computeResources Details of the compute resources managed by the compute environment.
#' Required for a managed compute environment. For more information, see
#' [Compute
#' Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
#' in the *Batch User Guide*.
#' @param serviceRole The full Amazon Resource Name (ARN) of the IAM role that allows Batch to
#' make calls to other Amazon Web Services services on your behalf. For
#' more information, see [Batch service IAM
#' role](https://docs.aws.amazon.com/batch/latest/userguide/using-service-linked-roles.html)
#' in the *Batch User Guide*.
#' 
#' If the compute environment has a service-linked role, it can't be
#' changed to use a regular IAM role. Likewise, if the compute environment
#' has a regular IAM role, it can't be changed to use a service-linked
#' role. To update the parameters for the compute environment that require
#' an infrastructure update to change, the **AWSServiceRoleForBatch**
#' service-linked role must be used. For more information, see [Updating
#' compute
#' environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
#' in the *Batch User Guide*.
#' 
#' If your specified role has a path other than `/`, then you must either
#' specify the full role ARN (recommended) or prefix the role name with the
#' path.
#' 
#' Depending on how you created your Batch service role, its ARN might
#' contain the `service-role` path prefix. When you only specify the name
#' of the service role, Batch assumes that your ARN doesn't use the
#' `service-role` path prefix. Because of this, we recommend that you
#' specify the full ARN of your service role when you create compute
#' environments.
#' @param updatePolicy Specifies the updated infrastructure update policy for the compute
#' environment. For more information about infrastructure updates, see
#' [Updating compute
#' environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
#' in the *Batch User Guide*.
#' @param context Reserved.
#'
#' @keywords internal
#'
#' @rdname batch_update_compute_environment
batch_update_compute_environment <- function(computeEnvironment, state = NULL, unmanagedvCpus = NULL, computeResources = NULL, serviceRole = NULL, updatePolicy = NULL, context = NULL) {
  op <- new_operation(
    name = "UpdateComputeEnvironment",
    http_method = "POST",
    http_path = "/v1/updatecomputeenvironment",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$update_compute_environment_input(computeEnvironment = computeEnvironment, state = state, unmanagedvCpus = unmanagedvCpus, computeResources = computeResources, serviceRole = serviceRole, updatePolicy = updatePolicy, context = context)
  output <- .batch$update_compute_environment_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$update_compute_environment <- batch_update_compute_environment

#' Updates a job queue
#'
#' @description
#' Updates a job queue.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_update_job_queue/](https://www.paws-r-sdk.com/docs/batch_update_job_queue/) for full documentation.
#'
#' @param jobQueue &#91;required&#93; The name or the Amazon Resource Name (ARN) of the job queue.
#' @param state Describes the queue's ability to accept new jobs. If the job queue state
#' is `ENABLED`, it can accept jobs. If the job queue state is `DISABLED`,
#' new jobs can't be added to the queue, but jobs already in the queue can
#' finish.
#' @param schedulingPolicyArn Amazon Resource Name (ARN) of the fair share scheduling policy. Once a
#' job queue is created, the fair share scheduling policy can be replaced
#' but not removed. The format is
#' `aws:Partition:batch:Region:Account:scheduling-policy/Name `. For
#' example,
#' `aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy`.
#' @param priority The priority of the job queue. Job queues with a higher priority (or a
#' higher integer value for the `priority` parameter) are evaluated first
#' when associated with the same compute environment. Priority is
#' determined in descending order. For example, a job queue with a priority
#' value of `10` is given scheduling preference over a job queue with a
#' priority value of `1`. All of the compute environments must be either
#' EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`). EC2 and
#' Fargate compute environments can't be mixed.
#' @param computeEnvironmentOrder Details the set of compute environments mapped to a job queue and their
#' order relative to each other. This is one of the parameters used by the
#' job scheduler to determine which compute environment runs a given job.
#' Compute environments must be in the `VALID` state before you can
#' associate them with a job queue. All of the compute environments must be
#' either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`).
#' EC2 and Fargate compute environments can't be mixed.
#' 
#' All compute environments that are associated with a job queue must share
#' the same architecture. Batch doesn't support mixing compute environment
#' architecture types in a single job queue.
#' @param jobStateTimeLimitActions The set of actions that Batch perform on jobs that remain at the head of
#' the job queue in the specified state longer than specified times. Batch
#' will perform each action after `maxTimeSeconds` has passed.
#'
#' @keywords internal
#'
#' @rdname batch_update_job_queue
batch_update_job_queue <- function(jobQueue, state = NULL, schedulingPolicyArn = NULL, priority = NULL, computeEnvironmentOrder = NULL, jobStateTimeLimitActions = NULL) {
  op <- new_operation(
    name = "UpdateJobQueue",
    http_method = "POST",
    http_path = "/v1/updatejobqueue",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$update_job_queue_input(jobQueue = jobQueue, state = state, schedulingPolicyArn = schedulingPolicyArn, priority = priority, computeEnvironmentOrder = computeEnvironmentOrder, jobStateTimeLimitActions = jobStateTimeLimitActions)
  output <- .batch$update_job_queue_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$update_job_queue <- batch_update_job_queue

#' Updates a scheduling policy
#'
#' @description
#' Updates a scheduling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/batch_update_scheduling_policy/](https://www.paws-r-sdk.com/docs/batch_update_scheduling_policy/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the scheduling policy to update.
#' @param fairsharePolicy The fair share policy.
#'
#' @keywords internal
#'
#' @rdname batch_update_scheduling_policy
batch_update_scheduling_policy <- function(arn, fairsharePolicy = NULL) {
  op <- new_operation(
    name = "UpdateSchedulingPolicy",
    http_method = "POST",
    http_path = "/v1/updateschedulingpolicy",
    host_prefix = "",
    paginator = list()
  )
  input <- .batch$update_scheduling_policy_input(arn = arn, fairsharePolicy = fairsharePolicy)
  output <- .batch$update_scheduling_policy_output()
  config <- get_config()
  svc <- .batch$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.batch$operations$update_scheduling_policy <- batch_update_scheduling_policy
