% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_vpc_cidr_block}
\alias{ec2_associate_vpc_cidr_block}
\title{Associates a CIDR block with your VPC}
\usage{
ec2_associate_vpc_cidr_block(
  CidrBlock = NULL,
  Ipv6CidrBlockNetworkBorderGroup = NULL,
  Ipv6Pool = NULL,
  Ipv6CidrBlock = NULL,
  Ipv4IpamPoolId = NULL,
  Ipv4NetmaskLength = NULL,
  Ipv6IpamPoolId = NULL,
  Ipv6NetmaskLength = NULL,
  VpcId,
  AmazonProvidedIpv6CidrBlock = NULL
)
}
\arguments{
\item{CidrBlock}{An IPv4 CIDR block to associate with the VPC.}

\item{Ipv6CidrBlockNetworkBorderGroup}{The name of the location from which we advertise the IPV6 CIDR block.
Use this parameter to limit the CIDR block to this location.

You must set \code{AmazonProvidedIpv6CidrBlock} to \code{true} to use this
parameter.

You can have one IPv6 CIDR block association per network border group.}

\item{Ipv6Pool}{The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
block.}

\item{Ipv6CidrBlock}{An IPv6 CIDR block from the IPv6 address pool. You must also specify
\code{Ipv6Pool} in the request.

To let Amazon choose the IPv6 CIDR block for you, omit this parameter.}

\item{Ipv4IpamPoolId}{Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more
information about Amazon VPC IP Address Manager (IPAM), see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{Ipv4NetmaskLength}{The netmask length of the IPv4 CIDR you would like to associate from an
Amazon VPC IP Address Manager (IPAM) pool. For more information about
IPAM, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?}
in the \emph{Amazon VPC IPAM User Guide}.}

\item{Ipv6IpamPoolId}{Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more
information about Amazon VPC IP Address Manager (IPAM), see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{Ipv6NetmaskLength}{The netmask length of the IPv6 CIDR you would like to associate from an
Amazon VPC IP Address Manager (IPAM) pool. For more information about
IPAM, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?}
in the \emph{Amazon VPC IPAM User Guide}.}

\item{VpcId}{[required] The ID of the VPC.}

\item{AmazonProvidedIpv6CidrBlock}{Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
the VPC. You cannot specify the range of IPv6 addresses or the size of
the CIDR block.}
}
\description{
Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{BYOIP}).

See \url{https://www.paws-r-sdk.com/docs/ec2_associate_vpc_cidr_block/} for full documentation.
}
\keyword{internal}
