% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_cluster}
\alias{ecs_create_cluster}
\title{Creates a new Amazon ECS cluster}
\usage{
ecs_create_cluster(
  clusterName = NULL,
  tags = NULL,
  settings = NULL,
  configuration = NULL,
  capacityProviders = NULL,
  defaultCapacityProviderStrategy = NULL,
  serviceConnectDefaults = NULL
)
}
\arguments{
\item{clusterName}{The name of your cluster. If you don't specify a name for your cluster,
you create a cluster that's named \code{default}. Up to 255 letters
(uppercase and lowercase), numbers, underscores, and hyphens are
allowed.}

\item{tags}{The metadata that you apply to the cluster to help you categorize and
organize them. Each tag consists of a key and an optional value. You
define both.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}

\item{settings}{The setting to use when creating a cluster. This parameter is used to
turn on CloudWatch Container Insights for a cluster. If this value is
specified, it overrides the \code{containerInsights} value set with
\code{\link[=ecs_put_account_setting]{put_account_setting}} or
\code{\link[=ecs_put_account_setting_default]{put_account_setting_default}}.}

\item{configuration}{The \code{execute} command configuration for the cluster.}

\item{capacityProviders}{The short name of one or more capacity providers to associate with the
cluster. A capacity provider must be associated with a cluster before it
can be included as part of the default capacity provider strategy of the
cluster or used in a capacity provider strategy when calling the
\code{\link[=ecs_create_service]{create_service}} or \code{\link[=ecs_run_task]{run_task}}
actions.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must be created but not associated with another
cluster. New Auto Scaling group capacity providers can be created with
the \code{\link[=ecs_create_capacity_provider]{create_capacity_provider}} API
operation.

To use a Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The Fargate capacity providers are
available to all accounts and only need to be associated with a cluster
to be used.

The
\href{https://docs.aws.amazon.com/AmazonECS/latest/APIReference/}{PutCapacityProvider}
API operation is used to update the list of available capacity providers
for a cluster after the cluster is created.}

\item{defaultCapacityProviderStrategy}{The capacity provider strategy to set as the default for the cluster.
After a default capacity provider strategy is set for a cluster, when
you call the \code{\link[=ecs_create_service]{create_service}} or
\code{\link[=ecs_run_task]{run_task}} APIs with no capacity provider strategy or
launch type specified, the default capacity provider strategy for the
cluster is used.

If a default capacity provider strategy isn't defined for a cluster when
it was created, it can be defined later with the
\code{\link[=ecs_put_cluster_capacity_providers]{put_cluster_capacity_providers}}
API operation.}

\item{serviceConnectDefaults}{Use this parameter to set a default Service Connect namespace. After you
set a default Service Connect namespace, any new services with Service
Connect turned on that are created in the cluster are added as client
services in the namespace. This setting only applies to new services
that set the \code{enabled} parameter to \code{true} in the
\code{ServiceConnectConfiguration}. You can set the namespace of each service
individually in the \code{ServiceConnectConfiguration} to override this
default parameter.

Tasks that run in a namespace can use short names to connect to services
in the namespace. Tasks can connect to services across all of the
clusters in the namespace. Tasks connect through a managed proxy
container that collects logs and metrics for increased visibility. Only
the tasks that Amazon ECS services create are supported with Service
Connect. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html}{Service Connect}
in the \emph{Amazon Elastic Container Service Developer Guide}.}
}
\description{
Creates a new Amazon ECS cluster. By default, your account receives a \code{default} cluster when you launch your first container instance. However, you can create your own cluster with a unique name.

See \url{https://www.paws-r-sdk.com/docs/ecs_create_cluster/} for full documentation.
}
\keyword{internal}
