% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_update_custom_verification_email_template}
\alias{ses_update_custom_verification_email_template}
\title{Updates an existing custom verification email template}
\usage{
ses_update_custom_verification_email_template(TemplateName,
  FromEmailAddress, TemplateSubject, TemplateContent,
  SuccessRedirectionURL, FailureRedirectionURL)
}
\arguments{
\item{TemplateName}{[required] The name of the custom verification email template that you want to
update.}

\item{FromEmailAddress}{The email address that the custom verification email is sent from.}

\item{TemplateSubject}{The subject line of the custom verification email.}

\item{TemplateContent}{The content of the custom verification email. The total size of the
email must be less than 10 MB. The message body may contain HTML, with
some limitations. For more information, see \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq}{Custom Verification Email Frequently Asked Questions}
in the \emph{Amazon SES Developer Guide}.}

\item{SuccessRedirectionURL}{The URL that the recipient of the verification email is sent to if his
or her address is successfully verified.}

\item{FailureRedirectionURL}{The URL that the recipient of the verification email is sent to if his
or her address is not successfully verified.}
}
\value{
An empty list.
}
\description{
Updates an existing custom verification email template.

For more information about custom verification email templates, see
\href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html}{Using Custom Verification Email Templates}
in the \emph{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$update_custom_verification_email_template(
  TemplateName = "string",
  FromEmailAddress = "string",
  TemplateSubject = "string",
  TemplateContent = "string",
  SuccessRedirectionURL = "string",
  FailureRedirectionURL = "string"
)
}
}

\keyword{internal}
