% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_global_clusters}
\alias{rds_describe_global_clusters}
\title{Returns information about Aurora global database clusters}
\usage{
rds_describe_global_clusters(GlobalClusterIdentifier, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{GlobalClusterIdentifier}{The user-supplied DB cluster identifier. If this parameter is specified,
information from only the specific DB cluster is returned. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match an existing DBClusterIdentifier.
}}

\item{Filters}{A filter that specifies one or more global DB clusters to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list will only include
information about the DB clusters identified by these ARNs.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
DescribeGlobalClusters request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns information about Aurora global database clusters. This API
supports pagination.
}
\details{
For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_global_clusters(
  GlobalClusterIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
