% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_custom_availability_zones}
\alias{rds_describe_custom_availability_zones}
\title{Returns information about custom Availability Zones (AZs)}
\usage{
rds_describe_custom_availability_zones(CustomAvailabilityZoneId,
  Filters, MaxRecords, Marker)
}
\arguments{
\item{CustomAvailabilityZoneId}{The custom AZ identifier. If this parameter is specified, information
from only the specific custom AZ is returned.}

\item{Filters}{A filter that specifies one or more custom AZs to describe.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_custom_availability_zones]{describe_custom_availability_zones}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  CustomAvailabilityZones = list(
    list(
      CustomAvailabilityZoneId = "string",
      CustomAvailabilityZoneName = "string",
      CustomAvailabilityZoneStatus = "string",
      VpnDetails = list(
        VpnId = "string",
        VpnTunnelOriginatorIP = "string",
        VpnGatewayIp = "string",
        VpnPSK = "string",
        VpnName = "string",
        VpnState = "string"
      )
    )
  )
)
}
}
\description{
Returns information about custom Availability Zones (AZs).

A custom AZ is an on-premises AZ that is integrated with a VMware
vSphere cluster.

For more information about RDS on VMware, see the \href{https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html}{RDS on VMware User Guide.}
}
\section{Request syntax}{
\preformatted{svc$describe_custom_availability_zones(
  CustomAvailabilityZoneId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
