# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include elasticache_service.R
NULL

#' Adds up to 50 cost allocation tags to the named resource
#'
#' Adds up to 50 cost allocation tags to the named resource. A cost
#' allocation tag is a key-value pair where the key and value are
#' case-sensitive. You can use cost allocation tags to categorize and track
#' your AWS costs.
#' 
#' When you apply tags to your ElastiCache resources, AWS generates a cost
#' allocation report as a comma-separated value (CSV) file with your usage
#' and costs aggregated by your tags. You can apply tags that represent
#' business categories (such as cost centers, application names, or owners)
#' to organize your costs across multiple services. For more information,
#' see [Using Cost Allocation Tags in Amazon
#' ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html)
#' in the *ElastiCache User Guide*.
#'
#' @usage
#' elasticache_add_tags_to_resource(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which the tags are to
#' be added, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#' ElastiCache resources are *cluster* and *snapshot*.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param Tags &#91;required&#93; A list of cost allocation tags to be added to this resource. A tag is a
#' key-value pair. A tag key must be accompanied by a tag value.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_add_tags_to_resource
elasticache_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .elasticache$add_tags_to_resource_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$add_tags_to_resource <- elasticache_add_tags_to_resource

#' Allows network ingress to a cache security group
#'
#' Allows network ingress to a cache security group. Applications using
#' ElastiCache must be running on Amazon EC2, and Amazon EC2 security
#' groups are used as the authorization mechanism.
#' 
#' You cannot authorize ingress from an Amazon EC2 security group in one
#' region to an ElastiCache cluster in another region.
#'
#' @usage
#' elasticache_authorize_cache_security_group_ingress(
#'   CacheSecurityGroupName, EC2SecurityGroupName, EC2SecurityGroupOwnerId)
#'
#' @param CacheSecurityGroupName &#91;required&#93; The cache security group that allows network ingress.
#' @param EC2SecurityGroupName &#91;required&#93; The Amazon EC2 security group to be authorized for ingress to the cache
#' security group.
#' @param EC2SecurityGroupOwnerId &#91;required&#93; The AWS account number of the Amazon EC2 security group owner. Note that
#' this is not the same thing as an AWS access key ID - you must provide a
#' valid AWS account number for this parameter.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_cache_security_group_ingress(
#'   CacheSecurityGroupName = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_authorize_cache_security_group_ingress
elasticache_authorize_cache_security_group_ingress <- function(CacheSecurityGroupName, EC2SecurityGroupName, EC2SecurityGroupOwnerId) {
  op <- new_operation(
    name = "AuthorizeCacheSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$authorize_cache_security_group_ingress_input(CacheSecurityGroupName = CacheSecurityGroupName, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .elasticache$authorize_cache_security_group_ingress_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$authorize_cache_security_group_ingress <- elasticache_authorize_cache_security_group_ingress

#' Apply the service update
#'
#' Apply the service update. For more information on service updates and
#' applying them, see [Applying Service
#' Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
#'
#' @usage
#' elasticache_batch_apply_update_action(ReplicationGroupIds,
#'   ServiceUpdateName)
#'
#' @param ReplicationGroupIds &#91;required&#93; The replication group IDs
#' @param ServiceUpdateName &#91;required&#93; The unique ID of the service update
#'
#' @section Request syntax:
#' ```
#' svc$batch_apply_update_action(
#'   ReplicationGroupIds = list(
#'     "string"
#'   ),
#'   ServiceUpdateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_batch_apply_update_action
elasticache_batch_apply_update_action <- function(ReplicationGroupIds, ServiceUpdateName) {
  op <- new_operation(
    name = "BatchApplyUpdateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$batch_apply_update_action_input(ReplicationGroupIds = ReplicationGroupIds, ServiceUpdateName = ServiceUpdateName)
  output <- .elasticache$batch_apply_update_action_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$batch_apply_update_action <- elasticache_batch_apply_update_action

#' Stop the service update
#'
#' Stop the service update. For more information on service updates and
#' stopping them, see [Stopping Service
#' Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
#'
#' @usage
#' elasticache_batch_stop_update_action(ReplicationGroupIds,
#'   ServiceUpdateName)
#'
#' @param ReplicationGroupIds &#91;required&#93; The replication group IDs
#' @param ServiceUpdateName &#91;required&#93; The unique ID of the service update
#'
#' @section Request syntax:
#' ```
#' svc$batch_stop_update_action(
#'   ReplicationGroupIds = list(
#'     "string"
#'   ),
#'   ServiceUpdateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_batch_stop_update_action
elasticache_batch_stop_update_action <- function(ReplicationGroupIds, ServiceUpdateName) {
  op <- new_operation(
    name = "BatchStopUpdateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$batch_stop_update_action_input(ReplicationGroupIds = ReplicationGroupIds, ServiceUpdateName = ServiceUpdateName)
  output <- .elasticache$batch_stop_update_action_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$batch_stop_update_action <- elasticache_batch_stop_update_action

#' Makes a copy of an existing snapshot
#'
#' Makes a copy of an existing snapshot.
#' 
#' This operation is valid for Redis only.
#' 
#' Users or groups that have permissions to use the `CopySnapshot`
#' operation can create their own Amazon S3 buckets and copy snapshots to
#' it. To control access to your snapshots, use an IAM policy to control
#' who has the ability to use the `CopySnapshot` operation. For more
#' information about using IAM to control the use of ElastiCache
#' operations, see [Exporting
#' Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html)
#' and [Authentication & Access
#' Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
#' 
#' You could receive the following error messages.
#' 
#' **Error Messages**
#' 
#' -   **Error Message:** The S3 bucket \%s is outside of the region.
#' 
#'     **Solution:** Create an Amazon S3 bucket in the same region as your
#'     snapshot. For more information, see [Step 1: Create an Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
#'     in the ElastiCache User Guide.
#' 
#' -   **Error Message:** The S3 bucket \%s does not exist.
#' 
#'     **Solution:** Create an Amazon S3 bucket in the same region as your
#'     snapshot. For more information, see [Step 1: Create an Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
#'     in the ElastiCache User Guide.
#' 
#' -   **Error Message:** The S3 bucket \%s is not owned by the
#'     authenticated user.
#' 
#'     **Solution:** Create an Amazon S3 bucket in the same region as your
#'     snapshot. For more information, see [Step 1: Create an Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
#'     in the ElastiCache User Guide.
#' 
#' -   **Error Message:** The authenticated user does not have sufficient
#'     permissions to perform the desired activity.
#' 
#'     **Solution:** Contact your system administrator to get the needed
#'     permissions.
#' 
#' -   **Error Message:** The S3 bucket \%s already contains an object with
#'     key \%s.
#' 
#'     **Solution:** Give the `TargetSnapshotName` a new and unique value.
#'     If exporting a snapshot, you could alternatively create a new Amazon
#'     S3 bucket and use this same value for `TargetSnapshotName`.
#' 
#' -   **Error Message:** ElastiCache has not been granted READ permissions
#'     \%s on the S3 Bucket.
#' 
#'     **Solution:** Add List and Read permissions on the bucket. For more
#'     information, see [Step 2: Grant ElastiCache Access to Your Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
#'     in the ElastiCache User Guide.
#' 
#' -   **Error Message:** ElastiCache has not been granted WRITE
#'     permissions \%s on the S3 Bucket.
#' 
#'     **Solution:** Add Upload/Delete permissions on the bucket. For more
#'     information, see [Step 2: Grant ElastiCache Access to Your Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
#'     in the ElastiCache User Guide.
#' 
#' -   **Error Message:** ElastiCache has not been granted READ\\_ACP
#'     permissions \%s on the S3 Bucket.
#' 
#'     **Solution:** Add View Permissions on the bucket. For more
#'     information, see [Step 2: Grant ElastiCache Access to Your Amazon S3
#'     Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
#'     in the ElastiCache User Guide.
#'
#' @usage
#' elasticache_copy_snapshot(SourceSnapshotName, TargetSnapshotName,
#'   TargetBucket)
#'
#' @param SourceSnapshotName &#91;required&#93; The name of an existing snapshot from which to make a copy.
#' @param TargetSnapshotName &#91;required&#93; A name for the snapshot copy. ElastiCache does not permit overwriting a
#' snapshot, therefore this name must be unique within its context -
#' ElastiCache or an Amazon S3 bucket if exporting.
#' @param TargetBucket The Amazon S3 bucket to which the snapshot is exported. This parameter
#' is used only when exporting a snapshot for external access.
#' 
#' When using this parameter to export a snapshot, be sure Amazon
#' ElastiCache has the needed permissions to this S3 bucket. For more
#' information, see [Step 2: Grant ElastiCache Access to Your Amazon S3
#' Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
#' in the *Amazon ElastiCache User Guide*.
#' 
#' For more information, see [Exporting a
#' Snapshot](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html)
#' in the *Amazon ElastiCache User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$copy_snapshot(
#'   SourceSnapshotName = "string",
#'   TargetSnapshotName = "string",
#'   TargetBucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_copy_snapshot
elasticache_copy_snapshot <- function(SourceSnapshotName, TargetSnapshotName, TargetBucket = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$copy_snapshot_input(SourceSnapshotName = SourceSnapshotName, TargetSnapshotName = TargetSnapshotName, TargetBucket = TargetBucket)
  output <- .elasticache$copy_snapshot_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$copy_snapshot <- elasticache_copy_snapshot

#' Creates a cluster
#'
#' Creates a cluster. All nodes in the cluster run the same
#' protocol-compliant cache engine software, either Memcached or Redis.
#' 
#' This operation is not supported for Redis (cluster mode enabled)
#' clusters.
#'
#' @usage
#' elasticache_create_cache_cluster(CacheClusterId, ReplicationGroupId,
#'   AZMode, PreferredAvailabilityZone, PreferredAvailabilityZones,
#'   NumCacheNodes, CacheNodeType, Engine, EngineVersion,
#'   CacheParameterGroupName, CacheSubnetGroupName, CacheSecurityGroupNames,
#'   SecurityGroupIds, Tags, SnapshotArns, SnapshotName,
#'   PreferredMaintenanceWindow, Port, NotificationTopicArn,
#'   AutoMinorVersionUpgrade, SnapshotRetentionLimit, SnapshotWindow,
#'   AuthToken)
#'
#' @param CacheClusterId &#91;required&#93; The node group (shard) identifier. This parameter is stored as a
#' lowercase string.
#' 
#' **Constraints:**
#' 
#' -   A name must contain from 1 to 20 alphanumeric characters or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   A name cannot end with a hyphen or contain two consecutive hyphens.
#' @param ReplicationGroupId The ID of the replication group to which this cluster should belong. If
#' this parameter is specified, the cluster is added to the specified
#' replication group as a read replica; otherwise, the cluster is a
#' standalone primary that is not part of any replication group.
#' 
#' If the specified replication group is Multi-AZ enabled and the
#' Availability Zone is not specified, the cluster is created in
#' Availability Zones that provide the best spread of read replicas across
#' Availability Zones.
#' 
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param AZMode Specifies whether the nodes in this Memcached cluster are created in a
#' single Availability Zone or created across multiple Availability Zones
#' in the cluster\'s region.
#' 
#' This parameter is only supported for Memcached clusters.
#' 
#' If the `AZMode` and `PreferredAvailabilityZones` are not specified,
#' ElastiCache assumes `single-az` mode.
#' @param PreferredAvailabilityZone The EC2 Availability Zone in which the cluster is created.
#' 
#' All nodes belonging to this Memcached cluster are placed in the
#' preferred Availability Zone. If you want to create your nodes across
#' multiple Availability Zones, use `PreferredAvailabilityZones`.
#' 
#' Default: System chosen Availability Zone.
#' @param PreferredAvailabilityZones A list of the Availability Zones in which cache nodes are created. The
#' order of the zones in the list is not important.
#' 
#' This option is only supported on Memcached.
#' 
#' If you are creating your cluster in an Amazon VPC (recommended) you can
#' only locate nodes in Availability Zones that are associated with the
#' subnets in the selected subnet group.
#' 
#' The number of Availability Zones listed must equal the value of
#' `NumCacheNodes`.
#' 
#' If you want all the nodes in the same Availability Zone, use
#' `PreferredAvailabilityZone` instead, or repeat the Availability Zone
#' multiple times in the list.
#' 
#' Default: System chosen Availability Zones.
#' @param NumCacheNodes The initial number of cache nodes that the cluster has.
#' 
#' For clusters running Redis, this value must be 1. For clusters running
#' Memcached, this value must be between 1 and 20.
#' 
#' If you need more than 20 nodes for your Memcached cluster, please fill
#' out the ElastiCache Limit Increase Request form at
#' <http://aws.amazon.com/contact-us/elasticache-node-limit-request/>.
#' @param CacheNodeType The compute and memory capacity of the nodes in the node group (shard).
#' 
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#' 
#' -   General purpose:
#' 
#'     -   Current generation:
#' 
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#' 
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#' 
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **T1 node types:** `cache.t1.micro`
#' 
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#' 
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#' 
#' -   Compute optimized:
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **C1 node types:** `cache.c1.xlarge`
#' 
#' -   Memory optimized:
#' 
#'     -   Current generation:
#' 
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#' 
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#' 
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#' 
#' **Additional node type info**
#' 
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#' 
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#' 
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#' 
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Engine The name of the cache engine to be used for this cluster.
#' 
#' Valid values for this parameter are: `memcached` \\| `redis`
#' @param EngineVersion The version number of the cache engine to be used for this cluster. To
#' view the supported cache engine versions, use the
#' DescribeCacheEngineVersions operation.
#' 
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing cluster or
#' replication group and create it anew with the earlier engine version.
#' @param CacheParameterGroupName The name of the parameter group to associate with this cluster. If this
#' argument is omitted, the default parameter group for the specified
#' engine is used. You cannot use any parameter group which has
#' `cluster-enabled='yes'` when creating a cluster.
#' @param CacheSubnetGroupName The name of the subnet group to be used for the cluster.
#' 
#' Use this parameter only when you are creating a cluster in an Amazon
#' Virtual Private Cloud (Amazon VPC).
#' 
#' If you\'re going to launch your cluster in an Amazon VPC, you need to
#' create a subnet group before you start creating a cluster. For more
#' information, see [Subnets and Subnet
#' Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
#' @param CacheSecurityGroupNames A list of security group names to associate with this cluster.
#' 
#' Use this parameter only when you are creating a cluster outside of an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param SecurityGroupIds One or more VPC security groups associated with the cluster.
#' 
#' Use this parameter only when you are creating a cluster in an Amazon
#' Virtual Private Cloud (Amazon VPC).
#' @param Tags A list of cost allocation tags to be added to this resource.
#' @param SnapshotArns A single-element string list containing an Amazon Resource Name (ARN)
#' that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
#' The snapshot file is used to populate the node group (shard). The Amazon
#' S3 object name in the ARN cannot contain any commas.
#' 
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' 
#' Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
#' @param SnapshotName The name of a Redis snapshot from which to restore data into the new
#' node group (shard). The snapshot status changes to `restoring` while the
#' new node group (shard) is being created.
#' 
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period. Valid values for `ddd` are:
#' 
#' Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param Port The port number on which each of the cache nodes accepts connections.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (SNS) topic to which notifications are sent.
#' 
#' The Amazon SNS topic owner must be the same as the cluster owner.
#' @param AutoMinorVersionUpgrade This parameter is currently disabled.
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots
#' before deleting them. For example, if you set `SnapshotRetentionLimit`
#' to 5, a snapshot taken today is retained for 5 days before being
#' deleted.
#' 
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' 
#' Default: 0 (i.e., automatic backups are disabled for this cache
#' cluster).
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your node group (shard).
#' 
#' Example: `05:00-09:00`
#' 
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#' 
#' This parameter is only valid if the `Engine` parameter is `redis`.
#' @param AuthToken **Reserved parameter.** The password used to access a password protected
#' server.
#' 
#' Password constraints:
#' 
#' -   Must be only printable ASCII characters.
#' 
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length.
#' 
#' -   Cannot contain any of the following characters: \'/\', \'\"\', or
#'     \'@\'.
#' 
#' For more information, see AUTH password at
#' http://redis.io/commands/AUTH.
#'
#' @section Request syntax:
#' ```
#' svc$create_cache_cluster(
#'   CacheClusterId = "string",
#'   ReplicationGroupId = "string",
#'   AZMode = "single-az"|"cross-az",
#'   PreferredAvailabilityZone = "string",
#'   PreferredAvailabilityZones = list(
#'     "string"
#'   ),
#'   NumCacheNodes = 123,
#'   CacheNodeType = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   CacheParameterGroupName = "string",
#'   CacheSubnetGroupName = "string",
#'   CacheSecurityGroupNames = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   SnapshotArns = list(
#'     "string"
#'   ),
#'   SnapshotName = "string",
#'   PreferredMaintenanceWindow = "string",
#'   Port = 123,
#'   NotificationTopicArn = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   SnapshotRetentionLimit = 123,
#'   SnapshotWindow = "string",
#'   AuthToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_cluster
elasticache_create_cache_cluster <- function(CacheClusterId, ReplicationGroupId = NULL, AZMode = NULL, PreferredAvailabilityZone = NULL, PreferredAvailabilityZones = NULL, NumCacheNodes = NULL, CacheNodeType = NULL, Engine = NULL, EngineVersion = NULL, CacheParameterGroupName = NULL, CacheSubnetGroupName = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, Tags = NULL, SnapshotArns = NULL, SnapshotName = NULL, PreferredMaintenanceWindow = NULL, Port = NULL, NotificationTopicArn = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, AuthToken = NULL) {
  op <- new_operation(
    name = "CreateCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_cluster_input(CacheClusterId = CacheClusterId, ReplicationGroupId = ReplicationGroupId, AZMode = AZMode, PreferredAvailabilityZone = PreferredAvailabilityZone, PreferredAvailabilityZones = PreferredAvailabilityZones, NumCacheNodes = NumCacheNodes, CacheNodeType = CacheNodeType, Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupName = CacheParameterGroupName, CacheSubnetGroupName = CacheSubnetGroupName, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, Tags = Tags, SnapshotArns = SnapshotArns, SnapshotName = SnapshotName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Port = Port, NotificationTopicArn = NotificationTopicArn, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, AuthToken = AuthToken)
  output <- .elasticache$create_cache_cluster_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_cluster <- elasticache_create_cache_cluster

#' Creates a new Amazon ElastiCache cache parameter group
#'
#' Creates a new Amazon ElastiCache cache parameter group. An ElastiCache
#' cache parameter group is a collection of parameters and their values
#' that are applied to all of the nodes in any cluster or replication group
#' using the CacheParameterGroup.
#' 
#' A newly created CacheParameterGroup is an exact duplicate of the default
#' parameter group for the CacheParameterGroupFamily. To customize the
#' newly created CacheParameterGroup you can change the values of specific
#' parameters. For more information, see:
#' 
#' -   [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html)
#'     in the ElastiCache API Reference.
#' 
#' -   [Parameters and Parameter
#'     Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html)
#'     in the ElastiCache User Guide.
#'
#' @usage
#' elasticache_create_cache_parameter_group(CacheParameterGroupName,
#'   CacheParameterGroupFamily, Description)
#'
#' @param CacheParameterGroupName &#91;required&#93; A user-specified name for the cache parameter group.
#' @param CacheParameterGroupFamily &#91;required&#93; The name of the cache parameter group family that the cache parameter
#' group can be used with.
#' 
#' Valid values are: `memcached1.4` \\| `memcached1.5` \\| `redis2.6` \\|
#' `redis2.8` \\| `redis3.2` \\| `redis4.0` \\| `redis5.0` \\|
#' @param Description &#91;required&#93; A user-specified description for the cache parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$create_cache_parameter_group(
#'   CacheParameterGroupName = "string",
#'   CacheParameterGroupFamily = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_parameter_group
elasticache_create_cache_parameter_group <- function(CacheParameterGroupName, CacheParameterGroupFamily, Description) {
  op <- new_operation(
    name = "CreateCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, CacheParameterGroupFamily = CacheParameterGroupFamily, Description = Description)
  output <- .elasticache$create_cache_parameter_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_parameter_group <- elasticache_create_cache_parameter_group

#' Creates a new cache security group
#'
#' Creates a new cache security group. Use a cache security group to
#' control access to one or more clusters.
#' 
#' Cache security groups are only used when you are creating a cluster
#' outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are
#' creating a cluster inside of a VPC, use a cache subnet group instead.
#' For more information, see
#' [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
#'
#' @usage
#' elasticache_create_cache_security_group(CacheSecurityGroupName,
#'   Description)
#'
#' @param CacheSecurityGroupName &#91;required&#93; A name for the cache security group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters.
#' Cannot be the word \"Default\".
#' 
#' Example: `mysecuritygroup`
#' @param Description &#91;required&#93; A description for the cache security group.
#'
#' @section Request syntax:
#' ```
#' svc$create_cache_security_group(
#'   CacheSecurityGroupName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_security_group
elasticache_create_cache_security_group <- function(CacheSecurityGroupName, Description) {
  op <- new_operation(
    name = "CreateCacheSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_security_group_input(CacheSecurityGroupName = CacheSecurityGroupName, Description = Description)
  output <- .elasticache$create_cache_security_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_security_group <- elasticache_create_cache_security_group

#' Creates a new cache subnet group
#'
#' Creates a new cache subnet group.
#' 
#' Use this parameter only when you are creating a cluster in an Amazon
#' Virtual Private Cloud (Amazon VPC).
#'
#' @usage
#' elasticache_create_cache_subnet_group(CacheSubnetGroupName,
#'   CacheSubnetGroupDescription, SubnetIds)
#'
#' @param CacheSubnetGroupName &#91;required&#93; A name for the cache subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#' 
#' Example: `mysubnetgroup`
#' @param CacheSubnetGroupDescription &#91;required&#93; A description for the cache subnet group.
#' @param SubnetIds &#91;required&#93; A list of VPC subnet IDs for the cache subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$create_cache_subnet_group(
#'   CacheSubnetGroupName = "string",
#'   CacheSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_cache_subnet_group
elasticache_create_cache_subnet_group <- function(CacheSubnetGroupName, CacheSubnetGroupDescription, SubnetIds) {
  op <- new_operation(
    name = "CreateCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName, CacheSubnetGroupDescription = CacheSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .elasticache$create_cache_subnet_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_cache_subnet_group <- elasticache_create_cache_subnet_group

#' Creates a Redis (cluster mode disabled) or a Redis (cluster mode
#' enabled) replication group
#'
#' Creates a Redis (cluster mode disabled) or a Redis (cluster mode
#' enabled) replication group.
#' 
#' A Redis (cluster mode disabled) replication group is a collection of
#' clusters, where one of the clusters is a read/write primary and the
#' others are read-only replicas. Writes to the primary are asynchronously
#' propagated to the replicas.
#' 
#' A Redis (cluster mode enabled) replication group is a collection of 1 to
#' 90 node groups (shards). Each node group (shard) has one read/write
#' primary node and up to 5 read-only replica nodes. Writes to the primary
#' are asynchronously propagated to the replicas. Redis (cluster mode
#' enabled) replication groups partition the data across node groups
#' (shards).
#' 
#' When a Redis (cluster mode disabled) replication group has been
#' successfully created, you can add one or more read replicas to it, up to
#' a total of 5 read replicas. You cannot alter a Redis (cluster mode
#' enabled) replication group after it has been created. However, if you
#' need to increase or decrease the number of node groups (console:
#' shards), you can avail yourself of ElastiCache for Redis\' enhanced
#' backup and restore. For more information, see [Restoring From a Backup
#' with Cluster
#' Resizing](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-restoring.html)
#' in the *ElastiCache User Guide*.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_create_replication_group(ReplicationGroupId,
#'   ReplicationGroupDescription, PrimaryClusterId, AutomaticFailoverEnabled,
#'   NumCacheClusters, PreferredCacheClusterAZs, NumNodeGroups,
#'   ReplicasPerNodeGroup, NodeGroupConfiguration, CacheNodeType, Engine,
#'   EngineVersion, CacheParameterGroupName, CacheSubnetGroupName,
#'   CacheSecurityGroupNames, SecurityGroupIds, Tags, SnapshotArns,
#'   SnapshotName, PreferredMaintenanceWindow, Port, NotificationTopicArn,
#'   AutoMinorVersionUpgrade, SnapshotRetentionLimit, SnapshotWindow,
#'   AuthToken, TransitEncryptionEnabled, AtRestEncryptionEnabled)
#'
#' @param ReplicationGroupId &#91;required&#93; The replication group identifier. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   A name must contain from 1 to 20 alphanumeric characters or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   A name cannot end with a hyphen or contain two consecutive hyphens.
#' @param ReplicationGroupDescription &#91;required&#93; A user-created description for the replication group.
#' @param PrimaryClusterId The identifier of the cluster that serves as the primary for this
#' replication group. This cluster must already exist and have a status of
#' `available`.
#' 
#' This parameter is not required if `NumCacheClusters`, `NumNodeGroups`,
#' or `ReplicasPerNodeGroup` is specified.
#' @param AutomaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to
#' read/write primary if the existing primary fails.
#' 
#' If `true`, Multi-AZ is enabled for this replication group. If `false`,
#' Multi-AZ is disabled for this replication group.
#' 
#' `AutomaticFailoverEnabled` must be enabled for Redis (cluster mode
#' enabled) replication groups.
#' 
#' Default: false
#' 
#' Amazon ElastiCache for Redis does not support Multi-AZ with automatic
#' failover on:
#' 
#' -   Redis versions earlier than 2.8.6.
#' 
#' -   Redis (cluster mode disabled): T1 node types.
#' 
#' -   Redis (cluster mode enabled): T1 node types.
#' @param NumCacheClusters The number of clusters this replication group initially has.
#' 
#' This parameter is not used if there is more than one node group (shard).
#' You should use `ReplicasPerNodeGroup` instead.
#' 
#' If `AutomaticFailoverEnabled` is `true`, the value of this parameter
#' must be at least 2. If `AutomaticFailoverEnabled` is `false` you can
#' omit this parameter (it will default to 1), or you can explicitly set it
#' to a value between 2 and 6.
#' 
#' The maximum permitted value for `NumCacheClusters` is 6 (1 primary plus
#' 5 replicas).
#' @param PreferredCacheClusterAZs A list of EC2 Availability Zones in which the replication group\'s
#' clusters are created. The order of the Availability Zones in the list is
#' the order in which clusters are allocated. The primary cluster is
#' created in the first AZ in the list.
#' 
#' This parameter is not used if there is more than one node group (shard).
#' You should use `NodeGroupConfiguration` instead.
#' 
#' If you are creating your replication group in an Amazon VPC
#' (recommended), you can only locate clusters in Availability Zones
#' associated with the subnets in the selected subnet group.
#' 
#' The number of Availability Zones listed must equal the value of
#' `NumCacheClusters`.
#' 
#' Default: system chosen Availability Zones.
#' @param NumNodeGroups An optional parameter that specifies the number of node groups (shards)
#' for this Redis (cluster mode enabled) replication group. For Redis
#' (cluster mode disabled) either omit this parameter or set it to 1.
#' 
#' Default: 1
#' @param ReplicasPerNodeGroup An optional parameter that specifies the number of replica nodes in each
#' node group (shard). Valid values are 0 to 5.
#' @param NodeGroupConfiguration A list of node group (shard) configuration options. Each node group
#' (shard) configuration has the following members:
#' `PrimaryAvailabilityZone`, `ReplicaAvailabilityZones`, `ReplicaCount`,
#' and `Slots`.
#' 
#' If you\'re creating a Redis (cluster mode disabled) or a Redis (cluster
#' mode enabled) replication group, you can use this parameter to
#' individually configure each node group (shard), or you can omit this
#' parameter. However, when seeding a Redis (cluster mode enabled) cluster
#' from a S3 rdb file, you must configure each node group (shard) using
#' this parameter because you must specify the slots for each node group.
#' @param CacheNodeType The compute and memory capacity of the nodes in the node group (shard).
#' 
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#' 
#' -   General purpose:
#' 
#'     -   Current generation:
#' 
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#' 
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#' 
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **T1 node types:** `cache.t1.micro`
#' 
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#' 
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#' 
#' -   Compute optimized:
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **C1 node types:** `cache.c1.xlarge`
#' 
#' -   Memory optimized:
#' 
#'     -   Current generation:
#' 
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#' 
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#' 
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#' 
#' **Additional node type info**
#' 
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#' 
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#' 
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#' 
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Engine The name of the cache engine to be used for the clusters in this
#' replication group.
#' @param EngineVersion The version number of the cache engine to be used for the clusters in
#' this replication group. To view the supported cache engine versions, use
#' the `DescribeCacheEngineVersions` operation.
#' 
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement))
#' in the *ElastiCache User Guide*, but you cannot downgrade to an earlier
#' engine version. If you want to use an earlier engine version, you must
#' delete the existing cluster or replication group and create it anew with
#' the earlier engine version.
#' @param CacheParameterGroupName The name of the parameter group to associate with this replication
#' group. If this argument is omitted, the default cache parameter group
#' for the specified engine is used.
#' 
#' If you are restoring to an engine version that is different than the
#' original, you must specify the default version of that version. For
#' example, `CacheParameterGroupName=default.redis4.0`.
#' 
#' If you are running Redis version 3.2.4 or later, only one node group
#' (shard), and want to use a default parameter group, we recommend that
#' you specify the parameter group by name.
#' 
#' -   To create a Redis (cluster mode disabled) replication group, use
#'     `CacheParameterGroupName=default.redis3.2`.
#' 
#' -   To create a Redis (cluster mode enabled) replication group, use
#'     `CacheParameterGroupName=default.redis3.2.cluster.on`.
#' @param CacheSubnetGroupName The name of the cache subnet group to be used for the replication group.
#' 
#' If you\'re going to launch your cluster in an Amazon VPC, you need to
#' create a subnet group before you start creating a cluster. For more
#' information, see [Subnets and Subnet
#' Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
#' @param CacheSecurityGroupNames A list of cache security group names to associate with this replication
#' group.
#' @param SecurityGroupIds One or more Amazon VPC security groups associated with this replication
#' group.
#' 
#' Use this parameter only when you are creating a replication group in an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param Tags A list of cost allocation tags to be added to this resource. Tags are
#' comma-separated key,value pairs (e.g. Key=`myKey`, Value=`myKeyValue`.
#' You can include multiple tags as shown following: Key=`myKey`,
#' Value=`myKeyValue` Key=`mySecondKey`, Value=`mySecondKeyValue`.
#' @param SnapshotArns A list of Amazon Resource Names (ARN) that uniquely identify the Redis
#' RDB snapshot files stored in Amazon S3. The snapshot files are used to
#' populate the new replication group. The Amazon S3 object name in the ARN
#' cannot contain any commas. The new replication group will have the
#' number of node groups (console: shards) specified by the parameter
#' *NumNodeGroups* or the number of node groups configured by
#' *NodeGroupConfiguration* regardless of the number of ARNs specified
#' here.
#' 
#' Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
#' @param SnapshotName The name of a snapshot from which to restore data into the new
#' replication group. The snapshot status changes to `restoring` while the
#' new replication group is being created.
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period. Valid values for `ddd` are:
#' 
#' Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param Port The port number on which each member of the replication group accepts
#' connections.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (SNS) topic to which notifications are sent.
#' 
#' The Amazon SNS topic owner must be the same as the cluster owner.
#' @param AutoMinorVersionUpgrade This parameter is currently disabled.
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots
#' before deleting them. For example, if you set `SnapshotRetentionLimit`
#' to 5, a snapshot that was taken today is retained for 5 days before
#' being deleted.
#' 
#' Default: 0 (i.e., automatic backups are disabled for this cluster).
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your node group (shard).
#' 
#' Example: `05:00-09:00`
#' 
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#' @param AuthToken **Reserved parameter.** The password used to access a password protected
#' server.
#' 
#' `AuthToken` can be specified only on replication groups where
#' `TransitEncryptionEnabled` is `true`.
#' 
#' For HIPAA compliance, you must specify `TransitEncryptionEnabled` as
#' `true`, an `AuthToken`, and a `CacheSubnetGroup`.
#' 
#' Password constraints:
#' 
#' -   Must be only printable ASCII characters.
#' 
#' -   Must be at least 16 characters and no more than 128 characters in
#'     length.
#' 
#' -   Cannot contain any of the following characters: \'/\', \'\"\', or
#'     \'@\'.
#' 
#' For more information, see AUTH password at
#' http://redis.io/commands/AUTH.
#' @param TransitEncryptionEnabled A flag that enables in-transit encryption when set to `true`.
#' 
#' You cannot modify the value of `TransitEncryptionEnabled` after the
#' cluster is created. To enable in-transit encryption on a cluster you
#' must set `TransitEncryptionEnabled` to `true` when you create a cluster.
#' 
#' This parameter is valid only if the `Engine` parameter is `redis`, the
#' `EngineVersion` parameter is `3.2.6` or `4.x`, and the cluster is being
#' created in an Amazon VPC.
#' 
#' If you enable in-transit encryption, you must also specify a value for
#' `CacheSubnetGroup`.
#' 
#' **Required:** Only available when creating a replication group in an
#' Amazon VPC using redis version `3.2.6`, `4.x` or later.
#' 
#' Default: `false`
#' 
#' For HIPAA compliance, you must specify `TransitEncryptionEnabled` as
#' `true`, an `AuthToken`, and a `CacheSubnetGroup`.
#' @param AtRestEncryptionEnabled A flag that enables encryption at rest when set to `true`.
#' 
#' You cannot modify the value of `AtRestEncryptionEnabled` after the
#' replication group is created. To enable encryption at rest on a
#' replication group you must set `AtRestEncryptionEnabled` to `true` when
#' you create the replication group.
#' 
#' **Required:** Only available when creating a replication group in an
#' Amazon VPC using redis version `3.2.6`, `4.x` or later.
#' 
#' Default: `false`
#'
#' @section Request syntax:
#' ```
#' svc$create_replication_group(
#'   ReplicationGroupId = "string",
#'   ReplicationGroupDescription = "string",
#'   PrimaryClusterId = "string",
#'   AutomaticFailoverEnabled = TRUE|FALSE,
#'   NumCacheClusters = 123,
#'   PreferredCacheClusterAZs = list(
#'     "string"
#'   ),
#'   NumNodeGroups = 123,
#'   ReplicasPerNodeGroup = 123,
#'   NodeGroupConfiguration = list(
#'     list(
#'       NodeGroupId = "string",
#'       Slots = "string",
#'       ReplicaCount = 123,
#'       PrimaryAvailabilityZone = "string",
#'       ReplicaAvailabilityZones = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   CacheNodeType = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   CacheParameterGroupName = "string",
#'   CacheSubnetGroupName = "string",
#'   CacheSecurityGroupNames = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   SnapshotArns = list(
#'     "string"
#'   ),
#'   SnapshotName = "string",
#'   PreferredMaintenanceWindow = "string",
#'   Port = 123,
#'   NotificationTopicArn = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   SnapshotRetentionLimit = 123,
#'   SnapshotWindow = "string",
#'   AuthToken = "string",
#'   TransitEncryptionEnabled = TRUE|FALSE,
#'   AtRestEncryptionEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_replication_group
elasticache_create_replication_group <- function(ReplicationGroupId, ReplicationGroupDescription, PrimaryClusterId = NULL, AutomaticFailoverEnabled = NULL, NumCacheClusters = NULL, PreferredCacheClusterAZs = NULL, NumNodeGroups = NULL, ReplicasPerNodeGroup = NULL, NodeGroupConfiguration = NULL, CacheNodeType = NULL, Engine = NULL, EngineVersion = NULL, CacheParameterGroupName = NULL, CacheSubnetGroupName = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, Tags = NULL, SnapshotArns = NULL, SnapshotName = NULL, PreferredMaintenanceWindow = NULL, Port = NULL, NotificationTopicArn = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, AuthToken = NULL, TransitEncryptionEnabled = NULL, AtRestEncryptionEnabled = NULL) {
  op <- new_operation(
    name = "CreateReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_replication_group_input(ReplicationGroupId = ReplicationGroupId, ReplicationGroupDescription = ReplicationGroupDescription, PrimaryClusterId = PrimaryClusterId, AutomaticFailoverEnabled = AutomaticFailoverEnabled, NumCacheClusters = NumCacheClusters, PreferredCacheClusterAZs = PreferredCacheClusterAZs, NumNodeGroups = NumNodeGroups, ReplicasPerNodeGroup = ReplicasPerNodeGroup, NodeGroupConfiguration = NodeGroupConfiguration, CacheNodeType = CacheNodeType, Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupName = CacheParameterGroupName, CacheSubnetGroupName = CacheSubnetGroupName, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, Tags = Tags, SnapshotArns = SnapshotArns, SnapshotName = SnapshotName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Port = Port, NotificationTopicArn = NotificationTopicArn, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, AuthToken = AuthToken, TransitEncryptionEnabled = TransitEncryptionEnabled, AtRestEncryptionEnabled = AtRestEncryptionEnabled)
  output <- .elasticache$create_replication_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_replication_group <- elasticache_create_replication_group

#' Creates a copy of an entire cluster or replication group at a specific
#' moment in time
#'
#' Creates a copy of an entire cluster or replication group at a specific
#' moment in time.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_create_snapshot(ReplicationGroupId, CacheClusterId,
#'   SnapshotName)
#'
#' @param ReplicationGroupId The identifier of an existing replication group. The snapshot is created
#' from this replication group.
#' @param CacheClusterId The identifier of an existing cluster. The snapshot is created from this
#' cluster.
#' @param SnapshotName &#91;required&#93; A name for the snapshot being created.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot(
#'   ReplicationGroupId = "string",
#'   CacheClusterId = "string",
#'   SnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_create_snapshot
elasticache_create_snapshot <- function(ReplicationGroupId = NULL, CacheClusterId = NULL, SnapshotName) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$create_snapshot_input(ReplicationGroupId = ReplicationGroupId, CacheClusterId = CacheClusterId, SnapshotName = SnapshotName)
  output <- .elasticache$create_snapshot_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$create_snapshot <- elasticache_create_snapshot

#' Dynamically decreases the number of replics in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group
#'
#' Dynamically decreases the number of replics in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group. This operation is performed with no cluster down time.
#'
#' @usage
#' elasticache_decrease_replica_count(ReplicationGroupId, NewReplicaCount,
#'   ReplicaConfiguration, ReplicasToRemove, ApplyImmediately)
#'
#' @param ReplicationGroupId &#91;required&#93; The id of the replication group from which you want to remove replica
#' nodes.
#' @param NewReplicaCount The number of read replica nodes you want at the completion of this
#' operation. For Redis (cluster mode disabled) replication groups, this is
#' the number of replica nodes in the replication group. For Redis (cluster
#' mode enabled) replication groups, this is the number of replica nodes in
#' each of the replication group\'s node groups.
#' 
#' The minimum number of replicas in a shard or replication group is:
#' 
#' -   Redis (cluster mode disabled)
#' 
#'     -   If Multi-AZ with Automatic Failover is enabled: 1
#' 
#'     -   If Multi-AZ with Automatic Failover is not enabled: 0
#' 
#' -   Redis (cluster mode enabled): 0 (though you will not be able to
#'     failover to a replica if your primary node fails)
#' @param ReplicaConfiguration A list of `ConfigureShard` objects that can be used to configure each
#' shard in a Redis (cluster mode enabled) replication group. The
#' `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`,
#' and `PreferredAvailabilityZones`.
#' @param ReplicasToRemove A list of the node ids to remove from the replication group or node
#' group (shard).
#' @param ApplyImmediately &#91;required&#93; If `True`, the number of replica nodes is decreased immediately.
#' `ApplyImmediately=False` is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$decrease_replica_count(
#'   ReplicationGroupId = "string",
#'   NewReplicaCount = 123,
#'   ReplicaConfiguration = list(
#'     list(
#'       NodeGroupId = "string",
#'       NewReplicaCount = 123,
#'       PreferredAvailabilityZones = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReplicasToRemove = list(
#'     "string"
#'   ),
#'   ApplyImmediately = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_decrease_replica_count
elasticache_decrease_replica_count <- function(ReplicationGroupId, NewReplicaCount = NULL, ReplicaConfiguration = NULL, ReplicasToRemove = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "DecreaseReplicaCount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$decrease_replica_count_input(ReplicationGroupId = ReplicationGroupId, NewReplicaCount = NewReplicaCount, ReplicaConfiguration = ReplicaConfiguration, ReplicasToRemove = ReplicasToRemove, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$decrease_replica_count_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$decrease_replica_count <- elasticache_decrease_replica_count

#' Deletes a previously provisioned cluster
#'
#' Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes
#' all associated cache nodes, node endpoints and the cluster itself. When
#' you receive a successful response from this operation, Amazon
#' ElastiCache immediately begins deleting the cluster; you cannot cancel
#' or revert this operation.
#' 
#' This operation is not valid for:
#' 
#' -   Redis (cluster mode enabled) clusters
#' 
#' -   A cluster that is the last read replica of a replication group
#' 
#' -   A node group (shard) that has Multi-AZ mode enabled
#' 
#' -   A cluster from a Redis (cluster mode enabled) replication group
#' 
#' -   A cluster that is not in the `available` state
#'
#' @usage
#' elasticache_delete_cache_cluster(CacheClusterId,
#'   FinalSnapshotIdentifier)
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier for the cluster to be deleted. This parameter is
#' not case sensitive.
#' @param FinalSnapshotIdentifier The user-supplied name of a final cluster snapshot. This is the unique
#' name that identifies the snapshot. ElastiCache creates the snapshot, and
#' then deletes the cluster immediately afterward.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cache_cluster(
#'   CacheClusterId = "string",
#'   FinalSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_cluster
elasticache_delete_cache_cluster <- function(CacheClusterId, FinalSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_cluster_input(CacheClusterId = CacheClusterId, FinalSnapshotIdentifier = FinalSnapshotIdentifier)
  output <- .elasticache$delete_cache_cluster_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_cluster <- elasticache_delete_cache_cluster

#' Deletes the specified cache parameter group
#'
#' Deletes the specified cache parameter group. You cannot delete a cache
#' parameter group if it is associated with any cache clusters.
#'
#' @usage
#' elasticache_delete_cache_parameter_group(CacheParameterGroupName)
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to delete.
#' 
#' The specified cache security group must not be associated with any
#' clusters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cache_parameter_group(
#'   CacheParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_parameter_group
elasticache_delete_cache_parameter_group <- function(CacheParameterGroupName) {
  op <- new_operation(
    name = "DeleteCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName)
  output <- .elasticache$delete_cache_parameter_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_parameter_group <- elasticache_delete_cache_parameter_group

#' Deletes a cache security group
#'
#' Deletes a cache security group.
#' 
#' You cannot delete a cache security group if it is associated with any
#' clusters.
#'
#' @usage
#' elasticache_delete_cache_security_group(CacheSecurityGroupName)
#'
#' @param CacheSecurityGroupName &#91;required&#93; The name of the cache security group to delete.
#' 
#' You cannot delete the default security group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cache_security_group(
#'   CacheSecurityGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_security_group
elasticache_delete_cache_security_group <- function(CacheSecurityGroupName) {
  op <- new_operation(
    name = "DeleteCacheSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_security_group_input(CacheSecurityGroupName = CacheSecurityGroupName)
  output <- .elasticache$delete_cache_security_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_security_group <- elasticache_delete_cache_security_group

#' Deletes a cache subnet group
#'
#' Deletes a cache subnet group.
#' 
#' You cannot delete a cache subnet group if it is associated with any
#' clusters.
#'
#' @usage
#' elasticache_delete_cache_subnet_group(CacheSubnetGroupName)
#'
#' @param CacheSubnetGroupName &#91;required&#93; The name of the cache subnet group to delete.
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cache_subnet_group(
#'   CacheSubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_cache_subnet_group
elasticache_delete_cache_subnet_group <- function(CacheSubnetGroupName) {
  op <- new_operation(
    name = "DeleteCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName)
  output <- .elasticache$delete_cache_subnet_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_cache_subnet_group <- elasticache_delete_cache_subnet_group

#' Deletes an existing replication group
#'
#' Deletes an existing replication group. By default, this operation
#' deletes the entire replication group, including the primary/primaries
#' and all of the read replicas. If the replication group has only one
#' primary, you can optionally delete only the read replicas, while
#' retaining the primary by setting `RetainPrimaryCluster=true`.
#' 
#' When you receive a successful response from this operation, Amazon
#' ElastiCache immediately begins deleting the selected resources; you
#' cannot cancel or revert this operation.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_delete_replication_group(ReplicationGroupId,
#'   RetainPrimaryCluster, FinalSnapshotIdentifier)
#'
#' @param ReplicationGroupId &#91;required&#93; The identifier for the cluster to be deleted. This parameter is not case
#' sensitive.
#' @param RetainPrimaryCluster If set to `true`, all of the read replicas are deleted, but the primary
#' node is retained.
#' @param FinalSnapshotIdentifier The name of a final node group (shard) snapshot. ElastiCache creates the
#' snapshot from the primary node in the cluster, rather than one of the
#' replicas; this is to ensure that it captures the freshest data. After
#' the final snapshot is taken, the replication group is immediately
#' deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_replication_group(
#'   ReplicationGroupId = "string",
#'   RetainPrimaryCluster = TRUE|FALSE,
#'   FinalSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_replication_group
elasticache_delete_replication_group <- function(ReplicationGroupId, RetainPrimaryCluster = NULL, FinalSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_replication_group_input(ReplicationGroupId = ReplicationGroupId, RetainPrimaryCluster = RetainPrimaryCluster, FinalSnapshotIdentifier = FinalSnapshotIdentifier)
  output <- .elasticache$delete_replication_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_replication_group <- elasticache_delete_replication_group

#' Deletes an existing snapshot
#'
#' Deletes an existing snapshot. When you receive a successful response
#' from this operation, ElastiCache immediately begins deleting the
#' snapshot; you cannot cancel or revert this operation.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_delete_snapshot(SnapshotName)
#'
#' @param SnapshotName &#91;required&#93; The name of the snapshot to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot(
#'   SnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_delete_snapshot
elasticache_delete_snapshot <- function(SnapshotName) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$delete_snapshot_input(SnapshotName = SnapshotName)
  output <- .elasticache$delete_snapshot_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$delete_snapshot <- elasticache_delete_snapshot

#' Returns information about all provisioned clusters if no cluster
#' identifier is specified, or about a specific cache cluster if a cluster
#' identifier is supplied
#'
#' Returns information about all provisioned clusters if no cluster
#' identifier is specified, or about a specific cache cluster if a cluster
#' identifier is supplied.
#' 
#' By default, abbreviated information about the clusters is returned. You
#' can use the optional *ShowCacheNodeInfo* flag to retrieve detailed
#' information about the cache nodes associated with the clusters. These
#' details include the DNS address and port for the cache node endpoint.
#' 
#' If the cluster is in the *creating* state, only cluster-level
#' information is displayed until all of the nodes are successfully
#' provisioned.
#' 
#' If the cluster is in the *deleting* state, only cluster-level
#' information is displayed.
#' 
#' If cache nodes are currently being added to the cluster, node endpoint
#' information and creation time for the additional nodes are not displayed
#' until they are completely provisioned. When the cluster state is
#' *available*, the cluster is ready for use.
#' 
#' If cache nodes are currently being removed from the cluster, no endpoint
#' information for the removed nodes is displayed.
#'
#' @usage
#' elasticache_describe_cache_clusters(CacheClusterId, MaxRecords, Marker,
#'   ShowCacheNodeInfo, ShowCacheClustersNotInReplicationGroups)
#'
#' @param CacheClusterId The user-supplied cluster identifier. If this parameter is specified,
#' only information about that specific cluster is returned. This parameter
#' isn\'t case sensitive.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param ShowCacheNodeInfo An optional flag that can be included in the `DescribeCacheCluster`
#' request to retrieve information about the individual cache nodes.
#' @param ShowCacheClustersNotInReplicationGroups An optional flag that can be included in the `DescribeCacheCluster`
#' request to show only nodes (API/CLI: clusters) that are not members of a
#' replication group. In practice, this mean Memcached and single node
#' Redis clusters.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_clusters(
#'   CacheClusterId = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   ShowCacheNodeInfo = TRUE|FALSE,
#'   ShowCacheClustersNotInReplicationGroups = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_clusters
elasticache_describe_cache_clusters <- function(CacheClusterId = NULL, MaxRecords = NULL, Marker = NULL, ShowCacheNodeInfo = NULL, ShowCacheClustersNotInReplicationGroups = NULL) {
  op <- new_operation(
    name = "DescribeCacheClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_clusters_input(CacheClusterId = CacheClusterId, MaxRecords = MaxRecords, Marker = Marker, ShowCacheNodeInfo = ShowCacheNodeInfo, ShowCacheClustersNotInReplicationGroups = ShowCacheClustersNotInReplicationGroups)
  output <- .elasticache$describe_cache_clusters_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_clusters <- elasticache_describe_cache_clusters

#' Returns a list of the available cache engines and their versions
#'
#' Returns a list of the available cache engines and their versions.
#'
#' @usage
#' elasticache_describe_cache_engine_versions(Engine, EngineVersion,
#'   CacheParameterGroupFamily, MaxRecords, Marker, DefaultOnly)
#'
#' @param Engine The cache engine to return. Valid values: `memcached` \\| `redis`
#' @param EngineVersion The cache engine version to return.
#' 
#' Example: `1.4.14`
#' @param CacheParameterGroupFamily The name of a specific cache parameter group family to return details
#' for.
#' 
#' Valid values are: `memcached1.4` \\| `memcached1.5` \\| `redis2.6` \\|
#' `redis2.8` \\| `redis3.2` \\| `redis4.0` \\| `redis5.0` \\|
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param DefaultOnly If `true`, specifies that only the default version of the specified
#' engine or engine and major version combination is to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_engine_versions(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   CacheParameterGroupFamily = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   DefaultOnly = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_engine_versions
elasticache_describe_cache_engine_versions <- function(Engine = NULL, EngineVersion = NULL, CacheParameterGroupFamily = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL) {
  op <- new_operation(
    name = "DescribeCacheEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, CacheParameterGroupFamily = CacheParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly)
  output <- .elasticache$describe_cache_engine_versions_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_engine_versions <- elasticache_describe_cache_engine_versions

#' Returns a list of cache parameter group descriptions
#'
#' Returns a list of cache parameter group descriptions. If a cache
#' parameter group name is specified, the list contains only the
#' descriptions for that group.
#'
#' @usage
#' elasticache_describe_cache_parameter_groups(CacheParameterGroupName,
#'   MaxRecords, Marker)
#'
#' @param CacheParameterGroupName The name of a specific cache parameter group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_parameter_groups(
#'   CacheParameterGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_parameter_groups
elasticache_describe_cache_parameter_groups <- function(CacheParameterGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_parameter_groups_input(CacheParameterGroupName = CacheParameterGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_parameter_groups_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_parameter_groups <- elasticache_describe_cache_parameter_groups

#' Returns the detailed parameter list for a particular cache parameter
#' group
#'
#' Returns the detailed parameter list for a particular cache parameter
#' group.
#'
#' @usage
#' elasticache_describe_cache_parameters(CacheParameterGroupName, Source,
#'   MaxRecords, Marker)
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of a specific cache parameter group to return details for.
#' @param Source The parameter types to return.
#' 
#' Valid values: `user` \\| `system` \\| `engine-default`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_parameters(
#'   CacheParameterGroupName = "string",
#'   Source = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_parameters
elasticache_describe_cache_parameters <- function(CacheParameterGroupName, Source = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_parameters_input(CacheParameterGroupName = CacheParameterGroupName, Source = Source, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_parameters_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_parameters <- elasticache_describe_cache_parameters

#' Returns a list of cache security group descriptions
#'
#' Returns a list of cache security group descriptions. If a cache security
#' group name is specified, the list contains only the description of that
#' group. This applicable only when you have ElastiCache in Classic setup
#'
#' @usage
#' elasticache_describe_cache_security_groups(CacheSecurityGroupName,
#'   MaxRecords, Marker)
#'
#' @param CacheSecurityGroupName The name of the cache security group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_security_groups(
#'   CacheSecurityGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_security_groups
elasticache_describe_cache_security_groups <- function(CacheSecurityGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_security_groups_input(CacheSecurityGroupName = CacheSecurityGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_security_groups_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_security_groups <- elasticache_describe_cache_security_groups

#' Returns a list of cache subnet group descriptions
#'
#' Returns a list of cache subnet group descriptions. If a subnet group
#' name is specified, the list contains only the description of that group.
#' This is applicable only when you have ElastiCache in VPC setup. All
#' ElastiCache clusters now launch in VPC by default.
#'
#' @usage
#' elasticache_describe_cache_subnet_groups(CacheSubnetGroupName,
#'   MaxRecords, Marker)
#'
#' @param CacheSubnetGroupName The name of the cache subnet group to return details for.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache_subnet_groups(
#'   CacheSubnetGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_cache_subnet_groups
elasticache_describe_cache_subnet_groups <- function(CacheSubnetGroupName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCacheSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_cache_subnet_groups_input(CacheSubnetGroupName = CacheSubnetGroupName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_cache_subnet_groups_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_cache_subnet_groups <- elasticache_describe_cache_subnet_groups

#' Returns the default engine and system parameter information for the
#' specified cache engine
#'
#' Returns the default engine and system parameter information for the
#' specified cache engine.
#'
#' @usage
#' elasticache_describe_engine_default_parameters(
#'   CacheParameterGroupFamily, MaxRecords, Marker)
#'
#' @param CacheParameterGroupFamily &#91;required&#93; The name of the cache parameter group family.
#' 
#' Valid values are: `memcached1.4` \\| `memcached1.5` \\| `redis2.6` \\|
#' `redis2.8` \\| `redis3.2` \\| `redis4.0` \\| `redis5.0` \\|
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_parameters(
#'   CacheParameterGroupFamily = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_engine_default_parameters
elasticache_describe_engine_default_parameters <- function(CacheParameterGroupFamily, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_engine_default_parameters_input(CacheParameterGroupFamily = CacheParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_engine_default_parameters_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_engine_default_parameters <- elasticache_describe_engine_default_parameters

#' Returns events related to clusters, cache security groups, and cache
#' parameter groups
#'
#' Returns events related to clusters, cache security groups, and cache
#' parameter groups. You can obtain events specific to a particular
#' cluster, cache security group, or cache parameter group by providing the
#' name as a parameter.
#' 
#' By default, only the events occurring within the last hour are returned;
#' however, you can retrieve up to 14 days\' worth of events if necessary.
#'
#' @usage
#' elasticache_describe_events(SourceIdentifier, SourceType, StartTime,
#'   EndTime, Duration, MaxRecords, Marker)
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, all sources are included in the response.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format.
#' 
#' **Example:** 2017-03-30T07:03:49.555Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format.
#' 
#' **Example:** 2017-03-30T07:03:49.555Z
#' @param Duration The number of minutes worth of events to retrieve.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceIdentifier = "string",
#'   SourceType = "cache-cluster"|"cache-parameter-group"|"cache-security-group"|"cache-subnet-group"|"replication-group",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_events
elasticache_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_events_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_events <- elasticache_describe_events

#' Returns information about a particular replication group
#'
#' Returns information about a particular replication group. If no
#' identifier is specified, `DescribeReplicationGroups` returns information
#' about all replication groups.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_describe_replication_groups(ReplicationGroupId, MaxRecords,
#'   Marker)
#'
#' @param ReplicationGroupId The identifier for the replication group to be described. This parameter
#' is not case sensitive.
#' 
#' If you do not specify this parameter, information about all replication
#' groups is returned.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_replication_groups(
#'   ReplicationGroupId = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_replication_groups
elasticache_describe_replication_groups <- function(ReplicationGroupId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReplicationGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_replication_groups_input(ReplicationGroupId = ReplicationGroupId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_replication_groups_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_replication_groups <- elasticache_describe_replication_groups

#' Returns information about reserved cache nodes for this account, or
#' about a specified reserved cache node
#'
#' Returns information about reserved cache nodes for this account, or
#' about a specified reserved cache node.
#'
#' @usage
#' elasticache_describe_reserved_cache_nodes(ReservedCacheNodeId,
#'   ReservedCacheNodesOfferingId, CacheNodeType, Duration,
#'   ProductDescription, OfferingType, MaxRecords, Marker)
#'
#' @param ReservedCacheNodeId The reserved cache node identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reservation ID.
#' @param ReservedCacheNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' purchased reservations matching the specified offering identifier.
#' @param CacheNodeType The cache node type filter value. Use this parameter to show only those
#' reservations matching the specified cache node type.
#' 
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#' 
#' -   General purpose:
#' 
#'     -   Current generation:
#' 
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#' 
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#' 
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **T1 node types:** `cache.t1.micro`
#' 
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#' 
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#' 
#' -   Compute optimized:
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **C1 node types:** `cache.c1.xlarge`
#' 
#' -   Memory optimized:
#' 
#'     -   Current generation:
#' 
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#' 
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#' 
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#' 
#' **Additional node type info**
#' 
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#' 
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#' 
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#' 
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Duration The duration filter value, specified in years or seconds. Use this
#' parameter to show only reservations for this duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Use this parameter to show only
#' those reservations matching the specified product description.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid values:
#' `"Light Utilization"|"Medium Utilization"|"Heavy Utilization"`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_cache_nodes(
#'   ReservedCacheNodeId = "string",
#'   ReservedCacheNodesOfferingId = "string",
#'   CacheNodeType = "string",
#'   Duration = "string",
#'   ProductDescription = "string",
#'   OfferingType = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_reserved_cache_nodes
elasticache_describe_reserved_cache_nodes <- function(ReservedCacheNodeId = NULL, ReservedCacheNodesOfferingId = NULL, CacheNodeType = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedCacheNodes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_reserved_cache_nodes_input(ReservedCacheNodeId = ReservedCacheNodeId, ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, CacheNodeType = CacheNodeType, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_reserved_cache_nodes_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_reserved_cache_nodes <- elasticache_describe_reserved_cache_nodes

#' Lists available reserved cache node offerings
#'
#' Lists available reserved cache node offerings.
#'
#' @usage
#' elasticache_describe_reserved_cache_nodes_offerings(
#'   ReservedCacheNodesOfferingId, CacheNodeType, Duration,
#'   ProductDescription, OfferingType, MaxRecords, Marker)
#'
#' @param ReservedCacheNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#' 
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param CacheNodeType The cache node type filter value. Use this parameter to show only the
#' available offerings matching the specified cache node type.
#' 
#' The following node types are supported by ElastiCache. Generally
#' speaking, the current generation types provide more memory and
#' computational power at lower cost when compared to their equivalent
#' previous generation counterparts.
#' 
#' -   General purpose:
#' 
#'     -   Current generation:
#' 
#'         **M5 node types:** `cache.m5.large`, `cache.m5.xlarge`,
#'         `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`,
#'         `cache.m5.24xlarge`
#' 
#'         **M4 node types:** `cache.m4.large`, `cache.m4.xlarge`,
#'         `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`
#' 
#'         **T2 node types:** `cache.t2.micro`, `cache.t2.small`,
#'         `cache.t2.medium`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **T1 node types:** `cache.t1.micro`
#' 
#'         **M1 node types:** `cache.m1.small`, `cache.m1.medium`,
#'         `cache.m1.large`, `cache.m1.xlarge`
#' 
#'         **M3 node types:** `cache.m3.medium`, `cache.m3.large`,
#'         `cache.m3.xlarge`, `cache.m3.2xlarge`
#' 
#' -   Compute optimized:
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **C1 node types:** `cache.c1.xlarge`
#' 
#' -   Memory optimized:
#' 
#'     -   Current generation:
#' 
#'         **R5 node types:** `cache.r5.large`, `cache.r5.xlarge`,
#'         `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`,
#'         `cache.r5.24xlarge`
#' 
#'         **R4 node types:** `cache.r4.large`, `cache.r4.xlarge`,
#'         `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`,
#'         `cache.r4.16xlarge`
#' 
#'     -   Previous generation: (not recommended)
#' 
#'         **M2 node types:** `cache.m2.xlarge`, `cache.m2.2xlarge`,
#'         `cache.m2.4xlarge`
#' 
#'         **R3 node types:** `cache.r3.large`, `cache.r3.xlarge`,
#'         `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
#' 
#' **Additional node type info**
#' 
#' -   All current generation instance types are created in Amazon VPC by
#'     default.
#' 
#' -   Redis append-only files (AOF) are not supported for T1 or T2
#'     instances.
#' 
#' -   Redis Multi-AZ with automatic failover is not supported on T1
#'     instances.
#' 
#' -   Redis configuration variables `appendonly` and `appendfsync` are not
#'     supported on Redis version 2.8.22 and later.
#' @param Duration Duration filter value, specified in years or seconds. Use this parameter
#' to show only reservations for a given duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Use this parameter to show only
#' the available offerings matching the specified product description.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid Values:
#' `"Light Utilization"|"Medium Utilization"|"Heavy Utilization"`
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20; maximum 100.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_cache_nodes_offerings(
#'   ReservedCacheNodesOfferingId = "string",
#'   CacheNodeType = "string",
#'   Duration = "string",
#'   ProductDescription = "string",
#'   OfferingType = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_reserved_cache_nodes_offerings
elasticache_describe_reserved_cache_nodes_offerings <- function(ReservedCacheNodesOfferingId = NULL, CacheNodeType = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedCacheNodesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_reserved_cache_nodes_offerings_input(ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, CacheNodeType = CacheNodeType, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_reserved_cache_nodes_offerings_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_reserved_cache_nodes_offerings <- elasticache_describe_reserved_cache_nodes_offerings

#' Returns details of the service updates
#'
#' Returns details of the service updates
#'
#' @usage
#' elasticache_describe_service_updates(ServiceUpdateName,
#'   ServiceUpdateStatus, MaxRecords, Marker)
#'
#' @param ServiceUpdateName The unique ID of the service update
#' @param ServiceUpdateStatus The status of the service update
#' @param MaxRecords The maximum number of records to include in the response
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_service_updates(
#'   ServiceUpdateName = "string",
#'   ServiceUpdateStatus = list(
#'     "available"|"cancelled"|"expired"
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_service_updates
elasticache_describe_service_updates <- function(ServiceUpdateName = NULL, ServiceUpdateStatus = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeServiceUpdates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_service_updates_input(ServiceUpdateName = ServiceUpdateName, ServiceUpdateStatus = ServiceUpdateStatus, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_service_updates_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_service_updates <- elasticache_describe_service_updates

#' Returns information about cluster or replication group snapshots
#'
#' Returns information about cluster or replication group snapshots. By
#' default, `DescribeSnapshots` lists all of your snapshots; it can
#' optionally describe a single snapshot, or just the snapshots associated
#' with a particular cache cluster.
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_describe_snapshots(ReplicationGroupId, CacheClusterId,
#'   SnapshotName, SnapshotSource, Marker, MaxRecords, ShowNodeGroupConfig)
#'
#' @param ReplicationGroupId A user-supplied replication group identifier. If this parameter is
#' specified, only snapshots associated with that specific replication
#' group are described.
#' @param CacheClusterId A user-supplied cluster identifier. If this parameter is specified, only
#' snapshots associated with that specific cluster are described.
#' @param SnapshotName A user-supplied name of the snapshot. If this parameter is specified,
#' only this snapshot are described.
#' @param SnapshotSource If set to `system`, the output shows snapshots that were automatically
#' created by ElastiCache. If set to `user` the output shows snapshots that
#' were manually created. If omitted, the output shows both automatically
#' and manually created snapshots.
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a marker is
#' included in the response so that the remaining results can be retrieved.
#' 
#' Default: 50
#' 
#' Constraints: minimum 20; maximum 50.
#' @param ShowNodeGroupConfig A Boolean value which if true, the node group (shard) configuration is
#' included in the snapshot description.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshots(
#'   ReplicationGroupId = "string",
#'   CacheClusterId = "string",
#'   SnapshotName = "string",
#'   SnapshotSource = "string",
#'   Marker = "string",
#'   MaxRecords = 123,
#'   ShowNodeGroupConfig = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_snapshots
elasticache_describe_snapshots <- function(ReplicationGroupId = NULL, CacheClusterId = NULL, SnapshotName = NULL, SnapshotSource = NULL, Marker = NULL, MaxRecords = NULL, ShowNodeGroupConfig = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_snapshots_input(ReplicationGroupId = ReplicationGroupId, CacheClusterId = CacheClusterId, SnapshotName = SnapshotName, SnapshotSource = SnapshotSource, Marker = Marker, MaxRecords = MaxRecords, ShowNodeGroupConfig = ShowNodeGroupConfig)
  output <- .elasticache$describe_snapshots_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_snapshots <- elasticache_describe_snapshots

#' Returns details of the update actions
#'
#' Returns details of the update actions
#'
#' @usage
#' elasticache_describe_update_actions(ServiceUpdateName,
#'   ReplicationGroupIds, ServiceUpdateStatus, ServiceUpdateTimeRange,
#'   UpdateActionStatus, ShowNodeLevelUpdateStatus, MaxRecords, Marker)
#'
#' @param ServiceUpdateName The unique ID of the service update
#' @param ReplicationGroupIds The replication group IDs
#' @param ServiceUpdateStatus The status of the service update
#' @param ServiceUpdateTimeRange The range of time specified to search for service updates that are in
#' available status
#' @param UpdateActionStatus The status of the update action.
#' @param ShowNodeLevelUpdateStatus Dictates whether to include node level update status in the response
#' @param MaxRecords The maximum number of records to include in the response
#' @param Marker An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_update_actions(
#'   ServiceUpdateName = "string",
#'   ReplicationGroupIds = list(
#'     "string"
#'   ),
#'   ServiceUpdateStatus = list(
#'     "available"|"cancelled"|"expired"
#'   ),
#'   ServiceUpdateTimeRange = list(
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EndTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   UpdateActionStatus = list(
#'     "not-applied"|"waiting-to-start"|"in-progress"|"stopping"|"stopped"|"complete"
#'   ),
#'   ShowNodeLevelUpdateStatus = TRUE|FALSE,
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_describe_update_actions
elasticache_describe_update_actions <- function(ServiceUpdateName = NULL, ReplicationGroupIds = NULL, ServiceUpdateStatus = NULL, ServiceUpdateTimeRange = NULL, UpdateActionStatus = NULL, ShowNodeLevelUpdateStatus = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeUpdateActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$describe_update_actions_input(ServiceUpdateName = ServiceUpdateName, ReplicationGroupIds = ReplicationGroupIds, ServiceUpdateStatus = ServiceUpdateStatus, ServiceUpdateTimeRange = ServiceUpdateTimeRange, UpdateActionStatus = UpdateActionStatus, ShowNodeLevelUpdateStatus = ShowNodeLevelUpdateStatus, MaxRecords = MaxRecords, Marker = Marker)
  output <- .elasticache$describe_update_actions_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$describe_update_actions <- elasticache_describe_update_actions

#' Dynamically increases the number of replics in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group
#'
#' Dynamically increases the number of replics in a Redis (cluster mode
#' disabled) replication group or the number of replica nodes in one or
#' more node groups (shards) of a Redis (cluster mode enabled) replication
#' group. This operation is performed with no cluster down time.
#'
#' @usage
#' elasticache_increase_replica_count(ReplicationGroupId, NewReplicaCount,
#'   ReplicaConfiguration, ApplyImmediately)
#'
#' @param ReplicationGroupId &#91;required&#93; The id of the replication group to which you want to add replica nodes.
#' @param NewReplicaCount The number of read replica nodes you want at the completion of this
#' operation. For Redis (cluster mode disabled) replication groups, this is
#' the number of replica nodes in the replication group. For Redis (cluster
#' mode enabled) replication groups, this is the number of replica nodes in
#' each of the replication group\'s node groups.
#' @param ReplicaConfiguration A list of `ConfigureShard` objects that can be used to configure each
#' shard in a Redis (cluster mode enabled) replication group. The
#' `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`,
#' and `PreferredAvailabilityZones`.
#' @param ApplyImmediately &#91;required&#93; If `True`, the number of replica nodes is increased immediately.
#' `ApplyImmediately=False` is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$increase_replica_count(
#'   ReplicationGroupId = "string",
#'   NewReplicaCount = 123,
#'   ReplicaConfiguration = list(
#'     list(
#'       NodeGroupId = "string",
#'       NewReplicaCount = 123,
#'       PreferredAvailabilityZones = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ApplyImmediately = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_increase_replica_count
elasticache_increase_replica_count <- function(ReplicationGroupId, NewReplicaCount = NULL, ReplicaConfiguration = NULL, ApplyImmediately) {
  op <- new_operation(
    name = "IncreaseReplicaCount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$increase_replica_count_input(ReplicationGroupId = ReplicationGroupId, NewReplicaCount = NewReplicaCount, ReplicaConfiguration = ReplicaConfiguration, ApplyImmediately = ApplyImmediately)
  output <- .elasticache$increase_replica_count_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$increase_replica_count <- elasticache_increase_replica_count

#' Lists all available node types that you can scale your Redis cluster's
#' or replication group's current node type up to
#'
#' Lists all available node types that you can scale your Redis cluster\'s
#' or replication group\'s current node type up to.
#' 
#' When you use the `ModifyCacheCluster` or `ModifyReplicationGroup`
#' operations to scale up your cluster or replication group, the value of
#' the `CacheNodeType` parameter must be one of the node types returned by
#' this operation.
#'
#' @usage
#' elasticache_list_allowed_node_type_modifications(CacheClusterId,
#'   ReplicationGroupId)
#'
#' @param CacheClusterId The name of the cluster you want to scale up to a larger node instanced
#' type. ElastiCache uses the cluster id to identify the current node type
#' of this cluster and from that to create a list of node types you can
#' scale up to.
#' 
#' You must provide a value for either the `CacheClusterId` or the
#' `ReplicationGroupId`.
#' @param ReplicationGroupId The name of the replication group want to scale up to a larger node
#' type. ElastiCache uses the replication group id to identify the current
#' node type being used by this replication group, and from that to create
#' a list of node types you can scale up to.
#' 
#' You must provide a value for either the `CacheClusterId` or the
#' `ReplicationGroupId`.
#'
#' @section Request syntax:
#' ```
#' svc$list_allowed_node_type_modifications(
#'   CacheClusterId = "string",
#'   ReplicationGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_list_allowed_node_type_modifications
elasticache_list_allowed_node_type_modifications <- function(CacheClusterId = NULL, ReplicationGroupId = NULL) {
  op <- new_operation(
    name = "ListAllowedNodeTypeModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$list_allowed_node_type_modifications_input(CacheClusterId = CacheClusterId, ReplicationGroupId = ReplicationGroupId)
  output <- .elasticache$list_allowed_node_type_modifications_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$list_allowed_node_type_modifications <- elasticache_list_allowed_node_type_modifications

#' Lists all cost allocation tags currently on the named resource
#'
#' Lists all cost allocation tags currently on the named resource. A
#' `cost allocation tag` is a key-value pair where the key is
#' case-sensitive and the value is optional. You can use cost allocation
#' tags to categorize and track your AWS costs.
#' 
#' If the cluster is not in the *available* state, `ListTagsForResource`
#' returns an error.
#' 
#' You can have a maximum of 50 cost allocation tags on an ElastiCache
#' resource. For more information, see [Monitoring Costs with
#' Tags](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html).
#'
#' @usage
#' elasticache_list_tags_for_resource(ResourceName)
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want the
#' list of tags, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_list_tags_for_resource
elasticache_list_tags_for_resource <- function(ResourceName) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$list_tags_for_resource_input(ResourceName = ResourceName)
  output <- .elasticache$list_tags_for_resource_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$list_tags_for_resource <- elasticache_list_tags_for_resource

#' Modifies the settings for a cluster
#'
#' Modifies the settings for a cluster. You can use this operation to
#' change one or more cluster configuration parameters by specifying the
#' parameters and the new values.
#'
#' @usage
#' elasticache_modify_cache_cluster(CacheClusterId, NumCacheNodes,
#'   CacheNodeIdsToRemove, AZMode, NewAvailabilityZones,
#'   CacheSecurityGroupNames, SecurityGroupIds, PreferredMaintenanceWindow,
#'   NotificationTopicArn, CacheParameterGroupName, NotificationTopicStatus,
#'   ApplyImmediately, EngineVersion, AutoMinorVersionUpgrade,
#'   SnapshotRetentionLimit, SnapshotWindow, CacheNodeType)
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier. This value is stored as a lowercase string.
#' @param NumCacheNodes The number of cache nodes that the cluster should have. If the value for
#' `NumCacheNodes` is greater than the sum of the number of current cache
#' nodes and the number of cache nodes pending creation (which may be
#' zero), more nodes are added. If the value is less than the number of
#' existing cache nodes, nodes are removed. If the value is equal to the
#' number of current cache nodes, any pending add or remove requests are
#' canceled.
#' 
#' If you are removing cache nodes, you must use the `CacheNodeIdsToRemove`
#' parameter to provide the IDs of the specific cache nodes to remove.
#' 
#' For clusters running Redis, this value must be 1. For clusters running
#' Memcached, this value must be between 1 and 20.
#' 
#' Adding or removing Memcached cache nodes can be applied immediately or
#' as a pending operation (see `ApplyImmediately`).
#' 
#' A pending operation to modify the number of cache nodes in a cluster
#' during its maintenance window, whether by adding or removing nodes in
#' accordance with the scale out architecture, is not queued. The
#' customer\'s latest request to add or remove nodes to the cluster
#' overrides any previous pending operations to modify the number of cache
#' nodes in the cluster. For example, a request to remove 2 nodes would
#' override a previous pending operation to remove 3 nodes. Similarly, a
#' request to add 2 nodes would override a previous pending operation to
#' remove 3 nodes and vice versa. As Memcached cache nodes may now be
#' provisioned in different Availability Zones with flexible cache node
#' placement, a request to add nodes does not automatically override a
#' previous pending operation to add nodes. The customer can modify the
#' previous pending operation to add more nodes or explicitly cancel the
#' pending request and retry the new request. To cancel pending operations
#' to modify the number of cache nodes in a cluster, use the
#' `ModifyCacheCluster` request and set `NumCacheNodes` equal to the number
#' of cache nodes currently in the cluster.
#' @param CacheNodeIdsToRemove A list of cache node IDs to be removed. A node ID is a numeric
#' identifier (0001, 0002, etc.). This parameter is only valid when
#' `NumCacheNodes` is less than the existing number of cache nodes. The
#' number of cache node IDs supplied in this parameter must match the
#' difference between the existing number of cache nodes in the cluster or
#' pending cache nodes, whichever is greater, and the value of
#' `NumCacheNodes` in the request.
#' 
#' For example: If you have 3 active cache nodes, 7 pending cache nodes,
#' and the number of cache nodes in this `ModifyCacheCluster` call is 5,
#' you must list 2 (7 - 5) cache node IDs to remove.
#' @param AZMode Specifies whether the new nodes in this Memcached cluster are all
#' created in a single Availability Zone or created across multiple
#' Availability Zones.
#' 
#' Valid values: `single-az` \\| `cross-az`.
#' 
#' This option is only supported for Memcached clusters.
#' 
#' You cannot specify `single-az` if the Memcached cluster already has
#' cache nodes in different Availability Zones. If `cross-az` is specified,
#' existing Memcached nodes remain in their current Availability Zone.
#' 
#' Only newly created nodes are located in different Availability Zones.
#' For instructions on how to move existing Memcached nodes to different
#' Availability Zones, see the **Availability Zone Considerations** section
#' of [Cache Node Considerations for
#' Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
#' @param NewAvailabilityZones The list of Availability Zones where the new Memcached cache nodes are
#' created.
#' 
#' This parameter is only valid when `NumCacheNodes` in the request is
#' greater than the sum of the number of active cache nodes and the number
#' of cache nodes pending creation (which may be zero). The number of
#' Availability Zones supplied in this list must match the cache nodes
#' being added in this request.
#' 
#' This option is only supported on Memcached clusters.
#' 
#' Scenarios:
#' 
#' -   **Scenario 1:** You have 3 active nodes and wish to add 2 nodes.
#'     Specify `NumCacheNodes=5` (3 + 2) and optionally specify two
#'     Availability Zones for the two new nodes.
#' 
#' -   **Scenario 2:** You have 3 active nodes and 2 nodes pending creation
#'     (from the scenario 1 call) and want to add 1 more node. Specify
#'     `NumCacheNodes=6` ((3 + 2) + 1) and optionally specify an
#'     Availability Zone for the new node.
#' 
#' -   **Scenario 3:** You want to cancel all pending operations. Specify
#'     `NumCacheNodes=3` to cancel all pending operations.
#' 
#' The Availability Zone placement of nodes pending creation cannot be
#' modified. If you wish to cancel any nodes pending creation, add 0 nodes
#' by setting `NumCacheNodes` to the number of current nodes.
#' 
#' If `cross-az` is specified, existing Memcached nodes remain in their
#' current Availability Zone. Only newly created nodes can be located in
#' different Availability Zones. For guidance on how to move existing
#' Memcached nodes to different Availability Zones, see the **Availability
#' Zone Considerations** section of [Cache Node Considerations for
#' Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
#' 
#' **Impact of new add/remove requests upon pending requests**
#' 
#' -   Scenario-1
#' 
#'     -   Pending Action: Delete
#' 
#'     -   New Request: Delete
#' 
#'     -   Result: The new delete, pending or immediate, replaces the
#'         pending delete.
#' 
#' -   Scenario-2
#' 
#'     -   Pending Action: Delete
#' 
#'     -   New Request: Create
#' 
#'     -   Result: The new create, pending or immediate, replaces the
#'         pending delete.
#' 
#' -   Scenario-3
#' 
#'     -   Pending Action: Create
#' 
#'     -   New Request: Delete
#' 
#'     -   Result: The new delete, pending or immediate, replaces the
#'         pending create.
#' 
#' -   Scenario-4
#' 
#'     -   Pending Action: Create
#' 
#'     -   New Request: Create
#' 
#'     -   Result: The new create is added to the pending create.
#' 
#'         **Important:** If the new create request is **Apply
#'         Immediately - Yes**, all creates are performed immediately. If
#'         the new create request is **Apply Immediately - No**, all
#'         creates are pending.
#' @param CacheSecurityGroupNames A list of cache security group names to authorize on this cluster. This
#' change is asynchronously applied as soon as possible.
#' 
#' You can use this parameter only with clusters that are created outside
#' of an Amazon Virtual Private Cloud (Amazon VPC).
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters. Must
#' not be \"Default\".
#' @param SecurityGroupIds Specifies the VPC Security Groups associated with the cluster.
#' 
#' This parameter can be used only with clusters that are created in an
#' Amazon Virtual Private Cloud (Amazon VPC).
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which
#' notifications are sent.
#' 
#' The Amazon SNS topic owner must be same as the cluster owner.
#' @param CacheParameterGroupName The name of the cache parameter group to apply to this cluster. This
#' change is asynchronously applied as soon as possible for parameters when
#' the `ApplyImmediately` parameter is specified as `true` for this
#' request.
#' @param NotificationTopicStatus The status of the Amazon SNS notification topic. Notifications are sent
#' only if the status is `active`.
#' 
#' Valid values: `active` \\| `inactive`
#' @param ApplyImmediately If `true`, this parameter causes the modifications in this request and
#' any pending modifications to be applied, asynchronously and as soon as
#' possible, regardless of the `PreferredMaintenanceWindow` setting for the
#' cluster.
#' 
#' If `false`, changes to the cluster are applied on the next maintenance
#' reboot, or the next failure reboot, whichever occurs first.
#' 
#' If you perform a `ModifyCacheCluster` before a pending modification is
#' applied, the pending modification is replaced by the newer modification.
#' 
#' Valid values: `true` \\| `false`
#' 
#' Default: `false`
#' @param EngineVersion The upgraded version of the cache engine to be run on the cache nodes.
#' 
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing cluster and
#' create it anew with the earlier engine version.
#' @param AutoMinorVersionUpgrade This parameter is currently disabled.
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic cluster
#' snapshots before deleting them. For example, if you set
#' `SnapshotRetentionLimit` to 5, a snapshot that was taken today is
#' retained for 5 days before being deleted.
#' 
#' If the value of `SnapshotRetentionLimit` is set to zero (0), backups are
#' turned off.
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of your cluster.
#' @param CacheNodeType A valid cache node type that you want to scale this cluster up to.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cache_cluster(
#'   CacheClusterId = "string",
#'   NumCacheNodes = 123,
#'   CacheNodeIdsToRemove = list(
#'     "string"
#'   ),
#'   AZMode = "single-az"|"cross-az",
#'   NewAvailabilityZones = list(
#'     "string"
#'   ),
#'   CacheSecurityGroupNames = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   PreferredMaintenanceWindow = "string",
#'   NotificationTopicArn = "string",
#'   CacheParameterGroupName = "string",
#'   NotificationTopicStatus = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   SnapshotRetentionLimit = 123,
#'   SnapshotWindow = "string",
#'   CacheNodeType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_cluster
elasticache_modify_cache_cluster <- function(CacheClusterId, NumCacheNodes = NULL, CacheNodeIdsToRemove = NULL, AZMode = NULL, NewAvailabilityZones = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, CacheParameterGroupName = NULL, NotificationTopicStatus = NULL, ApplyImmediately = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, CacheNodeType = NULL) {
  op <- new_operation(
    name = "ModifyCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_cluster_input(CacheClusterId = CacheClusterId, NumCacheNodes = NumCacheNodes, CacheNodeIdsToRemove = CacheNodeIdsToRemove, AZMode = AZMode, NewAvailabilityZones = NewAvailabilityZones, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, CacheParameterGroupName = CacheParameterGroupName, NotificationTopicStatus = NotificationTopicStatus, ApplyImmediately = ApplyImmediately, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, CacheNodeType = CacheNodeType)
  output <- .elasticache$modify_cache_cluster_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_cluster <- elasticache_modify_cache_cluster

#' Modifies the parameters of a cache parameter group
#'
#' Modifies the parameters of a cache parameter group. You can modify up to
#' 20 parameters in a single request by submitting a list parameter name
#' and value pairs.
#'
#' @usage
#' elasticache_modify_cache_parameter_group(CacheParameterGroupName,
#'   ParameterNameValues)
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to modify.
#' @param ParameterNameValues &#91;required&#93; An array of parameter names and values for the parameter update. You
#' must supply at least one parameter name and value; subsequent arguments
#' are optional. A maximum of 20 parameters may be modified per request.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cache_parameter_group(
#'   CacheParameterGroupName = "string",
#'   ParameterNameValues = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_parameter_group
elasticache_modify_cache_parameter_group <- function(CacheParameterGroupName, ParameterNameValues) {
  op <- new_operation(
    name = "ModifyCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, ParameterNameValues = ParameterNameValues)
  output <- .elasticache$modify_cache_parameter_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_parameter_group <- elasticache_modify_cache_parameter_group

#' Modifies an existing cache subnet group
#'
#' Modifies an existing cache subnet group.
#'
#' @usage
#' elasticache_modify_cache_subnet_group(CacheSubnetGroupName,
#'   CacheSubnetGroupDescription, SubnetIds)
#'
#' @param CacheSubnetGroupName &#91;required&#93; The name for the cache subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters or
#' hyphens.
#' 
#' Example: `mysubnetgroup`
#' @param CacheSubnetGroupDescription A description of the cache subnet group.
#' @param SubnetIds The EC2 subnet IDs for the cache subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cache_subnet_group(
#'   CacheSubnetGroupName = "string",
#'   CacheSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_cache_subnet_group
elasticache_modify_cache_subnet_group <- function(CacheSubnetGroupName, CacheSubnetGroupDescription = NULL, SubnetIds = NULL) {
  op <- new_operation(
    name = "ModifyCacheSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_cache_subnet_group_input(CacheSubnetGroupName = CacheSubnetGroupName, CacheSubnetGroupDescription = CacheSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .elasticache$modify_cache_subnet_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_cache_subnet_group <- elasticache_modify_cache_subnet_group

#' Modifies the settings for a replication group
#'
#' Modifies the settings for a replication group.
#' 
#' For Redis (cluster mode enabled) clusters, this operation cannot be used
#' to change a cluster\'s node type or engine version. For more
#' information, see:
#' 
#' -   [Scaling for Amazon ElastiCache for Redis (cluster mode
#'     enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html)
#'     in the ElastiCache User Guide
#' 
#' -   [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html)
#'     in the ElastiCache API Reference
#' 
#' This operation is valid for Redis only.
#'
#' @usage
#' elasticache_modify_replication_group(ReplicationGroupId,
#'   ReplicationGroupDescription, PrimaryClusterId, SnapshottingClusterId,
#'   AutomaticFailoverEnabled, CacheSecurityGroupNames, SecurityGroupIds,
#'   PreferredMaintenanceWindow, NotificationTopicArn,
#'   CacheParameterGroupName, NotificationTopicStatus, ApplyImmediately,
#'   EngineVersion, AutoMinorVersionUpgrade, SnapshotRetentionLimit,
#'   SnapshotWindow, CacheNodeType, NodeGroupId)
#'
#' @param ReplicationGroupId &#91;required&#93; The identifier of the replication group to modify.
#' @param ReplicationGroupDescription A description for the replication group. Maximum length is 255
#' characters.
#' @param PrimaryClusterId For replication groups with a single primary, if this parameter is
#' specified, ElastiCache promotes the specified cluster in the specified
#' replication group to the primary role. The nodes of all other clusters
#' in the replication group are read replicas.
#' @param SnapshottingClusterId The cluster ID that is used as the daily snapshot source for the
#' replication group. This parameter cannot be set for Redis (cluster mode
#' enabled) replication groups.
#' @param AutomaticFailoverEnabled Determines whether a read replica is automatically promoted to
#' read/write primary if the existing primary encounters a failure.
#' 
#' Valid values: `true` \\| `false`
#' 
#' Amazon ElastiCache for Redis does not support Multi-AZ with automatic
#' failover on:
#' 
#' -   Redis versions earlier than 2.8.6.
#' 
#' -   Redis (cluster mode disabled): T1 node types.
#' 
#' -   Redis (cluster mode enabled): T1 node types.
#' @param CacheSecurityGroupNames A list of cache security group names to authorize for the clusters in
#' this replication group. This change is asynchronously applied as soon as
#' possible.
#' 
#' This parameter can be used only with replication group containing
#' clusters running outside of an Amazon Virtual Private Cloud (Amazon
#' VPC).
#' 
#' Constraints: Must contain no more than 255 alphanumeric characters. Must
#' not be `Default`.
#' @param SecurityGroupIds Specifies the VPC Security Groups associated with the clusters in the
#' replication group.
#' 
#' This parameter can be used only with replication group containing
#' clusters running in an Amazon Virtual Private Cloud (Amazon VPC).
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which
#' notifications are sent.
#' 
#' The Amazon SNS topic owner must be same as the replication group owner.
#' @param CacheParameterGroupName The name of the cache parameter group to apply to all of the clusters in
#' this replication group. This change is asynchronously applied as soon as
#' possible for parameters when the `ApplyImmediately` parameter is
#' specified as `true` for this request.
#' @param NotificationTopicStatus The status of the Amazon SNS notification topic for the replication
#' group. Notifications are sent only if the status is `active`.
#' 
#' Valid values: `active` \\| `inactive`
#' @param ApplyImmediately If `true`, this parameter causes the modifications in this request and
#' any pending modifications to be applied, asynchronously and as soon as
#' possible, regardless of the `PreferredMaintenanceWindow` setting for the
#' replication group.
#' 
#' If `false`, changes to the nodes in the replication group are applied on
#' the next maintenance reboot, or the next failure reboot, whichever
#' occurs first.
#' 
#' Valid values: `true` \\| `false`
#' 
#' Default: `false`
#' @param EngineVersion The upgraded version of the cache engine to be run on the clusters in
#' the replication group.
#' 
#' **Important:** You can upgrade to a newer engine version (see [Selecting
#' a Cache Engine and
#' Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
#' but you cannot downgrade to an earlier engine version. If you want to
#' use an earlier engine version, you must delete the existing replication
#' group and create it anew with the earlier engine version.
#' @param AutoMinorVersionUpgrade This parameter is currently disabled.
#' @param SnapshotRetentionLimit The number of days for which ElastiCache retains automatic node group
#' (shard) snapshots before deleting them. For example, if you set
#' `SnapshotRetentionLimit` to 5, a snapshot that was taken today is
#' retained for 5 days before being deleted.
#' 
#' **Important** If the value of SnapshotRetentionLimit is set to zero (0),
#' backups are turned off.
#' @param SnapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a
#' daily snapshot of the node group (shard) specified by
#' `SnapshottingClusterId`.
#' 
#' Example: `05:00-09:00`
#' 
#' If you do not specify this parameter, ElastiCache automatically chooses
#' an appropriate time range.
#' @param CacheNodeType A valid cache node type that you want to scale this replication group
#' to.
#' @param NodeGroupId Deprecated. This parameter is not used.
#'
#' @section Request syntax:
#' ```
#' svc$modify_replication_group(
#'   ReplicationGroupId = "string",
#'   ReplicationGroupDescription = "string",
#'   PrimaryClusterId = "string",
#'   SnapshottingClusterId = "string",
#'   AutomaticFailoverEnabled = TRUE|FALSE,
#'   CacheSecurityGroupNames = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   PreferredMaintenanceWindow = "string",
#'   NotificationTopicArn = "string",
#'   CacheParameterGroupName = "string",
#'   NotificationTopicStatus = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   SnapshotRetentionLimit = 123,
#'   SnapshotWindow = "string",
#'   CacheNodeType = "string",
#'   NodeGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_replication_group
elasticache_modify_replication_group <- function(ReplicationGroupId, ReplicationGroupDescription = NULL, PrimaryClusterId = NULL, SnapshottingClusterId = NULL, AutomaticFailoverEnabled = NULL, CacheSecurityGroupNames = NULL, SecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, CacheParameterGroupName = NULL, NotificationTopicStatus = NULL, ApplyImmediately = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, SnapshotRetentionLimit = NULL, SnapshotWindow = NULL, CacheNodeType = NULL, NodeGroupId = NULL) {
  op <- new_operation(
    name = "ModifyReplicationGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_replication_group_input(ReplicationGroupId = ReplicationGroupId, ReplicationGroupDescription = ReplicationGroupDescription, PrimaryClusterId = PrimaryClusterId, SnapshottingClusterId = SnapshottingClusterId, AutomaticFailoverEnabled = AutomaticFailoverEnabled, CacheSecurityGroupNames = CacheSecurityGroupNames, SecurityGroupIds = SecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, CacheParameterGroupName = CacheParameterGroupName, NotificationTopicStatus = NotificationTopicStatus, ApplyImmediately = ApplyImmediately, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, SnapshotRetentionLimit = SnapshotRetentionLimit, SnapshotWindow = SnapshotWindow, CacheNodeType = CacheNodeType, NodeGroupId = NodeGroupId)
  output <- .elasticache$modify_replication_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_replication_group <- elasticache_modify_replication_group

#' Modifies a replication group's shards (node groups) by allowing you to
#' add shards, remove shards, or rebalance the keyspaces among exisiting
#' shards
#'
#' Modifies a replication group\'s shards (node groups) by allowing you to
#' add shards, remove shards, or rebalance the keyspaces among exisiting
#' shards.
#'
#' @usage
#' elasticache_modify_replication_group_shard_configuration(
#'   ReplicationGroupId, NodeGroupCount, ApplyImmediately,
#'   ReshardingConfiguration, NodeGroupsToRemove, NodeGroupsToRetain)
#'
#' @param ReplicationGroupId &#91;required&#93; The name of the Redis (cluster mode enabled) cluster (replication group)
#' on which the shards are to be configured.
#' @param NodeGroupCount &#91;required&#93; The number of node groups (shards) that results from the modification of
#' the shard configuration.
#' @param ApplyImmediately &#91;required&#93; Indicates that the shard reconfiguration process begins immediately. At
#' present, the only permitted value for this parameter is `true`.
#' 
#' Value: true
#' @param ReshardingConfiguration Specifies the preferred availability zones for each node group in the
#' cluster. If the value of `NodeGroupCount` is greater than the current
#' number of node groups (shards), you can use this parameter to specify
#' the preferred availability zones of the cluster\'s shards. If you omit
#' this parameter ElastiCache selects availability zones for you.
#' 
#' You can specify this parameter only if the value of `NodeGroupCount` is
#' greater than the current number of node groups (shards).
#' @param NodeGroupsToRemove If the value of `NodeGroupCount` is less than the current number of node
#' groups (shards), then either `NodeGroupsToRemove` or
#' `NodeGroupsToRetain` is required. `NodeGroupsToRemove` is a list of
#' `NodeGroupId`s to remove from the cluster.
#' 
#' ElastiCache for Redis will attempt to remove all node groups listed by
#' `NodeGroupsToRemove` from the cluster.
#' @param NodeGroupsToRetain If the value of `NodeGroupCount` is less than the current number of node
#' groups (shards), then either `NodeGroupsToRemove` or
#' `NodeGroupsToRetain` is required. `NodeGroupsToRetain` is a list of
#' `NodeGroupId`s to retain in the cluster.
#' 
#' ElastiCache for Redis will attempt to remove all node groups except
#' those listed by `NodeGroupsToRetain` from the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$modify_replication_group_shard_configuration(
#'   ReplicationGroupId = "string",
#'   NodeGroupCount = 123,
#'   ApplyImmediately = TRUE|FALSE,
#'   ReshardingConfiguration = list(
#'     list(
#'       NodeGroupId = "string",
#'       PreferredAvailabilityZones = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NodeGroupsToRemove = list(
#'     "string"
#'   ),
#'   NodeGroupsToRetain = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_modify_replication_group_shard_configuration
elasticache_modify_replication_group_shard_configuration <- function(ReplicationGroupId, NodeGroupCount, ApplyImmediately, ReshardingConfiguration = NULL, NodeGroupsToRemove = NULL, NodeGroupsToRetain = NULL) {
  op <- new_operation(
    name = "ModifyReplicationGroupShardConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$modify_replication_group_shard_configuration_input(ReplicationGroupId = ReplicationGroupId, NodeGroupCount = NodeGroupCount, ApplyImmediately = ApplyImmediately, ReshardingConfiguration = ReshardingConfiguration, NodeGroupsToRemove = NodeGroupsToRemove, NodeGroupsToRetain = NodeGroupsToRetain)
  output <- .elasticache$modify_replication_group_shard_configuration_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$modify_replication_group_shard_configuration <- elasticache_modify_replication_group_shard_configuration

#' Allows you to purchase a reserved cache node offering
#'
#' Allows you to purchase a reserved cache node offering.
#'
#' @usage
#' elasticache_purchase_reserved_cache_nodes_offering(
#'   ReservedCacheNodesOfferingId, ReservedCacheNodeId, CacheNodeCount)
#'
#' @param ReservedCacheNodesOfferingId &#91;required&#93; The ID of the reserved cache node offering to purchase.
#' 
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param ReservedCacheNodeId A customer-specified identifier to track this reservation.
#' 
#' The Reserved Cache Node ID is an unique customer-specified identifier to
#' track this reservation. If this parameter is not specified, ElastiCache
#' automatically generates an identifier for the reservation.
#' 
#' Example: myreservationID
#' @param CacheNodeCount The number of cache node instances to reserve.
#' 
#' Default: `1`
#'
#' @section Request syntax:
#' ```
#' svc$purchase_reserved_cache_nodes_offering(
#'   ReservedCacheNodesOfferingId = "string",
#'   ReservedCacheNodeId = "string",
#'   CacheNodeCount = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_purchase_reserved_cache_nodes_offering
elasticache_purchase_reserved_cache_nodes_offering <- function(ReservedCacheNodesOfferingId, ReservedCacheNodeId = NULL, CacheNodeCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedCacheNodesOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$purchase_reserved_cache_nodes_offering_input(ReservedCacheNodesOfferingId = ReservedCacheNodesOfferingId, ReservedCacheNodeId = ReservedCacheNodeId, CacheNodeCount = CacheNodeCount)
  output <- .elasticache$purchase_reserved_cache_nodes_offering_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$purchase_reserved_cache_nodes_offering <- elasticache_purchase_reserved_cache_nodes_offering

#' Reboots some, or all, of the cache nodes within a provisioned cluster
#'
#' Reboots some, or all, of the cache nodes within a provisioned cluster.
#' This operation applies any modified cache parameter groups to the
#' cluster. The reboot operation takes place as soon as possible, and
#' results in a momentary outage to the cluster. During the reboot, the
#' cluster status is set to REBOOTING.
#' 
#' The reboot causes the contents of the cache (for each cache node being
#' rebooted) to be lost.
#' 
#' When the reboot is complete, a cluster event is created.
#' 
#' Rebooting a cluster is currently supported on Memcached and Redis
#' (cluster mode disabled) clusters. Rebooting is not supported on Redis
#' (cluster mode enabled) clusters.
#' 
#' If you make changes to parameters that require a Redis (cluster mode
#' enabled) cluster reboot for the changes to be applied, see [Rebooting a
#' Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html)
#' for an alternate process.
#'
#' @usage
#' elasticache_reboot_cache_cluster(CacheClusterId, CacheNodeIdsToReboot)
#'
#' @param CacheClusterId &#91;required&#93; The cluster identifier. This parameter is stored as a lowercase string.
#' @param CacheNodeIdsToReboot &#91;required&#93; A list of cache node IDs to reboot. A node ID is a numeric identifier
#' (0001, 0002, etc.). To reboot an entire cluster, specify all of the
#' cache node IDs.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_cache_cluster(
#'   CacheClusterId = "string",
#'   CacheNodeIdsToReboot = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_reboot_cache_cluster
elasticache_reboot_cache_cluster <- function(CacheClusterId, CacheNodeIdsToReboot) {
  op <- new_operation(
    name = "RebootCacheCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$reboot_cache_cluster_input(CacheClusterId = CacheClusterId, CacheNodeIdsToReboot = CacheNodeIdsToReboot)
  output <- .elasticache$reboot_cache_cluster_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$reboot_cache_cluster <- elasticache_reboot_cache_cluster

#' Removes the tags identified by the TagKeys list from the named resource
#'
#' Removes the tags identified by the `TagKeys` list from the named
#' resource.
#'
#' @usage
#' elasticache_remove_tags_from_resource(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which you want the
#' tags removed, for example
#' `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or
#' `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param TagKeys &#91;required&#93; A list of `TagKeys` identifying the tags you want removed from the named
#' resource.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_remove_tags_from_resource
elasticache_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .elasticache$remove_tags_from_resource_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$remove_tags_from_resource <- elasticache_remove_tags_from_resource

#' Modifies the parameters of a cache parameter group to the engine or
#' system default value
#'
#' Modifies the parameters of a cache parameter group to the engine or
#' system default value. You can reset specific parameters by submitting a
#' list of parameter names. To reset the entire cache parameter group,
#' specify the `ResetAllParameters` and `CacheParameterGroupName`
#' parameters.
#'
#' @usage
#' elasticache_reset_cache_parameter_group(CacheParameterGroupName,
#'   ResetAllParameters, ParameterNameValues)
#'
#' @param CacheParameterGroupName &#91;required&#93; The name of the cache parameter group to reset.
#' @param ResetAllParameters If `true`, all parameters in the cache parameter group are reset to
#' their default values. If `false`, only the parameters listed by
#' `ParameterNameValues` are reset to their default values.
#' 
#' Valid values: `true` \\| `false`
#' @param ParameterNameValues An array of parameter names to reset to their default values. If
#' `ResetAllParameters` is `true`, do not use `ParameterNameValues`. If
#' `ResetAllParameters` is `false`, you must specify the name of at least
#' one parameter to reset.
#'
#' @section Request syntax:
#' ```
#' svc$reset_cache_parameter_group(
#'   CacheParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   ParameterNameValues = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_reset_cache_parameter_group
elasticache_reset_cache_parameter_group <- function(CacheParameterGroupName, ResetAllParameters = NULL, ParameterNameValues = NULL) {
  op <- new_operation(
    name = "ResetCacheParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$reset_cache_parameter_group_input(CacheParameterGroupName = CacheParameterGroupName, ResetAllParameters = ResetAllParameters, ParameterNameValues = ParameterNameValues)
  output <- .elasticache$reset_cache_parameter_group_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$reset_cache_parameter_group <- elasticache_reset_cache_parameter_group

#' Revokes ingress from a cache security group
#'
#' Revokes ingress from a cache security group. Use this operation to
#' disallow access from an Amazon EC2 security group that had been
#' previously authorized.
#'
#' @usage
#' elasticache_revoke_cache_security_group_ingress(CacheSecurityGroupName,
#'   EC2SecurityGroupName, EC2SecurityGroupOwnerId)
#'
#' @param CacheSecurityGroupName &#91;required&#93; The name of the cache security group to revoke ingress from.
#' @param EC2SecurityGroupName &#91;required&#93; The name of the Amazon EC2 security group to revoke access from.
#' @param EC2SecurityGroupOwnerId &#91;required&#93; The AWS account number of the Amazon EC2 security group owner. Note that
#' this is not the same thing as an AWS access key ID - you must provide a
#' valid AWS account number for this parameter.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_cache_security_group_ingress(
#'   CacheSecurityGroupName = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_revoke_cache_security_group_ingress
elasticache_revoke_cache_security_group_ingress <- function(CacheSecurityGroupName, EC2SecurityGroupName, EC2SecurityGroupOwnerId) {
  op <- new_operation(
    name = "RevokeCacheSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$revoke_cache_security_group_ingress_input(CacheSecurityGroupName = CacheSecurityGroupName, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .elasticache$revoke_cache_security_group_ingress_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$revoke_cache_security_group_ingress <- elasticache_revoke_cache_security_group_ingress

#' Represents the input of a TestFailover operation which test automatic
#' failover on a specified node group (called shard in the console) in a
#' replication group (called cluster in the console)
#'
#' Represents the input of a `TestFailover` operation which test automatic
#' failover on a specified node group (called shard in the console) in a
#' replication group (called cluster in the console).
#' 
#' **Note the following**
#' 
#' -   A customer can use this operation to test automatic failover on up
#'     to 5 shards (called node groups in the ElastiCache API and AWS CLI)
#'     in any rolling 24-hour period.
#' 
#' -   If calling this operation on shards in different clusters (called
#'     replication groups in the API and CLI), the calls can be made
#'     concurrently.
#' 
#' -   If calling this operation multiple times on different shards in the
#'     same Redis (cluster mode enabled) replication group, the first node
#'     replacement must complete before a subsequent call can be made.
#' 
#' -   To determine whether the node replacement is complete you can check
#'     Events using the Amazon ElastiCache console, the AWS CLI, or the
#'     ElastiCache API. Look for the following automatic failover related
#'     events, listed here in order of occurrance:
#' 
#'     1.  Replication group message:
#'         `Test Failover API called for node group &lt;node-group-id&gt;`
#' 
#'     2.  Cache cluster message:
#'         `Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed`
#' 
#'     3.  Replication group message:
#'         `Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed`
#' 
#'     4.  Cache cluster message: `Recovering cache nodes &lt;node-id&gt;`
#' 
#'     5.  Cache cluster message:
#'         `Finished recovery for cache nodes &lt;node-id&gt;`
#' 
#'     For more information see:
#' 
#'     -   [Viewing ElastiCache
#'         Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html)
#'         in the *ElastiCache User Guide*
#' 
#'     -   [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html)
#'         in the ElastiCache API Reference
#' 
#' Also see, [Testing Multi-AZ with Automatic
#' Failover](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test)
#' in the *ElastiCache User Guide*.
#'
#' @usage
#' elasticache_test_failover(ReplicationGroupId, NodeGroupId)
#'
#' @param ReplicationGroupId &#91;required&#93; The name of the replication group (console: cluster) whose automatic
#' failover is being tested by this operation.
#' @param NodeGroupId &#91;required&#93; The name of the node group (called shard in the console) in this
#' replication group on which automatic failover is to be tested. You may
#' test automatic failover on up to 5 node groups in any rolling 24-hour
#' period.
#'
#' @section Request syntax:
#' ```
#' svc$test_failover(
#'   ReplicationGroupId = "string",
#'   NodeGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticache_test_failover
elasticache_test_failover <- function(ReplicationGroupId, NodeGroupId) {
  op <- new_operation(
    name = "TestFailover",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticache$test_failover_input(ReplicationGroupId = ReplicationGroupId, NodeGroupId = NodeGroupId)
  output <- .elasticache$test_failover_output()
  svc <- .elasticache$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticache$operations$test_failover <- elasticache_test_failover
