% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_describe_snapshots}
\alias{memorydb_describe_snapshots}
\title{Returns information about cluster snapshots}
\usage{
memorydb_describe_snapshots(
  ClusterName = NULL,
  SnapshotName = NULL,
  Source = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ShowDetail = NULL
)
}
\arguments{
\item{ClusterName}{A user-supplied cluster identifier. If this parameter is specified, only
snapshots associated with that specific cluster are described.}

\item{SnapshotName}{A user-supplied name of the snapshot. If this parameter is specified,
only this named snapshot is described.}

\item{Source}{If set to system, the output shows snapshots that were automatically
created by MemoryDB. If set to user the output shows snapshots that were
manually created. If omitted, the output shows both automatically and
manually created snapshots.}

\item{NextToken}{An optional argument to pass in case the total number of records exceeds
the value of MaxResults. If nextToken is returned, there are more
results available. The value of nextToken is a unique pagination token
for each page. Make the call again using the returned token to retrieve
the next page. Keep all other arguments unchanged.}

\item{MaxResults}{The maximum number of records to include in the response. If more
records exist than the specified MaxResults value, a token is included
in the response so that the remaining results can be retrieved.}

\item{ShowDetail}{A Boolean value which if true, the shard configuration is included in
the snapshot description.}
}
\description{
Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.

See \url{https://paws-r.github.io/docs/memorydb/describe_snapshots.html} for full documentation.
}
\keyword{internal}
