% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_option_groups}
\alias{rds_describe_option_groups}
\title{Describes the available option groups}
\usage{
rds_describe_option_groups(
  OptionGroupName = NULL,
  Filters = NULL,
  Marker = NULL,
  MaxRecords = NULL,
  EngineName = NULL,
  MajorEngineVersion = NULL
)
}
\arguments{
\item{OptionGroupName}{The name of the option group to describe. Can't be supplied together
with EngineName or MajorEngineVersion.}

\item{Filters}{This parameter isn't currently supported.}

\item{Marker}{An optional pagination token provided by a previous DescribeOptionGroups
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{EngineName}{Filters the list of option groups to only include groups associated with
a specific database engine.

Valid Values:
\itemize{
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{MajorEngineVersion}{Filters the list of option groups to only include groups associated with
a specific database engine version. If specified, then EngineName must
also be specified.}
}
\description{
Describes the available option groups.

See \url{https://paws-r.github.io/docs/rds/describe_option_groups.html} for full documentation.
}
\keyword{internal}
