# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include timestreamquery_service.R
NULL

#' Cancels a query that has been issued
#'
#' @description
#' Cancels a query that has been issued. Cancellation is provided only if the query has not completed running before the cancellation request was issued. Because cancellation is an idempotent operation, subsequent cancellation requests will return a `CancellationMessage`, indicating that the query has already been canceled. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.cancel-query.html) for details.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_cancel_query/](https://www.paws-r-sdk.com/docs/timestreamquery_cancel_query/) for full documentation.
#'
#' @param QueryId &#91;required&#93; The ID of the query that needs to be cancelled. `QueryID` is returned as
#' part of the query result.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_cancel_query
timestreamquery_cancel_query <- function(QueryId) {
  op <- new_operation(
    name = "CancelQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$cancel_query_input(QueryId = QueryId)
  output <- .timestreamquery$cancel_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$cancel_query <- timestreamquery_cancel_query

#' Create a scheduled query that will be run on your behalf at the
#' configured schedule
#'
#' @description
#' Create a scheduled query that will be run on your behalf at the configured schedule. Timestream assumes the execution role provided as part of the `ScheduledQueryExecutionRoleArn` parameter to run the query. You can use the `NotificationConfiguration` parameter to configure notification for your scheduled query operations.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_create_scheduled_query/](https://www.paws-r-sdk.com/docs/timestreamquery_create_scheduled_query/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the scheduled query.
#' @param QueryString &#91;required&#93; The query string to run. Parameter names can be specified in the query
#' string `@@` character followed by an identifier. The named Parameter
#' `@@scheduled_runtime` is reserved and can be used in the query to get the
#' time at which the query is scheduled to run.
#' 
#' The timestamp calculated according to the ScheduleConfiguration
#' parameter, will be the value of `@@scheduled_runtime` paramater for each
#' query run. For example, consider an instance of a scheduled query
#' executing on 2021-12-01 00:00:00. For this instance, the
#' `@@scheduled_runtime` parameter is initialized to the timestamp
#' 2021-12-01 00:00:00 when invoking the query.
#' @param ScheduleConfiguration &#91;required&#93; The schedule configuration for the query.
#' @param NotificationConfiguration &#91;required&#93; Notification configuration for the scheduled query. A notification is
#' sent by Timestream when a query run finishes, when the state is updated
#' or when you delete it.
#' @param TargetConfiguration Configuration used for writing the result of a query.
#' @param ClientToken Using a ClientToken makes the call to CreateScheduledQuery idempotent,
#' in other words, making the same request repeatedly will produce the same
#' result. Making multiple identical CreateScheduledQuery requests has the
#' same effect as making a single request.
#' 
#' -   If CreateScheduledQuery is called without a `ClientToken`, the Query
#'     SDK generates a `ClientToken` on your behalf.
#' 
#' -   After 8 hours, any request with the same `ClientToken` is treated as
#'     a new request.
#' @param ScheduledQueryExecutionRoleArn &#91;required&#93; The ARN for the IAM role that Timestream will assume when running the
#' scheduled query.
#' @param Tags A list of key-value pairs to label the scheduled query.
#' @param KmsKeyId The Amazon KMS key used to encrypt the scheduled query resource,
#' at-rest. If the Amazon KMS key is not specified, the scheduled query
#' resource will be encrypted with a Timestream owned Amazon KMS key. To
#' specify a KMS key, use the key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix the name with *alias/*
#' 
#' If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same
#' KmsKeyId is used to encrypt the error report at rest.
#' @param ErrorReportConfiguration &#91;required&#93; Configuration for error reporting. Error reports will be generated when
#' a problem is encountered when writing the query results.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_create_scheduled_query
timestreamquery_create_scheduled_query <- function(Name, QueryString, ScheduleConfiguration, NotificationConfiguration, TargetConfiguration = NULL, ClientToken = NULL, ScheduledQueryExecutionRoleArn, Tags = NULL, KmsKeyId = NULL, ErrorReportConfiguration) {
  op <- new_operation(
    name = "CreateScheduledQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$create_scheduled_query_input(Name = Name, QueryString = QueryString, ScheduleConfiguration = ScheduleConfiguration, NotificationConfiguration = NotificationConfiguration, TargetConfiguration = TargetConfiguration, ClientToken = ClientToken, ScheduledQueryExecutionRoleArn = ScheduledQueryExecutionRoleArn, Tags = Tags, KmsKeyId = KmsKeyId, ErrorReportConfiguration = ErrorReportConfiguration)
  output <- .timestreamquery$create_scheduled_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$create_scheduled_query <- timestreamquery_create_scheduled_query

#' Deletes a given scheduled query
#'
#' @description
#' Deletes a given scheduled query. This is an irreversible operation.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_delete_scheduled_query/](https://www.paws-r-sdk.com/docs/timestreamquery_delete_scheduled_query/) for full documentation.
#'
#' @param ScheduledQueryArn &#91;required&#93; The ARN of the scheduled query.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_delete_scheduled_query
timestreamquery_delete_scheduled_query <- function(ScheduledQueryArn) {
  op <- new_operation(
    name = "DeleteScheduledQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$delete_scheduled_query_input(ScheduledQueryArn = ScheduledQueryArn)
  output <- .timestreamquery$delete_scheduled_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$delete_scheduled_query <- timestreamquery_delete_scheduled_query

#' DescribeEndpoints returns a list of available endpoints to make
#' Timestream API calls against
#'
#' @description
#' DescribeEndpoints returns a list of available endpoints to make Timestream API calls against. This API is available through both Write and Query.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_describe_endpoints/](https://www.paws-r-sdk.com/docs/timestreamquery_describe_endpoints/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_describe_endpoints
timestreamquery_describe_endpoints <- function() {
  op <- new_operation(
    name = "DescribeEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$describe_endpoints_input()
  output <- .timestreamquery$describe_endpoints_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$describe_endpoints <- timestreamquery_describe_endpoints

#' Provides detailed information about a scheduled query
#'
#' @description
#' Provides detailed information about a scheduled query.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_describe_scheduled_query/](https://www.paws-r-sdk.com/docs/timestreamquery_describe_scheduled_query/) for full documentation.
#'
#' @param ScheduledQueryArn &#91;required&#93; The ARN of the scheduled query.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_describe_scheduled_query
timestreamquery_describe_scheduled_query <- function(ScheduledQueryArn) {
  op <- new_operation(
    name = "DescribeScheduledQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$describe_scheduled_query_input(ScheduledQueryArn = ScheduledQueryArn)
  output <- .timestreamquery$describe_scheduled_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$describe_scheduled_query <- timestreamquery_describe_scheduled_query

#' You can use this API to run a scheduled query manually
#'
#' @description
#' You can use this API to run a scheduled query manually.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_execute_scheduled_query/](https://www.paws-r-sdk.com/docs/timestreamquery_execute_scheduled_query/) for full documentation.
#'
#' @param ScheduledQueryArn &#91;required&#93; ARN of the scheduled query.
#' @param InvocationTime &#91;required&#93; The timestamp in UTC. Query will be run as if it was invoked at this
#' timestamp.
#' @param ClientToken Not used.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_execute_scheduled_query
timestreamquery_execute_scheduled_query <- function(ScheduledQueryArn, InvocationTime, ClientToken = NULL) {
  op <- new_operation(
    name = "ExecuteScheduledQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$execute_scheduled_query_input(ScheduledQueryArn = ScheduledQueryArn, InvocationTime = InvocationTime, ClientToken = ClientToken)
  output <- .timestreamquery$execute_scheduled_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$execute_scheduled_query <- timestreamquery_execute_scheduled_query

#' Gets a list of all scheduled queries in the caller's Amazon account and
#' Region
#'
#' @description
#' Gets a list of all scheduled queries in the caller's Amazon account and Region. [`list_scheduled_queries`][timestreamquery_list_scheduled_queries] is eventually consistent.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_list_scheduled_queries/](https://www.paws-r-sdk.com/docs/timestreamquery_list_scheduled_queries/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return in the output. If the total number
#' of items available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as the argument to the subsequent call to
#' `ListScheduledQueriesRequest`.
#' @param NextToken A pagination token to resume pagination.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_list_scheduled_queries
timestreamquery_list_scheduled_queries <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListScheduledQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$list_scheduled_queries_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .timestreamquery$list_scheduled_queries_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$list_scheduled_queries <- timestreamquery_list_scheduled_queries

#' List all tags on a Timestream query resource
#'
#' @description
#' List all tags on a Timestream query resource.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/timestreamquery_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Timestream resource with tags to be listed. This value is an Amazon
#' Resource Name (ARN).
#' @param MaxResults The maximum number of tags to return.
#' @param NextToken A pagination token to resume pagination.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_list_tags_for_resource
timestreamquery_list_tags_for_resource <- function(ResourceARN, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$list_tags_for_resource_input(ResourceARN = ResourceARN, MaxResults = MaxResults, NextToken = NextToken)
  output <- .timestreamquery$list_tags_for_resource_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$list_tags_for_resource <- timestreamquery_list_tags_for_resource

#' A synchronous operation that allows you to submit a query with
#' parameters to be stored by Timestream for later running
#'
#' @description
#' A synchronous operation that allows you to submit a query with parameters to be stored by Timestream for later running. Timestream only supports using this operation with the `PrepareQueryRequest$ValidateOnly` set to `true`.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_prepare_query/](https://www.paws-r-sdk.com/docs/timestreamquery_prepare_query/) for full documentation.
#'
#' @param QueryString &#91;required&#93; The Timestream query string that you want to use as a prepared
#' statement. Parameter names can be specified in the query string `@@`
#' character followed by an identifier.
#' @param ValidateOnly By setting this value to `true`, Timestream will only validate that the
#' query string is a valid Timestream query, and not store the prepared
#' query for later use.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_prepare_query
timestreamquery_prepare_query <- function(QueryString, ValidateOnly = NULL) {
  op <- new_operation(
    name = "PrepareQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$prepare_query_input(QueryString = QueryString, ValidateOnly = ValidateOnly)
  output <- .timestreamquery$prepare_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$prepare_query <- timestreamquery_prepare_query

#' Query is a synchronous operation that enables you to run a query against
#' your Amazon Timestream data
#'
#' @description
#' [`query`][timestreamquery_query] is a synchronous operation that enables you to run a query against your Amazon Timestream data. [`query`][timestreamquery_query] will time out after 60 seconds. You must update the default timeout in the SDK to support a timeout of 60 seconds. See the [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.run-query.html) for details.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_query/](https://www.paws-r-sdk.com/docs/timestreamquery_query/) for full documentation.
#'
#' @param QueryString &#91;required&#93; The query to be run by Timestream.
#' @param ClientToken Unique, case-sensitive string of up to 64 ASCII characters specified
#' when a [`query`][timestreamquery_query] request is made. Providing a
#' `ClientToken` makes the call to [`query`][timestreamquery_query]
#' *idempotent*. This means that running the same query repeatedly will
#' produce the same result. In other words, making multiple identical
#' [`query`][timestreamquery_query] requests has the same effect as making
#' a single request. When using `ClientToken` in a query, note the
#' following:
#' 
#' -   If the Query API is instantiated without a `ClientToken`, the Query
#'     SDK generates a `ClientToken` on your behalf.
#' 
#' -   If the [`query`][timestreamquery_query] invocation only contains the
#'     `ClientToken` but does not include a `NextToken`, that invocation of
#'     [`query`][timestreamquery_query] is assumed to be a new query run.
#' 
#' -   If the invocation contains `NextToken`, that particular invocation
#'     is assumed to be a subsequent invocation of a prior call to the
#'     Query API, and a result set is returned.
#' 
#' -   After 4 hours, any request with the same `ClientToken` is treated as
#'     a new request.
#' @param NextToken A pagination token used to return a set of results. When the
#' [`query`][timestreamquery_query] API is invoked using `NextToken`, that
#' particular invocation is assumed to be a subsequent invocation of a
#' prior call to [`query`][timestreamquery_query], and a result set is
#' returned. However, if the [`query`][timestreamquery_query] invocation
#' only contains the `ClientToken`, that invocation of
#' [`query`][timestreamquery_query] is assumed to be a new query run.
#' 
#' Note the following when using NextToken in a query:
#' 
#' -   A pagination token can be used for up to five
#'     [`query`][timestreamquery_query] invocations, OR for a duration of
#'     up to 1 hour – whichever comes first.
#' 
#' -   Using the same `NextToken` will return the same set of records. To
#'     keep paginating through the result set, you must to use the most
#'     recent `nextToken`.
#' 
#' -   Suppose a [`query`][timestreamquery_query] invocation returns two
#'     `NextToken` values, `TokenA` and `TokenB`. If `TokenB` is used in a
#'     subsequent [`query`][timestreamquery_query] invocation, then
#'     `TokenA` is invalidated and cannot be reused.
#' 
#' -   To request a previous result set from a query after pagination has
#'     begun, you must re-invoke the Query API.
#' 
#' -   The latest `NextToken` should be used to paginate until `null` is
#'     returned, at which point a new `NextToken` should be used.
#' 
#' -   If the IAM principal of the query initiator and the result reader
#'     are not the same and/or the query initiator and the result reader do
#'     not have the same query string in the query requests, the query will
#'     fail with an `Invalid pagination token` error.
#' @param MaxRows The total number of rows to be returned in the
#' [`query`][timestreamquery_query] output. The initial run of
#' [`query`][timestreamquery_query] with a `MaxRows` value specified will
#' return the result set of the query in two cases:
#' 
#' -   The size of the result is less than `1MB`.
#' 
#' -   The number of rows in the result set is less than the value of
#'     `maxRows`.
#' 
#' Otherwise, the initial invocation of [`query`][timestreamquery_query]
#' only returns a `NextToken`, which can then be used in subsequent calls
#' to fetch the result set. To resume pagination, provide the `NextToken`
#' value in the subsequent command.
#' 
#' If the row size is large (e.g. a row has many columns), Timestream may
#' return fewer rows to keep the response size from exceeding the 1 MB
#' limit. If `MaxRows` is not provided, Timestream will send the necessary
#' number of rows to meet the 1 MB limit.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_query
timestreamquery_query <- function(QueryString, ClientToken = NULL, NextToken = NULL, MaxRows = NULL) {
  op <- new_operation(
    name = "Query",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$query_input(QueryString = QueryString, ClientToken = ClientToken, NextToken = NextToken, MaxRows = MaxRows)
  output <- .timestreamquery$query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$query <- timestreamquery_query

#' Associate a set of tags with a Timestream resource
#'
#' @description
#' Associate a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_tag_resource/](https://www.paws-r-sdk.com/docs/timestreamquery_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Identifies the Timestream resource to which tags should be added. This
#' value is an Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; The tags to be assigned to the Timestream resource.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_tag_resource
timestreamquery_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .timestreamquery$tag_resource_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$tag_resource <- timestreamquery_tag_resource

#' Removes the association of tags from a Timestream query resource
#'
#' @description
#' Removes the association of tags from a Timestream query resource.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_untag_resource/](https://www.paws-r-sdk.com/docs/timestreamquery_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Timestream resource that the tags will be removed from. This value
#' is an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; A list of tags keys. Existing tags of the resource whose keys are
#' members of this list will be removed from the Timestream resource.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_untag_resource
timestreamquery_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .timestreamquery$untag_resource_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$untag_resource <- timestreamquery_untag_resource

#' Update a scheduled query
#'
#' @description
#' Update a scheduled query.
#'
#' See [https://www.paws-r-sdk.com/docs/timestreamquery_update_scheduled_query/](https://www.paws-r-sdk.com/docs/timestreamquery_update_scheduled_query/) for full documentation.
#'
#' @param ScheduledQueryArn &#91;required&#93; ARN of the scheuled query.
#' @param State &#91;required&#93; State of the scheduled query.
#'
#' @keywords internal
#'
#' @rdname timestreamquery_update_scheduled_query
timestreamquery_update_scheduled_query <- function(ScheduledQueryArn, State) {
  op <- new_operation(
    name = "UpdateScheduledQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .timestreamquery$update_scheduled_query_input(ScheduledQueryArn = ScheduledQueryArn, State = State)
  output <- .timestreamquery$update_scheduled_query_output()
  config <- get_config()
  svc <- .timestreamquery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.timestreamquery$operations$update_scheduled_query <- timestreamquery_update_scheduled_query
