% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_service.R
\name{qldb}
\alias{qldb}
\title{Amazon QLDB}
\usage{
qldb(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The resource management API for Amazon QLDB
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- qldb(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=qldb_cancel_journal_kinesis_stream]{cancel_journal_kinesis_stream} \tab Ends a given Amazon QLDB journal stream\cr
\link[=qldb_create_ledger]{create_ledger} \tab Creates a new ledger in your Amazon Web Services account in the current Region\cr
\link[=qldb_delete_ledger]{delete_ledger} \tab Deletes a ledger and all of its contents\cr
\link[=qldb_describe_journal_kinesis_stream]{describe_journal_kinesis_stream} \tab Returns detailed information about a given Amazon QLDB journal stream\cr
\link[=qldb_describe_journal_s3_export]{describe_journal_s3_export} \tab Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request\cr
\link[=qldb_describe_ledger]{describe_ledger} \tab Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created\cr
\link[=qldb_export_journal_to_s3]{export_journal_to_s3} \tab Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket\cr
\link[=qldb_get_block]{get_block} \tab Returns a block object at a specified address in a journal\cr
\link[=qldb_get_digest]{get_digest} \tab Returns the digest of a ledger at the latest committed block in the journal\cr
\link[=qldb_get_revision]{get_revision} \tab Returns a revision data object for a specified document ID and block address\cr
\link[=qldb_list_journal_kinesis_streams_for_ledger]{list_journal_kinesis_streams_for_ledger} \tab Returns all Amazon QLDB journal streams for a given ledger\cr
\link[=qldb_list_journal_s3_exports]{list_journal_s3_exports} \tab Returns all journal export jobs for all ledgers that are associated with the current Amazon Web Services account and Region\cr
\link[=qldb_list_journal_s3_exports_for_ledger]{list_journal_s3_exports_for_ledger} \tab Returns all journal export jobs for a specified ledger\cr
\link[=qldb_list_ledgers]{list_ledgers} \tab Returns all ledgers that are associated with the current Amazon Web Services account and Region\cr
\link[=qldb_list_tags_for_resource]{list_tags_for_resource} \tab Returns all tags for a specified Amazon QLDB resource\cr
\link[=qldb_stream_journal_to_kinesis]{stream_journal_to_kinesis} \tab Creates a journal stream for a given Amazon QLDB ledger\cr
\link[=qldb_tag_resource]{tag_resource} \tab Adds one or more tags to a specified Amazon QLDB resource\cr
\link[=qldb_untag_resource]{untag_resource} \tab Removes one or more tags from a specified Amazon QLDB resource\cr
\link[=qldb_update_ledger]{update_ledger} \tab Updates properties on a ledger\cr
\link[=qldb_update_ledger_permissions_mode]{update_ledger_permissions_mode} \tab Updates the permissions mode of a ledger
}
}

\examples{
\dontrun{
svc <- qldb()
svc$cancel_journal_kinesis_stream(
  Foo = 123
)
}

}
