% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_engine_default_parameters}
\alias{rds_describe_engine_default_parameters}
\title{Returns the default engine and system parameter information for the
specified database engine}
\usage{
rds_describe_engine_default_parameters(
  DBParameterGroupFamily,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{DBParameterGroupFamily}{[required] The name of the DB parameter group family.

Valid Values:
\itemize{
\item \code{aurora-mysql5.7}
\item \code{aurora-mysql8.0}
\item \code{aurora-postgresql10}
\item \code{aurora-postgresql11}
\item \code{aurora-postgresql12}
\item \code{aurora-postgresql13}
\item \code{aurora-postgresql14}
\item \code{custom-oracle-ee-19}
\item \code{db2-ae}
\item \code{db2-se}
\item \code{mariadb10.2}
\item \code{mariadb10.3}
\item \code{mariadb10.4}
\item \code{mariadb10.5}
\item \code{mariadb10.6}
\item \code{mysql5.7}
\item \code{mysql8.0}
\item \code{oracle-ee-19}
\item \code{oracle-ee-cdb-19}
\item \code{oracle-ee-cdb-21}
\item \code{oracle-se2-19}
\item \code{oracle-se2-cdb-19}
\item \code{oracle-se2-cdb-21}
\item \code{postgres10}
\item \code{postgres11}
\item \code{postgres12}
\item \code{postgres13}
\item \code{postgres14}
\item \code{sqlserver-ee-11.0}
\item \code{sqlserver-ee-12.0}
\item \code{sqlserver-ee-13.0}
\item \code{sqlserver-ee-14.0}
\item \code{sqlserver-ee-15.0}
\item \code{sqlserver-ex-11.0}
\item \code{sqlserver-ex-12.0}
\item \code{sqlserver-ex-13.0}
\item \code{sqlserver-ex-14.0}
\item \code{sqlserver-ex-15.0}
\item \code{sqlserver-se-11.0}
\item \code{sqlserver-se-12.0}
\item \code{sqlserver-se-13.0}
\item \code{sqlserver-se-14.0}
\item \code{sqlserver-se-15.0}
\item \code{sqlserver-web-11.0}
\item \code{sqlserver-web-12.0}
\item \code{sqlserver-web-13.0}
\item \code{sqlserver-web-14.0}
\item \code{sqlserver-web-15.0}
}}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_engine_default_parameters]{describe_engine_default_parameters}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns the default engine and system parameter information for the specified database engine.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_engine_default_parameters/} for full documentation.
}
\keyword{internal}
