% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_list_deployment_targets}
\alias{codedeploy_list_deployment_targets}
\title{Returns an array of target IDs that are associated a deployment}
\usage{
codedeploy_list_deployment_targets(deploymentId, nextToken,
  targetFilters)
}
\arguments{
\item{deploymentId}{The unique ID of a deployment.}

\item{nextToken}{A token identifier returned from the previous
\code{\link[=codedeploy_list_deployment_targets]{list_deployment_targets}} call. It
can be used to return the next set of deployment targets in the list.}

\item{targetFilters}{A key used to filter the returned targets. The two valid values are:
\itemize{
\item \code{TargetStatus} - A \code{TargetStatus} filter string can be \code{Failed},
\code{InProgress}, \code{Pending}, \code{Ready}, \code{Skipped}, \code{Succeeded}, or
\code{Unknown}.
\item \code{ServerInstanceLabel} - A \code{ServerInstanceLabel} filter string can be
\code{Blue} or \code{Green}.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  targetIds = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Returns an array of target IDs that are associated a deployment.
}
\section{Request syntax}{
\preformatted{svc$list_deployment_targets(
  deploymentId = "string",
  nextToken = "string",
  targetFilters = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
