% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_get_insight_impact_graph}
\alias{xray_get_insight_impact_graph}
\title{Retrieves a service graph structure filtered by the specified insight}
\usage{
xray_get_insight_impact_graph(InsightId, StartTime, EndTime, NextToken)
}
\arguments{
\item{InsightId}{[required] The insight's unique identifier. Use the GetInsightSummaries action to
retrieve an InsightId.}

\item{StartTime}{[required] The estimated start time of the insight, in Unix time seconds. The
StartTime is inclusive of the value provided and can't be more than 30
days old.}

\item{EndTime}{[required] The estimated end time of the insight, in Unix time seconds. The EndTime
is exclusive of the value provided. The time range between the start
time and end time can't be more than six hours.}

\item{NextToken}{Specify the pagination token returned by a previous request to retrieve
the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  InsightId = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  ServiceGraphStartTime = as.POSIXct(
    "2015-01-01"
  ),
  ServiceGraphEndTime = as.POSIXct(
    "2015-01-01"
  ),
  Services = list(
    list(
      ReferenceId = 123,
      Type = "string",
      Name = "string",
      Names = list(
        "string"
      ),
      AccountId = "string",
      Edges = list(
        list(
          ReferenceId = 123
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a service graph structure filtered by the specified insight.
The service graph is limited to only structural information. For a
complete service graph, use this API with the GetServiceGraph API.
}
\section{Request syntax}{
\preformatted{svc$get_insight_impact_graph(
  InsightId = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
