# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codestarconnections_service.R
NULL

#' Creates a connection that can then be given to other AWS services like
#' CodePipeline so that it can access third-party code repositories
#'
#' @description
#' Creates a connection that can then be given to other AWS services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/create_connection.html](https://paws-r.github.io/docs/codestarconnections/create_connection.html) for full documentation.
#'
#' @param ProviderType The name of the external provider where your third-party code repository
#' is configured.
#' @param ConnectionName &#91;required&#93; The name of the connection to be created. The name must be unique in the
#' calling AWS account.
#' @param Tags The key-value pair to use when tagging the resource.
#' @param HostArn The Amazon Resource Name (ARN) of the host associated with the
#' connection to be created.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_connection
codestarconnections_create_connection <- function(ProviderType = NULL, ConnectionName, Tags = NULL, HostArn = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_connection_input(ProviderType = ProviderType, ConnectionName = ConnectionName, Tags = Tags, HostArn = HostArn)
  output <- .codestarconnections$create_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_connection <- codestarconnections_create_connection

#' Creates a resource that represents the infrastructure where a
#' third-party provider is installed
#'
#' @description
#' Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/create_host.html](https://paws-r.github.io/docs/codestarconnections/create_host.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the host to be created. The name must be unique in the
#' calling AWS account.
#' @param ProviderType &#91;required&#93; The name of the installed provider to be associated with your
#' connection. The host resource represents the infrastructure where your
#' provider type is installed. The valid provider type is GitHub Enterprise
#' Server.
#' @param ProviderEndpoint &#91;required&#93; The endpoint of the infrastructure to be represented by the host after
#' it is created.
#' @param VpcConfiguration The VPC configuration to be provisioned for the host. A VPC must be
#' configured and the infrastructure to be represented by the host must
#' already be connected to the VPC.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_host
codestarconnections_create_host <- function(Name, ProviderType, ProviderEndpoint, VpcConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_host_input(Name = Name, ProviderType = ProviderType, ProviderEndpoint = ProviderEndpoint, VpcConfiguration = VpcConfiguration, Tags = Tags)
  output <- .codestarconnections$create_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_host <- codestarconnections_create_host

#' The connection to be deleted
#'
#' @description
#' The connection to be deleted.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/delete_connection.html](https://paws-r.github.io/docs/codestarconnections/delete_connection.html) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of the connection to be deleted.
#' 
#' The ARN is never reused if the connection is deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_connection
codestarconnections_delete_connection <- function(ConnectionArn) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_connection_input(ConnectionArn = ConnectionArn)
  output <- .codestarconnections$delete_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_connection <- codestarconnections_delete_connection

#' The host to be deleted
#'
#' @description
#' The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/delete_host.html](https://paws-r.github.io/docs/codestarconnections/delete_host.html) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the host to be deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_host
codestarconnections_delete_host <- function(HostArn) {
  op <- new_operation(
    name = "DeleteHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_host_input(HostArn = HostArn)
  output <- .codestarconnections$delete_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_host <- codestarconnections_delete_host

#' Returns the connection ARN and details such as status, owner, and
#' provider type
#'
#' @description
#' Returns the connection ARN and details such as status, owner, and provider type.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/get_connection.html](https://paws-r.github.io/docs/codestarconnections/get_connection.html) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of a connection.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_connection
codestarconnections_get_connection <- function(ConnectionArn) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_connection_input(ConnectionArn = ConnectionArn)
  output <- .codestarconnections$get_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_connection <- codestarconnections_get_connection

#' Returns the host ARN and details such as status, provider type,
#' endpoint, and, if applicable, the VPC configuration
#'
#' @description
#' Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/get_host.html](https://paws-r.github.io/docs/codestarconnections/get_host.html) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the requested host.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_host
codestarconnections_get_host <- function(HostArn) {
  op <- new_operation(
    name = "GetHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_host_input(HostArn = HostArn)
  output <- .codestarconnections$get_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_host <- codestarconnections_get_host

#' Lists the connections associated with your account
#'
#' @description
#' Lists the connections associated with your account.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/list_connections.html](https://paws-r.github.io/docs/codestarconnections/list_connections.html) for full documentation.
#'
#' @param ProviderTypeFilter Filters the list of connections to those associated with a specified
#' provider, such as Bitbucket.
#' @param HostArnFilter Filters the list of connections to those associated with a specified
#' host.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token that was returned from the previous
#' [`list_connections`][codestarconnections_list_connections] call, which
#' can be used to return the next set of connections in the list.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_connections
codestarconnections_list_connections <- function(ProviderTypeFilter = NULL, HostArnFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$list_connections_input(ProviderTypeFilter = ProviderTypeFilter, HostArnFilter = HostArnFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .codestarconnections$list_connections_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_connections <- codestarconnections_list_connections

#' Lists the hosts associated with your account
#'
#' @description
#' Lists the hosts associated with your account.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/list_hosts.html](https://paws-r.github.io/docs/codestarconnections/list_hosts.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token that was returned from the previous
#' [`list_hosts`][codestarconnections_list_hosts] call, which can be used
#' to return the next set of hosts in the list.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_hosts
codestarconnections_list_hosts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$list_hosts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .codestarconnections$list_hosts_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_hosts <- codestarconnections_list_hosts

#' Gets the set of key-value pairs (metadata) that are used to manage the
#' resource
#'
#' @description
#' Gets the set of key-value pairs (metadata) that are used to manage the resource.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/list_tags_for_resource.html](https://paws-r.github.io/docs/codestarconnections/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to get
#' information about tags, if any.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_tags_for_resource
codestarconnections_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .codestarconnections$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_tags_for_resource <- codestarconnections_list_tags_for_resource

#' Adds to or modifies the tags of the given resource
#'
#' @description
#' Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/tag_resource.html](https://paws-r.github.io/docs/codestarconnections/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which you want to add
#' or update tags.
#' @param Tags &#91;required&#93; The tags you want to modify or add to the resource.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_tag_resource
codestarconnections_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .codestarconnections$tag_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$tag_resource <- codestarconnections_tag_resource

#' Removes tags from an AWS resource
#'
#' @description
#' Removes tags from an AWS resource.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/untag_resource.html](https://paws-r.github.io/docs/codestarconnections/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from.
#' @param TagKeys &#91;required&#93; The list of keys for the tags to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_untag_resource
codestarconnections_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .codestarconnections$untag_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$untag_resource <- codestarconnections_untag_resource

#' Updates a specified host with the provided configurations
#'
#' @description
#' Updates a specified host with the provided configurations.
#'
#' See [https://paws-r.github.io/docs/codestarconnections/update_host.html](https://paws-r.github.io/docs/codestarconnections/update_host.html) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the host to be updated.
#' @param ProviderEndpoint The URL or endpoint of the host to be updated.
#' @param VpcConfiguration The VPC configuration of the host to be updated. A VPC must be
#' configured and the infrastructure to be represented by the host must
#' already be connected to the VPC.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_update_host
codestarconnections_update_host <- function(HostArn, ProviderEndpoint = NULL, VpcConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$update_host_input(HostArn = HostArn, ProviderEndpoint = ProviderEndpoint, VpcConfiguration = VpcConfiguration)
  output <- .codestarconnections$update_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$update_host <- codestarconnections_update_host
