% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_merge_conflicts}
\alias{codecommit_get_merge_conflicts}
\title{Returns information about merge conflicts between the before and after
commit IDs for a pull request in a repository}
\usage{
codecommit_get_merge_conflicts(
  repositoryName,
  destinationCommitSpecifier,
  sourceCommitSpecifier,
  mergeOption,
  conflictDetailLevel = NULL,
  maxConflictFiles = NULL,
  conflictResolutionStrategy = NULL,
  nextToken = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where the pull request was created.}

\item{destinationCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{sourceCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{mergeOption}{[required] The merge option or strategy you want to use to merge the code.}

\item{conflictDetailLevel}{The level of conflict detail to use. If unspecified, the default
FILE_LEVEL is used, which returns a not-mergeable result if the same
file has differences in both branches. If LINE_LEVEL is specified, a
conflict is considered not mergeable if the same file in both branches
has differences on the same line.}

\item{maxConflictFiles}{The maximum number of files to include in the output.}

\item{conflictResolutionStrategy}{Specifies which branch to use when resolving conflicts, or whether to
attempt automatically merging two versions of a file. The default is
NONE, which requires any conflicts to be resolved manually before the
merge operation is successful.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}
}
\description{
Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.

See \url{https://paws-r.github.io/docs/codecommit/get_merge_conflicts.html} for full documentation.
}
\keyword{internal}
